/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchema;
import software.amazon.awssdk.services.supplychain.model.SupplyChainRequest;
import software.amazon.awssdk.services.supplychain.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataLakeDatasetRequest
extends SupplyChainRequest
implements ToCopyableBuilder<Builder, CreateDataLakeDatasetRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::instanceId)).setter(CreateDataLakeDatasetRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::namespace)).setter(CreateDataLakeDatasetRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::name)).setter(CreateDataLakeDatasetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<DataLakeDatasetSchema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schema").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::schema)).setter(CreateDataLakeDatasetRequest.setter(Builder::schema)).constructor(DataLakeDatasetSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::description)).setter(CreateDataLakeDatasetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDataLakeDatasetRequest.getter(CreateDataLakeDatasetRequest::tags)).setter(CreateDataLakeDatasetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAMESPACE_FIELD, NAME_FIELD, SCHEMA_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataLakeDatasetRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String namespace;
    private final String name;
    private final DataLakeDatasetSchema schema;
    private final String description;
    private final Map<String, String> tags;

    private CreateDataLakeDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.schema = builder.schema;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final DataLakeDatasetSchema schema() {
        return this.schema;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeDatasetRequest)) {
            return false;
        }
        CreateDataLakeDatasetRequest other = (CreateDataLakeDatasetRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataLakeDatasetRequest").add("InstanceId", (Object)this.instanceId()).add("Namespace", (Object)this.namespace()).add("Name", (Object)this.name()).add("Schema", (Object)this.schema()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataLakeDatasetRequest, T> g) {
        return obj -> g.apply((CreateDataLakeDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String namespace;
        private String name;
        private DataLakeDatasetSchema schema;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataLakeDatasetRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.namespace(model.namespace);
            this.name(model.name);
            this.schema(model.schema);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataLakeDatasetSchema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(DataLakeDatasetSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(DataLakeDatasetSchema schema) {
            this.schema = schema;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataLakeDatasetRequest build() {
            return new CreateDataLakeDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupplyChainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataLakeDatasetRequest> {
        public Builder instanceId(String var1);

        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder schema(DataLakeDatasetSchema var1);

        default public Builder schema(Consumer<DataLakeDatasetSchema.Builder> schema) {
            return this.schema((DataLakeDatasetSchema)((DataLakeDatasetSchema.Builder)DataLakeDatasetSchema.builder().applyMutation(schema)).build());
        }

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

