/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainAsyncClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse;

public class ListDataIntegrationFlowsPublisher
implements SdkPublisher<ListDataIntegrationFlowsResponse> {
    private final SupplyChainAsyncClient client;
    private final ListDataIntegrationFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIntegrationFlowsPublisher(SupplyChainAsyncClient client, ListDataIntegrationFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIntegrationFlowsPublisher(SupplyChainAsyncClient client, ListDataIntegrationFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIntegrationFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIntegrationFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataIntegrationFlow> flows() {
        Function<ListDataIntegrationFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataIntegrationFlowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataIntegrationFlowsResponseFetcher
    implements AsyncPageFetcher<ListDataIntegrationFlowsResponse> {
        private ListDataIntegrationFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIntegrationFlowsResponse> nextPage(ListDataIntegrationFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationFlowsPublisher.this.client.listDataIntegrationFlows(ListDataIntegrationFlowsPublisher.this.firstRequest);
            }
            return ListDataIntegrationFlowsPublisher.this.client.listDataIntegrationFlows((ListDataIntegrationFlowsRequest)((Object)ListDataIntegrationFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

