/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataLakeDataset;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse;

public class ListDataLakeDatasetsIterable
implements SdkIterable<ListDataLakeDatasetsResponse> {
    private final SupplyChainClient client;
    private final ListDataLakeDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataLakeDatasetsIterable(SupplyChainClient client, ListDataLakeDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataLakeDatasetsResponseFetcher();
    }

    public Iterator<ListDataLakeDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataLakeDataset> datasets() {
        Function<ListDataLakeDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasets() != null) {
                return response.datasets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataLakeDatasetsResponseFetcher
    implements SyncPageFetcher<ListDataLakeDatasetsResponse> {
        private ListDataLakeDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataLakeDatasetsResponse nextPage(ListDataLakeDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeDatasetsIterable.this.client.listDataLakeDatasets(ListDataLakeDatasetsIterable.this.firstRequest);
            }
            return ListDataLakeDatasetsIterable.this.client.listDataLakeDatasets((ListDataLakeDatasetsRequest)((Object)ListDataLakeDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

