/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.ClientConfiguration;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.slf4j.bridge.SLF4JBridgeHandler;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.Warning;

public class TimestreamDriver
implements Driver {
    private static final Logger LOGGER = Logger.getLogger("software.amazon.timestream.jdbc.TimestreamDriver");
    static final int DRIVER_MAJOR_VERSION;
    static final int DRIVER_MINOR_VERSION;
    static final String DRIVER_VERSION;
    static final String APP_NAME_SUFFIX;
    static final String APPLICATION_NAME;

    @Override
    public boolean acceptsURL(String url) {
        if (null == url) {
            LOGGER.warning(Warning.lookup(Warning.NULL_URL, new Object[0]));
            return false;
        }
        if (!(url = url.trim()).startsWith("jdbc:timestream")) {
            LOGGER.finer(Warning.lookup(Warning.UNSUPPORTED_URL_PREFIX, url));
            return false;
        }
        return (url = url.substring("jdbc:timestream".length())).isEmpty() || url.startsWith("://");
    }

    @Override
    public TimestreamConnection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            LOGGER.finer("Unsupported URL: " + url);
            return null;
        }
        LOGGER.fine("Timestream JDBC driver version: " + DRIVER_VERSION);
        LOGGER.finer("Instantiating a TimestreamConnection from TimestreamDriver.");
        return this.createTimestreamConnection(this.parseUrl(url, info), new ClientConfiguration().withUserAgentSuffix(TimestreamDriver.getUserAgentSuffix()));
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_MINOR_VERSION;
    }

    @Override
    public Logger getParentLogger() {
        return LOGGER;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        String tempUrl;
        if (this.acceptsURL(url)) {
            tempUrl = url;
        } else {
            LOGGER.warning("Unsupported input URL: \"" + url + "\", the default URL \"" + "jdbc:timestream" + "\" will be used.");
            tempUrl = "jdbc:timestream";
        }
        Properties finalInfo = this.parseUrl(tempUrl, info);
        return (DriverPropertyInfo[])Stream.of(TimestreamConnectionProperty.values()).map(value -> {
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(value.getConnectionProperty(), finalInfo.getProperty(value.getConnectionProperty()));
            driverPropertyInfo.description = value.getDescription();
            return driverPropertyInfo;
        }).toArray(DriverPropertyInfo[]::new);
    }

    static String getUserAgentSuffix() {
        return "ts-jdbc." + DRIVER_VERSION + APP_NAME_SUFFIX;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private static String getApplicationName() {
        return "Unknown";
    }

    protected TimestreamConnection createTimestreamConnection(Properties properties, ClientConfiguration configuration) throws SQLException {
        return new TimestreamConnection(properties, configuration);
    }

    private Properties parseUrl(String url, Properties info) throws SQLException {
        if (null == url) {
            LOGGER.warning("The URL passed to TimestreamDriver#parseUrl is null. This should not be possible.");
            return new Properties();
        }
        String trimmedUrl = url.trim().substring("jdbc:timestream".length());
        if (!Strings.isNullOrEmpty((String)trimmedUrl)) {
            trimmedUrl = trimmedUrl.substring("://".length());
        }
        Properties allProperties = new Properties();
        if (null != info) {
            info.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String keyString = key.toString();
                if (TimestreamConnectionProperty.isSupportedProperty(keyString)) {
                    allProperties.put(keyString, value);
                } else {
                    LOGGER.warning("Ignored unsupported property: " + keyString);
                }
            }));
        }
        if (!Strings.isNullOrEmpty((String)trimmedUrl)) {
            for (String keyValueStr : trimmedUrl.split(";")) {
                String[] keyValue = keyValueStr.trim().split("=");
                if (2 != keyValue.length || keyValue[0].isEmpty()) {
                    throw Error.createSQLException(LOGGER, Error.INVALID_CONNECTION_PROPERTIES, url);
                }
                String trimmedKeyStr = keyValue[0].trim();
                if (TimestreamConnectionProperty.isSupportedProperty(trimmedKeyStr)) {
                    allProperties.put(trimmedKeyStr, keyValue[1]);
                    continue;
                }
                LOGGER.warning("Ignored unsupported property: " + trimmedKeyStr);
            }
        }
        return allProperties;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LOGGER.setLevel(Level.FINE);
        APPLICATION_NAME = TimestreamDriver.getApplicationName();
        APP_NAME_SUFFIX = " [" + APPLICATION_NAME + "]";
        LOGGER.finer("Name of the application using the driver: " + APP_NAME_SUFFIX);
        int majorVersion = 0;
        int minorVersion = 0;
        String fullVersion = "";
        try (InputStream is = TimestreamDriver.class.getResourceAsStream("version.properties");){
            Properties p = new Properties();
            p.load(is);
            majorVersion = Integer.parseInt(p.getProperty("driver.major.version"));
            minorVersion = Integer.parseInt(p.getProperty("driver.minor.version"));
            fullVersion = p.getProperty("driver.version");
        }
        catch (Exception e) {
            LOGGER.severe("Error loading driver version: " + e.getMessage());
        }
        DRIVER_MAJOR_VERSION = majorVersion;
        DRIVER_MINOR_VERSION = minorVersion;
        DRIVER_VERSION = fullVersion;
        try {
            DriverManager.registerDriver(new TimestreamDriver());
        }
        catch (SQLException e) {
            LOGGER.severe("Error registering driver: " + e.getMessage());
        }
    }
}

