/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamSAMLCredentialsProvider;

class TimestreamOktaCredentialsProvider
extends TimestreamSAMLCredentialsProvider {
    private final String appID;
    private final String idpHost;

    TimestreamOktaCredentialsProvider(CloseableHttpClient httpClient, Map<String, String> oktaFieldsMap) {
        super(httpClient, oktaFieldsMap);
        this.appID = oktaFieldsMap.get(TimestreamConnectionProperty.OKTA_APP_ID.getConnectionProperty());
        this.idpHost = oktaFieldsMap.get(TimestreamConnectionProperty.IDP_HOST.getConnectionProperty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String getSAMLAssertion() throws SQLException {
        String sessionToken = this.getSessionToken();
        String baseUri = "https://" + this.idpHost + "/app/" + "amazon_aws" + "/" + this.appID + "/sso/saml";
        HttpUriRequest samlGetRequest = RequestBuilder.get().setUri(baseUri).addParameter("onetimetoken", sessionToken).build();
        try (CloseableHttpResponse response = this.httpClient.execute(samlGetRequest);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw Error.createSQLException(LOGGER, Error.OKTA_SAML_ASSERTION_REQUEST_FAILED, new Object[0]);
            }
            HttpEntity responseEntity = response.getEntity();
            String responseHTMLAsString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            Document document = Jsoup.parse((String)responseHTMLAsString);
            Optional<String> samlResponseValue = Optional.ofNullable(document.selectFirst("[name=SAMLResponse]")).map(field -> field.attr("value"));
            if (!samlResponseValue.isPresent()) {
                throw Error.createSQLException(LOGGER, Error.INVALID_SAML_RESPONSE, new Object[0]);
            }
            String string = samlResponseValue.get();
            return string;
        }
        catch (IOException e) {
            throw Error.createSQLException(LOGGER, e, Error.OKTA_SAML_ASSERTION_ERROR, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSessionToken() throws SQLException {
        String sessionTokenEndpoint = "https://" + this.idpHost + "/api/v1/authn";
        try {
            StringEntity requestBodyEntity = new StringEntity("{\"username\":\"" + this.userName + "\",\"password\":\"" + this.password + "\"}", "UTF-8");
            HttpUriRequest sessionTokenRequest = RequestBuilder.post().setUri(sessionTokenEndpoint).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").setEntity((HttpEntity)requestBodyEntity).build();
            LOGGER.debug("Fetching Okta session token from: \n" + sessionTokenEndpoint);
            try (CloseableHttpResponse response = this.httpClient.execute(sessionTokenRequest);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    throw Error.createSQLException(LOGGER, Error.OKTA_SESSION_TOKEN_REQUEST_FAILED, new Object[0]);
                }
                HttpEntity responseEntity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                JsonNode jsonNode = OBJECT_MAPPER.readTree(responseString).get("sessionToken");
                if (jsonNode == null) {
                    throw Error.createSQLException(LOGGER, Error.INVALID_SESSION_TOKEN_RESPONSE, new Object[0]);
                }
                String string = jsonNode.asText();
                return string;
            }
        }
        catch (IOException e) {
            throw Error.createSQLException(LOGGER, e, Error.OKTA_SESSION_TOKEN_ERROR, new Object[0]);
        }
    }
}

