/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamDataType;

public class TimestreamTypeInfoResultSet
extends TimestreamBaseResultSet {
    private static final Datum NULL_DATUM = new Datum().withNullValue(Boolean.TRUE);
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TYPE_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "DATA_TYPE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "PRECISION"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "LITERAL_PREFIX"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "LITERAL_SUFFIX"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "CREATE_PARAMS"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "NULLABLE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.BOOLEAN, "CASE_SENSITIVE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SEARCHABLE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.BOOLEAN, "UNSIGNED_ATTRIBUTE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.BOOLEAN, "FIXED_PREC_SCALE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.BOOLEAN, "AUTO_INCREMENT"), (Object[])new ColumnInfo[]{TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "LOCAL_TYPE_NAME"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "MINIMUM_SCALE"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "MAXIMUM_SCALE"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SQL_DATA_TYPE"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SQL_DATETIME_SUB"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "NUM_PREC_RADIX")});
    private final List<Row> types = new ArrayList<Row>();
    private boolean isAfterLast = false;

    public TimestreamTypeInfoResultSet() {
        super(null, 1000);
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.populateCurrentRows();
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected boolean doNextPage() {
        this.isAfterLast = true;
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.isAfterLast;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return !this.isAfterLast && !this.rowItr.hasNext();
    }

    private void populateCurrentRows() {
        Stream.of(TimestreamDataType.values()).forEach(type -> this.types.add(new Row().withData(new Datum[]{TimestreamTypeInfoResultSet.createDatum(type.toString()), TimestreamTypeInfoResultSet.createDatum(type.getJdbcType().jdbcCode), TimestreamTypeInfoResultSet.createDatum(type.getPrecision()), this.getPrefixes((TimestreamDataType)((Object)type)), this.getSuffixes((TimestreamDataType)((Object)type)), NULL_DATUM, TimestreamTypeInfoResultSet.createDatum(1), type == TimestreamDataType.VARCHAR ? TimestreamTypeInfoResultSet.createDatum(Boolean.TRUE.toString()) : NULL_DATUM, TimestreamTypeInfoResultSet.createDatum(3), TimestreamTypeInfoResultSet.createDatum(Boolean.FALSE.toString()), TimestreamTypeInfoResultSet.createDatum(Boolean.FALSE.toString()), TimestreamTypeInfoResultSet.createDatum(Boolean.FALSE.toString()), TimestreamTypeInfoResultSet.createDatum(type.getClassName()), type == TimestreamDataType.TIME || type == TimestreamDataType.TIMESTAMP ? TimestreamTypeInfoResultSet.createDatum(9) : NULL_DATUM, type == TimestreamDataType.TIME || type == TimestreamDataType.TIMESTAMP ? TimestreamTypeInfoResultSet.createDatum(9) : NULL_DATUM, TimestreamTypeInfoResultSet.createDatum(type.getJdbcType().jdbcCode), type == TimestreamDataType.DATE || type == TimestreamDataType.TIME || type == TimestreamDataType.TIMESTAMP ? TimestreamTypeInfoResultSet.createDatum(type.getJdbcType().jdbcCode % 90) : NULL_DATUM, type == TimestreamDataType.DOUBLE ? TimestreamTypeInfoResultSet.createDatum(10) : NULL_DATUM})));
        this.rowItr = this.types.iterator();
    }

    private Datum getPrefixes(TimestreamDataType type) {
        switch (type) {
            case VARCHAR: {
                return TimestreamTypeInfoResultSet.createDatum("'");
            }
            case BIGINT: {
                return TimestreamTypeInfoResultSet.createDatum("BIGINT '");
            }
            case DOUBLE: {
                return TimestreamTypeInfoResultSet.createDatum("DOUBLE '");
            }
            case INTEGER: {
                return TimestreamTypeInfoResultSet.createDatum("INT '");
            }
        }
        return NULL_DATUM;
    }

    private Datum getSuffixes(TimestreamDataType type) {
        switch (type) {
            case VARCHAR: 
            case BIGINT: 
            case DOUBLE: 
            case INTEGER: {
                return TimestreamTypeInfoResultSet.createDatum("'");
            }
        }
        return NULL_DATUM;
    }
}

