/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.altus.AltusJob;
import org.talend.bigdata.launcher.altus.AltusJobUtil;
import org.talend.bigdata.launcher.altus.CloudConfiguration;

public class AltusSparkWithClusterCreationJob
extends AltusJob {
    private static Logger SPARK_LOG = LoggerFactory.getLogger(AltusSparkWithClusterCreationJob.class);
    private String environmentName;
    private boolean deleteAfterExecution = false;
    private boolean useCustomJson = false;
    private String customJson;
    private String instanceType;
    private String workderNode;
    private String sshKey;
    private String clouderaManagerUsername;
    private String clouderaManagerPassword;
    private String clusterId;
    private Pattern statusPattern = Pattern.compile("\"status\": \"([^\"]+)\"");
    private String customBootstrapScript;

    private AltusSparkWithClusterCreationJob(String talendJobName, String clusterName, String environmentName, String cloudProvider, boolean deleteAfterExecution, boolean setCredentials, String accessKey, String secretKey, CloudConfiguration cloudConfiguration, String jarsBucket, boolean useCustomJson, String customJson, String instanceType, String workderNode, String sshKey, String clouderaManagerUsername, String clouderaManagerPassword, String pathToAltusCLI, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel, String customBootstrapScript) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.environmentName = environmentName;
        this.deleteAfterExecution = deleteAfterExecution;
        this.setCredentials = setCredentials;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.useCustomJson = useCustomJson;
        this.customJson = customJson;
        this.instanceType = instanceType;
        this.workderNode = workderNode;
        this.sshKey = sshKey;
        this.clouderaManagerUsername = clouderaManagerUsername;
        this.clouderaManagerPassword = clouderaManagerPassword;
        this.pathToAltusCLI = pathToAltusCLI;
        this.conf = conf;
        this.mainClass = mainClass;
        this.jarToExecute = jarToExecute;
        this.libJars = libJars;
        this.args = args;
        if (StringUtils.isNotEmpty((CharSequence)logLevel)) {
            // empty if block
        }
        this.cloudConfiguration = cloudConfiguration;
        this.customBootstrapScript = customBootstrapScript;
    }

    @Override
    public void cancelJob() throws Exception {
        super.cancelJob();
        if (this.jobDone || !this.deleteAfterExecution) {
            SPARK_LOG.info("No need to send a cluster cancel request for " + this.getTalendJobName());
        } else {
            if (this.clusterId == null) {
                SPARK_LOG.info("Do not have Altus cluster need to be cancelled for " + this.getTalendJobName());
                return;
            }
            SPARK_LOG.info("Sending cancel request for cluster " + this.getTalendJobName());
            Process process = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "dataeng", "delete-cluster", "--cluster-name", this.clusterId});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
            if (jobLog.length() > 0) {
                SPARK_LOG.info(jobLog);
            } else {
                SPARK_LOG.error(AltusJobUtil.readStdBufferedReader(stdError));
            }
            stdInput.close();
            stdError.close();
        }
    }

    public void connect() {
        if (this.setCredentials) {
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "configure"});
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedWriter stdOutput = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
                String secretKeyValue = "";
                if (this.secretKey != null) {
                    try {
                        String sCurrentLine;
                        BufferedReader br = new BufferedReader(new FileReader(this.secretKey));
                        while ((sCurrentLine = br.readLine()) != null) {
                            secretKeyValue = secretKeyValue + sCurrentLine + "\\n";
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        SPARK_LOG.error(e.getMessage());
                    }
                }
                stdOutput.write(this.accessKey);
                stdOutput.newLine();
                stdOutput.write(secretKeyValue.substring(0, secretKeyValue.length() - 2));
                stdOutput.newLine();
                stdOutput.flush();
                stdOutput.close();
                String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
                if (jobLog.length() > 0) {
                    SPARK_LOG.info(jobLog);
                } else {
                    SPARK_LOG.error(AltusJobUtil.readStdBufferedReader(stdError));
                }
                System.out.println(AltusJobUtil.readStdBufferedReader(stdError));
                stdInput.close();
                stdError.close();
            }
            catch (IOException e) {
                SPARK_LOG.error("Cannot set Altus credentials:");
                SPARK_LOG.error(e.getMessage());
            }
        }
    }

    public String[] getCommandLine(String jobArgument) {
        String sshKeyContent = this.cloudConfiguration.getSshKeyContent(this.sshKey);
        ArrayList<String> commandLineList = new ArrayList<String>(Arrays.asList(this.pathToAltusCLI, "dataeng", this.cloudConfiguration.getClusterCreationCommand(), "--cluster-name", this.clusterName, "--cdh-version", this.cloudConfiguration.getCdhVersion(), this.cloudConfiguration.getSshKeyArg(), sshKeyContent, "--instance-type", this.instanceType, "--service-type", "SPARK", "--environment-name", this.environmentName, "--workers-group-size", this.workderNode, "--cloudera-manager-username", this.clouderaManagerUsername, "--cloudera-manager-password", this.clouderaManagerPassword));
        if (StringUtils.isNotEmpty((CharSequence)this.customBootstrapScript)) {
            commandLineList.addAll(Arrays.asList("--instance-bootstrap-script", "file://" + this.customBootstrapScript));
        }
        commandLineList.addAll(Arrays.asList("--automatic-termination-condition", this.deleteAfterExecution ? "EMPTY_JOB_QUEUE" : "NONE", "--jobs", "[" + jobArgument + "]"));
        return commandLineList.toArray(new String[0]);
    }

    public Process getProcess(String jobArgument) throws IOException {
        SPARK_LOG.debug("Executing command line:");
        if (this.useCustomJson) {
            SPARK_LOG.info(this.pathToAltusCLI + "dataeng " + this.cloudConfiguration.getClusterCreationCommand() + " --cluster-name " + this.clusterName + " --cdh-version " + this.cloudConfiguration.getCdhVersion() + " " + this.cloudConfiguration.getSshKeyArg() + " <Retrieve from + " + this.sshKey + ">  --instance-type " + this.instanceType + " --service-type Spark --environment-name " + this.environmentName + " --job-submission-group-name " + this.talendJobName + " --cli-input-json " + this.customJson + " --jobs [" + jobArgument + "]");
            return Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "dataeng", this.cloudConfiguration.getClusterCreationCommand(), "--cluster-name", this.clusterName, "--cdh-version", this.cloudConfiguration.getCdhVersion(), "--service-type", "SPARK", "--environment-name", this.environmentName, "--job-submission-group-name", this.talendJobName, "--cli-input-json", this.customJson, "--jobs", "[" + jobArgument + "]"});
        }
        CharSequence[] commandLine = this.getCommandLine(jobArgument);
        SPARK_LOG.info(String.join((CharSequence)" ", commandLine));
        return Runtime.getRuntime().exec((String[])commandLine);
    }

    @Override
    protected void execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        this.connect();
        String jobArgument = AltusJobUtil.generateJobArgument(this.talendJobName, this.mainClass, jarsFileUris, this.args, this.conf);
        Process p = this.getProcess(jobArgument);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
        if (jobLog.length() > 0) {
            String log = jobLog.toString();
            SPARK_LOG.info(AltusJobUtil.maskAwsAccessSecretKeyInSparkConf(log));
            Matcher clusterNameMatcher = Pattern.compile("\"clusterName\": \"([^\"]+)\"").matcher(log);
            Matcher crnMatcher = Pattern.compile("\"crn\": \"([^\"]+)\"").matcher(log);
            if (clusterNameMatcher.find() && crnMatcher.find()) {
                this.clusterId = clusterNameMatcher.group(1);
                this.jobId = AltusJobUtil.getJobId(this.pathToAltusCLI, crnMatcher.group(1));
                SPARK_LOG.info("Start pooling information for cluster \"" + this.clusterId + "\" and job \"" + this.jobId + "\"");
            }
        } else {
            SPARK_LOG.error(AltusJobUtil.readStdBufferedReader(stdError));
        }
        stdInput.close();
        stdError.close();
    }

    @Override
    protected String waitJobProcessing() throws InterruptedException, IOException, GeneralSecurityException {
        String clusterStatus = AltusJobUtil.STATUS_CLUSTER_CREATING;
        String jobStatus = AltusJobUtil.STATUS_JOB_QUEUED;
        boolean hasTerminated = false;
        while (AltusJobUtil.needToMonitorTheJob(clusterStatus, jobStatus, this.deleteAfterExecution)) {
            Thread.sleep(5000L);
            Process process = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "dataeng", "list-clusters", "--cluster-name", "[" + AltusJobUtil.wrapEscapeQuote(this.clusterId) + "]"});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
            if (jobLog.length() > 0) {
                SPARK_LOG.debug(jobLog);
                Matcher matcher = this.statusPattern.matcher(jobLog);
                if (matcher.find()) {
                    clusterStatus = matcher.group(1);
                    if (AltusJobUtil.STATUS_CLUSTER_TERMINATING.equals(clusterStatus)) {
                        SPARK_LOG.info("The processing is finished, the cluster is now going to shut down.");
                        if (!hasTerminated) {
                            jobStatus = AltusJobUtil.retrieveJobStatus(this.jobId, this.pathToAltusCLI);
                            hasTerminated = true;
                        }
                    } else if (AltusJobUtil.STATUS_CLUSTER_CREATED.equals(clusterStatus)) {
                        SPARK_LOG.info("The cluster is created, waiting for the job to be processed.");
                        jobStatus = AltusJobUtil.retrieveJobStatus(this.jobId, this.pathToAltusCLI);
                    } else if (AltusJobUtil.STATUS_CLUSTER_CREATING.equals(clusterStatus)) {
                        SPARK_LOG.info("The cluster is instanciating, please wait.");
                    }
                } else {
                    clusterStatus = AltusJobUtil.STATUS_CLUSTER_ERROR;
                }
            } else {
                String errorJobLog = AltusJobUtil.readStdBufferedReader(stdError);
                if (hasTerminated) {
                    SPARK_LOG.info("The cluster was correctly shutdown.");
                    SPARK_LOG.debug("Initial API message:");
                    SPARK_LOG.debug(errorJobLog);
                    clusterStatus = AltusJobUtil.STATUS_CLUSTER_TERMINATED;
                } else {
                    SPARK_LOG.error("The cluster was unexpectedly closed.");
                    SPARK_LOG.error(errorJobLog);
                    clusterStatus = AltusJobUtil.STATUS_CLUSTER_ERROR;
                }
            }
            SPARK_LOG.debug("Cluster status: " + clusterStatus);
            SPARK_LOG.debug("Job status: " + jobStatus);
            SPARK_LOG.debug("Polling again: " + AltusJobUtil.needToMonitorTheJob(clusterStatus, jobStatus, this.deleteAfterExecution));
            stdInput.close();
            stdError.close();
        }
        if (this.deleteAfterExecution && AltusJobUtil.STATUS_JOB_COMPLETED.equals(jobStatus)) {
            return clusterStatus;
        }
        return jobStatus;
    }

    public static class Builder {
        protected String serviceAccountCredentialsPath;
        protected String libJars;
        protected String jarToExecute;
        protected String mainClass;
        protected List<String> args;
        protected Map<String, String> conf;
        protected String talendJobName;
        protected String clusterName;
        protected String environmentName;
        protected String cloudProvider;
        protected boolean deleteAfterExecution = false;
        protected boolean setCredentials = false;
        protected String accessKey;
        protected String secretKey;
        protected String s3AccessKey;
        protected String s3SecretKey;
        protected String s3Region;
        protected String bucketName;
        protected String jarsBucket;
        protected boolean useCustomJson = false;
        protected String customJson;
        protected String instanceType;
        protected String workderNode;
        protected String sshKey;
        protected String clouderaManagerUsername;
        protected String clouderaManagerPassword;
        protected String pathToAltusCLI;
        protected String logLevel;
        protected CloudConfiguration cloudConfiguration;
        private String customBootstrapScript;

        public Builder withJarToExecute(String jarToExecute) {
            this.jarToExecute = jarToExecute;
            return this;
        }

        public Builder withMainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder withLibJars(String libJars) {
            this.libJars = libJars;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public Builder withCloudProvider(String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        public Builder withDeleteAfterExecution(boolean deleteAfterExecution) {
            this.deleteAfterExecution = deleteAfterExecution;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.talendJobName = talendJobName;
            return this;
        }

        public Builder setCredentials(boolean setCredentials) {
            this.setCredentials = setCredentials;
            return this;
        }

        public Builder withAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.secretKey = secretKey.replace("\n", "\\n");
            return this;
        }

        public Builder withS3AccessKey(String s3AccessKey) {
            this.s3AccessKey = s3AccessKey;
            return this;
        }

        public Builder withS3SecretKey(String s3SecretKey) {
            this.s3SecretKey = s3SecretKey;
            return this;
        }

        public Builder withS3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public Builder withBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder withUseCustomJson(boolean useCustomJson) {
            this.useCustomJson = useCustomJson;
            return this;
        }

        public Builder withCustomJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public Builder withInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder withWorkderNode(String workderNode) {
            this.workderNode = workderNode;
            return this;
        }

        public Builder withSshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public Builder withClouderaManagerUsername(String clouderaManagerUsername) {
            this.clouderaManagerUsername = clouderaManagerUsername;
            return this;
        }

        public Builder withClouderaManagerPassword(String clouderaManagerPassword) {
            this.clouderaManagerPassword = clouderaManagerPassword;
            return this;
        }

        public Builder withPathToAltusCLI(String pathToAltusCLI) {
            this.pathToAltusCLI = pathToAltusCLI;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.conf = conf;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withLogLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withCloudConfiguration(CloudConfiguration cloudConfiguration) {
            this.cloudConfiguration = cloudConfiguration;
            return this;
        }

        public AltusSparkWithClusterCreationJob build() {
            return new AltusSparkWithClusterCreationJob(this.talendJobName, this.clusterName, this.environmentName, this.cloudProvider, this.deleteAfterExecution, this.setCredentials, this.accessKey, this.secretKey, this.cloudConfiguration, this.jarsBucket, this.useCustomJson, this.customJson, this.instanceType, this.workderNode, this.sshKey, this.clouderaManagerUsername, this.clouderaManagerPassword, this.pathToAltusCLI, this.conf, this.mainClass, this.jarToExecute, this.libJars, this.args, this.logLevel, this.customBootstrapScript);
        }

        public Builder withCustomBootstrapScript(String bootstrapScript) {
            this.customBootstrapScript = bootstrapScript;
            return this;
        }
    }
}

