/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOG;
    private static final Random random;
    public static final int IO_ERROR_SLEEP_TIME = 100;
    public static final PathFilter HIDDEN_FILES_PATH_FILTER;
    public static final PathFilter STAGING_DIR_PATH_FILTER;
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, String name) {
        String defaultDir = FileUtils.escapePathName(name);
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static String makeListBucketingDirName(List<String> lbCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < lbCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(lbCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (FileUtils.isS3a(fs)) {
            FileUtils.listS3FilesRecursive(fileStatus, fs, results);
        } else {
            FileUtils.generalListStatusRecursively(fs, fileStatus, results);
        }
    }

    private static void generalListStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), HIDDEN_FILES_PATH_FILTER)) {
                FileUtils.generalListStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    private static void listS3FilesRecursive(FileStatus base, FileSystem fs, List<FileStatus> results) throws IOException {
        if (!base.isDirectory()) {
            results.add(base);
            return;
        }
        RemoteIterator remoteIterator = fs.listFiles(base.getPath(), true);
        while (remoteIterator.hasNext()) {
            LocatedFileStatus each = (LocatedFileStatus)remoteIterator.next();
            Path relativePath = new Path(each.getPath().toString().replace(base.toString(), ""));
            if (!FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER.accept(relativePath)) continue;
            results.add((FileStatus)each);
        }
    }

    public static boolean isS3a(FileSystem fs) {
        try {
            return "s3a".equalsIgnoreCase(fs.getScheme());
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    public static FileStatus getPathOrParentThatExists(FileSystem fs, Path path) throws IOException {
        FileStatus stat = FileUtils.getFileStatusOrNull(fs, path);
        if (stat != null) {
            return stat;
        }
        Path parentPath = path.getParent();
        return FileUtils.getPathOrParentThatExists(fs, parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFileAccessWithImpersonation(FileSystem fs, FileStatus stat, FsAction action, String user) throws Exception {
        UserGroupInformation proxyUser = null;
        try {
            proxyUser = FileUtils.getProxyUser(user);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            FileUtils.checkFileAccessWithImpersonation(fs, stat, action, user, null, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
    }

    public static void checkFileAccessWithImpersonation(FileSystem fs, final FileStatus stat, final FsAction action, String user, final List<FileStatus> children, final FileSystem fsAsUser) throws IOException, AccessControlException, InterruptedException, Exception {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        if (user == null || currentUser.equals(user)) {
            ShimLoader.getHadoopShims().checkFileAccess(fs, stat, action);
            FileUtils.addChildren(fs, stat.getPath(), children);
            return;
        }
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ShimLoader.getHadoopShims().checkFileAccess(fsAsUser, stat, action);
                FileUtils.addChildren(fsAsUser, stat.getPath(), children);
                return null;
            }
        });
    }

    private static void addChildren(FileSystem fsAsUser, Path path, List<FileStatus> children) throws IOException {
        if (children != null) {
            FileStatus[] listStatus;
            try {
                listStatus = fsAsUser.listStatus(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to list files under " + path + " : " + e);
                throw e;
            }
            children.addAll(Arrays.asList(listStatus));
        }
    }

    public static UserGroupInformation getProxyUser(String user) throws LoginException, IOException {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        UserGroupInformation proxyUser = null;
        if (user != null && !user.equals(currentUser)) {
            proxyUser = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        return proxyUser;
    }

    public static void closeFs(UserGroupInformation proxyUser) throws IOException {
        if (proxyUser != null) {
            FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
        }
    }

    public static FileSystem getFsAsUser(final FileSystem fs, UserGroupInformation proxyUser) throws IOException, InterruptedException {
        if (proxyUser == null) {
            return null;
        }
        FileSystem fsAsUser = (FileSystem)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)fs.getUri(), (Configuration)fs.getConf());
            }
        });
        return fsAsUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action) throws Exception {
        UserGroupInformation proxyUser = null;
        boolean isPermitted = false;
        try {
            proxyUser = FileUtils.getProxyUser(userName);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            isPermitted = FileUtils.isActionPermittedForFileHierarchy(fs, fileStatus, userName, action, true, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
        return isPermitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action, boolean recurse) throws Exception {
        boolean isPermitted;
        UserGroupInformation proxyUser = null;
        try {
            proxyUser = FileUtils.getProxyUser(userName);
            FileSystem fsAsUser = FileUtils.getFsAsUser(fs, proxyUser);
            isPermitted = FileUtils.isActionPermittedForFileHierarchy(fs, fileStatus, userName, action, recurse, fsAsUser);
        }
        finally {
            FileUtils.closeFs(proxyUser);
        }
        return isPermitted;
    }

    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action, boolean recurse, FileSystem fsAsUser) throws Exception {
        boolean isDir = fileStatus.isDir();
        FsAction dirActionNeeded = action;
        if (isDir) {
            dirActionNeeded.and(FsAction.EXECUTE);
        }
        ArrayList<FileStatus> subDirsToCheck = null;
        if (isDir && recurse) {
            subDirsToCheck = new ArrayList<FileStatus>();
        }
        try {
            FileUtils.checkFileAccessWithImpersonation(fs, fileStatus, action, userName, subDirsToCheck, fsAsUser);
        }
        catch (AccessControlException err) {
            LOG.warn("Action " + action + " denied on " + fileStatus.getPath() + " for user " + userName);
            return false;
        }
        if (subDirsToCheck == null || subDirsToCheck.isEmpty()) {
            return true;
        }
        for (FileStatus childStatus : subDirsToCheck) {
            if (FileUtils.isActionPermittedForFileHierarchy(fs, childStatus, userName, action, true, fsAsUser)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalFile(HiveConf conf, String fileName) {
        try {
            return FileUtils.isLocalFile(conf, new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.warn("Unable to create URI from " + fileName, (Throwable)e);
            return false;
        }
    }

    public static boolean isLocalFile(HiveConf conf, URI fileUri) {
        try {
            FileSystem fsForFile = FileSystem.get((URI)fileUri, (Configuration)conf);
            return LocalFileSystem.class.isInstance(fsForFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to get FileSystem for " + fileUri, (Throwable)e);
            return false;
        }
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException, InterruptedException {
        return FileUtils.isOwnerOfFileHierarchy(fs, fileStatus, userName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOwnerOfFileHierarchy(final FileSystem fs, final FileStatus fileStatus, final String userName, final boolean recurse) throws IOException, InterruptedException {
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getLoginUser());
        try {
            boolean isOwner;
            boolean bl = isOwner = ((Boolean)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    FileSystem fsAsUser = FileSystem.get((URI)fs.getUri(), (Configuration)fs.getConf());
                    return FileUtils.checkIsOwnerOfFileHierarchy(fsAsUser, fileStatus, userName, recurse);
                }
            })).booleanValue();
            return bl;
        }
        finally {
            FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
        }
    }

    public static boolean checkIsOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, boolean recurse) throws IOException {
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDir() || !recurse) {
            return true;
        }
        FileStatus[] childStatuses = null;
        try {
            childStatuses = fs.listStatus(fileStatus.getPath());
        }
        catch (FileNotFoundException fe) {
            LOG.debug("Skipping child access check since the directory is already removed");
            return true;
        }
        for (FileStatus childStatus : childStatuses) {
            if (FileUtils.checkIsOwnerOfFileHierarchy(fs, childStatus, userName, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean mkdir(FileSystem fs, Path f, Configuration conf) throws IOException {
        LOG.info("Creating directory if it doesn't exist: " + f);
        return fs.mkdirs(f);
    }

    public static Path makeAbsolute(FileSystem fileSystem, Path path) throws IOException {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(fileSystem.getWorkingDirectory(), path);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf) throws IOException {
        return FileUtils.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf, ShimLoader.getHadoopShims());
    }

    @VisibleForTesting
    static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf, HadoopShims shims) throws IOException {
        ContentSummary srcContentSummary;
        boolean copied = false;
        boolean triedDistcp = false;
        if (srcFS.getUri().getScheme().equals("hdfs") && (srcContentSummary = srcFS.getContentSummary(src)).getFileCount() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) && srcContentSummary.getLength() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE)) {
            LOG.info("Source is " + srcContentSummary.getLength() + " bytes. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE) + ")");
            LOG.info("Source is " + srcContentSummary.getFileCount() + " files. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) + ")");
            LOG.info("Launch distributed copy (distcp) job.");
            triedDistcp = true;
            copied = FileUtils.distCp(srcFS, Collections.singletonList(src), dst, deleteSource, null, conf, shims);
        }
        if (!triedDistcp) {
            copied = FileUtils.copy(srcFS, srcFS.getFileStatus(src), dstFS, dst, deleteSource, overwrite, FileUtils.shouldPreserveXAttrs(conf, srcFS, dstFS), (Configuration)conf);
        }
        return copied;
    }

    public static boolean copy(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, boolean preserveXAttrs, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        dst = FileUtils.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcStatus.isDirectory()) {
            FileUtils.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            RemoteIterator fileIterator = srcFS.listStatusIterator(src);
            while (fileIterator.hasNext()) {
                FileStatus file = (FileStatus)fileIterator.next();
                FileUtils.copy(srcFS, file, dstFS, new Path(dst, file.getPath().getName()), deleteSource, overwrite, preserveXAttrs, conf);
            }
            if (preserveXAttrs) {
                FileUtils.preserveXAttr(srcFS, src, dstFS, dst);
            }
        } else {
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = srcFS.open(src);
                out = dstFS.create(dst, overwrite);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)true);
                if (preserveXAttrs) {
                    FileUtils.preserveXAttr(srcFS, src, dstFS, dst);
                }
            }
            catch (IOException var11) {
                IOUtils.closeStream((Closeable)in);
                IOUtils.closeStream(out);
                throw var11;
            }
        }
        return deleteSource ? srcFS.delete(src, true) : true;
    }

    public static boolean copy(FileSystem srcFS, Path[] srcs, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, boolean preserveXAttr, Configuration conf) throws IOException {
        boolean gotException = false;
        boolean returnVal = true;
        StringBuilder exceptions = new StringBuilder();
        if (srcs.length == 1) {
            return FileUtils.copy(srcFS, srcFS.getFileStatus(srcs[0]), dstFS, dst, deleteSource, overwrite, preserveXAttr, conf);
        }
        try {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (!sdst.isDirectory()) {
                throw new IOException("copying multiple files, but last argument `" + dst + "' is not a directory");
            }
        }
        catch (FileNotFoundException var16) {
            throw new IOException("`" + dst + "': specified destination directory does not exist", var16);
        }
        Path[] var17 = srcs;
        int var11 = srcs.length;
        for (int var12 = 0; var12 < var11; ++var12) {
            Path src = var17[var12];
            try {
                if (FileUtils.copy(srcFS, srcFS.getFileStatus(src), dstFS, dst, deleteSource, overwrite, preserveXAttr, conf)) continue;
                returnVal = false;
                continue;
            }
            catch (IOException var15) {
                gotException = true;
                exceptions.append(var15.getMessage());
                exceptions.append("\n");
            }
        }
        if (gotException) {
            throw new IOException(exceptions.toString());
        }
        return returnVal;
    }

    private static void preserveXAttr(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        for (Map.Entry attr : srcFS.getXAttrs(src).entrySet()) {
            dstFS.setXAttr(dst, (String)attr.getKey(), (byte[])attr.getValue());
        }
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        FileStatus sdst;
        try {
            sdst = dstFS.getFileStatus(dst);
        }
        catch (FileNotFoundException var6) {
            sdst = null;
        }
        if (null != sdst) {
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new PathIsDirectoryException(dst.toString());
                }
                return FileUtils.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new PathExistsException(dst.toString(), "Target " + dst + " already exists");
            }
        }
        return dst;
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = srcFS.makeQualified(src).toString() + "/";
            String dstq = dstFS.makeQualified(dst).toString() + "/";
            if (dstq.startsWith(srcq)) {
                throw new IOException(srcq.length() == dstq.length() ? "Cannot copy " + src + " to itself." : "Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    public static boolean shouldPreserveXAttrs(HiveConf conf, FileSystem srcFS, FileSystem dstFS) throws IOException {
        if (!Utils.checkFileSystemXAttrSupport(srcFS) || !Utils.checkFileSystemXAttrSupport(dstFS)) {
            return false;
        }
        for (Map.Entry entry : conf.getPropsWithPrefix("distcp.options.").entrySet()) {
            String distCpOption = (String)entry.getKey();
            if (!distCpOption.startsWith("p")) continue;
            return distCpOption.contains("x");
        }
        return true;
    }

    public static boolean distCp(FileSystem srcFS, List<Path> srcPaths, Path dst, boolean deleteSource, UserGroupInformation proxyUser, HiveConf conf, HadoopShims shims) throws IOException {
        LOG.debug("copying srcPaths : {}, to DestPath :{} ,with doAs: {}", new Object[]{org.apache.hadoop.util.StringUtils.join((CharSequence)",", srcPaths), dst.toString(), proxyUser});
        boolean copied = false;
        copied = proxyUser == null ? shims.runDistCp(srcPaths, dst, conf) : shims.runDistCpAs(srcPaths, dst, conf, proxyUser);
        if (copied && deleteSource) {
            if (proxyUser != null) {
                throw new IOException("Distcp is called with doAsUser and delete source set as true");
            }
            for (Path path : srcPaths) {
                srcFS.delete(path, true);
            }
        }
        return copied;
    }

    public static boolean distCpWithSnapshot(String oldSnapshot, String newSnapshot, List<Path> srcPaths, Path dst, boolean overwriteTarget, HiveConf conf, HadoopShims shims, UserGroupInformation proxyUser) {
        boolean copied = false;
        try {
            copied = proxyUser == null ? shims.runDistCpWithSnapshots(oldSnapshot, newSnapshot, srcPaths, dst, overwriteTarget, conf) : shims.runDistCpWithSnapshotsAs(oldSnapshot, newSnapshot, srcPaths, dst, overwriteTarget, proxyUser, conf);
            if (copied) {
                LOG.info("Successfully copied using snapshots source {} and dest {} using snapshots {} and {}", new Object[]{srcPaths, dst, oldSnapshot, newSnapshot});
            }
        }
        catch (IOException e) {
            LOG.error("Can not copy using snapshot from source: {}, target: {}", srcPaths, (Object)dst);
        }
        return copied;
    }

    public static boolean moveToTrash(FileSystem fs, Path f, Configuration conf, boolean purge) throws IOException {
        LOG.debug("deleting  " + f);
        boolean result = false;
        try {
            if (purge) {
                LOG.debug("purge is set to true. Not moving to Trash " + f);
            } else {
                result = Trash.moveToAppropriateTrash((FileSystem)fs, (Path)f, (Configuration)conf);
                if (result) {
                    LOG.trace("Moved to trash: " + f);
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage() + "; Force to delete it.");
        }
        result = fs.delete(f, true);
        if (!result) {
            LOG.error("Failed to delete " + f);
        }
        return result;
    }

    public static boolean rename(FileSystem fs, Path sourcePath, Path destPath, Configuration conf) throws IOException {
        LOG.info("Renaming " + sourcePath + " to " + destPath);
        if (fs.exists(destPath)) {
            throw new IOException("Cannot rename the source path. The destination path already exists.");
        }
        return fs.rename(sourcePath, destPath);
    }

    public static boolean equalsFileSystem(FileSystem fs1, FileSystem fs2) {
        return fs1.getUri().equals(fs2.getUri());
    }

    public static void checkDeletePermission(Path path, Configuration conf, String user) throws AccessControlException, InterruptedException, Exception {
        if (path == null) {
            return;
        }
        FileSystem fs = path.getFileSystem(conf);
        FileStatus stat = null;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (stat == null) {
            return;
        }
        FileUtils.checkFileAccessWithImpersonation(fs, stat, FsAction.WRITE, user);
        HadoopShims shims = ShimLoader.getHadoopShims();
        if (!shims.supportStickyBit()) {
            return;
        }
        FileStatus parStatus = fs.getFileStatus(path.getParent());
        if (!shims.hasStickyBit(parStatus.getPermission())) {
            return;
        }
        if (parStatus.getOwner().equals(user)) {
            return;
        }
        FileStatus childStatus = fs.getFileStatus(path);
        if (childStatus.getOwner().equals(user)) {
            return;
        }
        String msg = String.format("Permission Denied: User %s can't delete %s because sticky bit is set on the parent dir and user does not own this file or its parent", user, path);
        throw new IOException(msg);
    }

    public static FileStatus getFileStatusOrNull(FileSystem fs, Path path) throws IOException {
        try {
            return fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static File createTempFile(String lScratchDir, String prefix, String suffix) throws IOException {
        File tmpDir;
        File file = tmpDir = lScratchDir == null ? null : new File(lScratchDir);
        if (!(tmpDir == null || tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create temp directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(prefix, suffix, tmpDir);
        ShutdownHookManager.deleteOnExit(tmpFile);
        return tmpFile;
    }

    public static File createLocalDirsTempFile(String localDirList, String prefix, String suffix, boolean isDirectory) throws IOException {
        if (localDirList == null || localDirList.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String[] localDirs = org.apache.hadoop.util.StringUtils.getTrimmedStrings((String)localDirList);
        if (localDirs.length == 0) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String path = localDirs[random.nextInt(localDirs.length)];
        if (path == null || path.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Empty path for one of the local dirs", isDirectory);
        }
        File targetDir = new File(path);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot access or create " + targetDir, isDirectory);
        }
        try {
            File file = File.createTempFile(prefix, suffix, targetDir);
            if (!(!isDirectory || file.delete() && file.mkdirs())) {
                return FileUtils.createFileInTmp(prefix, suffix, "Cannot recreate " + file + " as directory", isDirectory);
            }
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            LOG.error("Error creating a file in " + targetDir, (Throwable)ex);
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot create a file in " + targetDir, isDirectory);
        }
    }

    private static File createFileInTmp(String prefix, String suffix, String reason, boolean isDirectory) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        if (!(!isDirectory || file.delete() && file.mkdirs())) {
            throw new IOException("Cannot recreate " + file + " as directory");
        }
        file.deleteOnExit();
        LOG.info(reason + "; created a tmp file: " + file.getAbsolutePath());
        return file;
    }

    public static File createLocalDirsTempFile(Configuration conf, String prefix, String suffix, boolean isDirectory) throws IOException {
        return FileUtils.createLocalDirsTempFile(conf.get("yarn.nodemanager.local-dirs"), prefix, suffix, isDirectory);
    }

    public static boolean deleteTmpFile(File tempFile) {
        if (tempFile != null) {
            tempFile.delete();
            ShutdownHookManager.cancelDeleteOnExit(tempFile);
            return true;
        }
        return false;
    }

    public static boolean pathsContainNoScheme(Collection<Path> paths) {
        for (Path path : paths) {
            if (path.toUri().getScheme() == null) continue;
            return false;
        }
        return true;
    }

    public static Path getParentRegardlessOfScheme(Path path, Collection<Path> candidates) {
        for (Path schemalessPath = Path.getPathWithoutSchemeAndAuthority((Path)path); path != null && schemalessPath != null; path = path.getParent(), schemalessPath = schemalessPath.getParent()) {
            if (candidates.contains(path)) {
                return path;
            }
            if (!candidates.contains(schemalessPath)) continue;
            return schemalessPath;
        }
        return null;
    }

    public static boolean isPathWithinSubtree(Path path, Path subtree) {
        return FileUtils.isPathWithinSubtree(path, subtree, subtree.depth());
    }

    private static boolean isPathWithinSubtree(Path path, Path subtree, int subtreeDepth) {
        while (path != null) {
            if (subtreeDepth > path.depth()) {
                return false;
            }
            if (subtree.equals((Object)path)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    public static void populateParentPaths(Set<Path> parents, Path path) {
        if (parents == null) {
            return;
        }
        while (path != null) {
            parents.add(path);
            path = path.getParent();
        }
    }

    public static URI getURI(String path) throws URISyntaxException {
        if (path == null) {
            return null;
        }
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            uri = new File(path).toURI();
        }
        return uri;
    }

    public static Set<String> getJarFilesByPath(String pathString, Configuration conf) {
        String[] paths;
        HashSet<String> result = new HashSet<String>();
        if (pathString == null || StringUtils.isBlank(pathString)) {
            return result;
        }
        for (String path : paths = pathString.split(",")) {
            try {
                Path p = new Path(FileUtils.getURI(path));
                FileSystem fs = p.getFileSystem(conf);
                if (!fs.exists(p)) {
                    LOG.error("The jar file path " + path + " doesn't exist");
                    continue;
                }
                if (fs.isDirectory(p)) {
                    FileStatus[] files;
                    for (FileStatus file : files = fs.listStatus(p, (PathFilter)new GlobFilter("*.jar"))) {
                        result.add(file.getPath().toUri().toString());
                    }
                    continue;
                }
                result.add(p.toUri().toString());
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Invalid file path " + path, (Throwable)e);
            }
        }
        return result;
    }

    public static void readFully(InputStream stream, int length, ByteBuffer bb) throws IOException {
        byte[] b = null;
        int offset = 0;
        if (bb.hasArray()) {
            b = bb.array();
            offset = bb.arrayOffset() + bb.position();
        } else {
            b = new byte[bb.remaining()];
        }
        int fullLen = length;
        while (length > 0) {
            int result = stream.read(b, offset, length);
            if (result < 0) {
                throw new EOFException("Reading " + fullLen + " bytes");
            }
            offset += result;
            length -= result;
        }
        if (!bb.hasArray()) {
            bb.put(b);
        } else {
            bb.position(bb.position() + fullLen);
        }
    }

    public static int getSleepTime(int repeatNum) {
        return 100 * (int)Math.pow(2.0, repeatNum);
    }

    public static void deleteIfExists(FileSystem fs, Path path) {
        try {
            fs.delete(path, true);
        }
        catch (IOException e) {
            LOG.debug("Unable to delete {}", (Object)path, (Object)e);
        }
    }

    public static RemoteIterator<FileStatus> listStatusIterator(FileSystem fs, Path path, PathFilter filter) throws IOException {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)fs.listStatusIterator(path), status -> filter.accept(status.getPath()));
    }

    public static RemoteIterator<LocatedFileStatus> listFiles(FileSystem fs, Path path, boolean recursive, PathFilter filter) throws IOException {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)fs.listFiles(path, recursive), status -> filter.accept(status.getPath()));
    }

    static {
        char[] clist;
        LOG = LoggerFactory.getLogger((String)FileUtils.class.getName());
        random = new Random();
        HIDDEN_FILES_PATH_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        STAGING_DIR_PATH_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith(".");
            }
        };
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
    }
}

