/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.hadoop.hive.llap.WritableByteChannelAdapter;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapArrowRecordWriter<K extends Writable, V extends Writable>
implements RecordWriter<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(LlapArrowRecordWriter.class);
    ArrowStreamWriter arrowStreamWriter;
    WritableByteChannelAdapter out;
    BufferAllocator allocator;
    NullableMapVector rootVector;

    public LlapArrowRecordWriter(WritableByteChannelAdapter out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Reporter reporter) throws IOException {
        try {
            this.arrowStreamWriter.close();
        }
        finally {
            this.rootVector.close();
            long bytesLeaked = this.allocator.getAllocatedMemory();
            if (bytesLeaked != 0L) {
                LOG.error("Arrow memory leaked bytes: {}", (Object)bytesLeaked);
                throw new IllegalStateException("Arrow memory leaked bytes:" + bytesLeaked);
            }
            this.allocator.close();
        }
    }

    public void write(K key, V value) throws IOException {
        ArrowWrapperWritable arrowWrapperWritable = (ArrowWrapperWritable)value;
        if (this.arrowStreamWriter == null) {
            VectorSchemaRoot vectorSchemaRoot = arrowWrapperWritable.getVectorSchemaRoot();
            this.arrowStreamWriter = new ArrowStreamWriter(vectorSchemaRoot, null, (WritableByteChannel)this.out);
            this.allocator = arrowWrapperWritable.getAllocator();
            this.out.setAllocator(this.allocator);
            this.rootVector = arrowWrapperWritable.getRootVector();
        }
        this.arrowStreamWriter.writeBatch();
    }
}

