/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LlapHiveUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LlapHiveUtils.class);

    private LlapHiveUtils() {
    }

    public static PartitionDesc partitionDescForPath(Path path, Map<Path, PartitionDesc> partitionDescMap) {
        assert (partitionDescMap != null);
        Path parentPath = path;
        PartitionDesc part = partitionDescMap.get(parentPath);
        while (!parentPath.isRoot() && part == null) {
            parentPath = parentPath.getParent();
            part = partitionDescMap.get(parentPath);
        }
        return part;
    }

    public static CacheTag getDbAndTableNameForMetrics(Path path, boolean includeParts, PartitionDesc part) {
        if (part == null) {
            return CacheTag.build(LlapUtil.getDbAndTableNameForMetrics(path, includeParts));
        }
        if (!includeParts || !part.isPartitioned()) {
            return CacheTag.build(part.getTableName());
        }
        return CacheTag.build(part.getTableName(), part.getPartSpec());
    }

    public static int getSchemaHash(PartitionDesc part) {
        if (part == null) {
            return -1;
        }
        Object columnTypes = part.getProperties().get("columns.types");
        if (columnTypes != null) {
            return columnTypes.toString().hashCode();
        }
        return -1;
    }

    public static MapWork findMapWork(JobConf job) {
        String prefixes;
        String inputName = job.get("iocontext.input.name", null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing for input " + inputName);
        }
        if ((prefixes = job.get("hive.tez.merge.file.prefixes")) != null && !StringUtils.isBlank(prefixes)) {
            return null;
        }
        BaseWork work = null;
        if (!(inputName == null || prefixes != null && Lists.newArrayList(prefixes.split(",")).contains(inputName))) {
            inputName = null;
        }
        if (inputName != null) {
            work = Utilities.getMergeWork((Configuration)job, inputName);
        }
        if (!(work instanceof MapWork)) {
            work = Utilities.getMapWork((Configuration)job);
        }
        return (MapWork)work;
    }

    public static void throwIfCacheOnlyRead(boolean isCacheOnlyRead) throws IOException {
        if (isCacheOnlyRead) {
            throw new IOException("LLAP cache miss happened while reading. Aborting query as cache only reading is set. Set " + HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname + " to false and repeat query if this was unintended.");
        }
    }

    public static boolean isLlapMode(Configuration conf) {
        return "llap".equalsIgnoreCase(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE));
    }
}

