/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.model.MColumnDescriptor;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.apache.hadoop.hive.metastore.model.MOrder;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MStringList;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;

class DirectSqlInsertPart {
    private final PersistenceManager pm;
    private final DatabaseProduct dbType;
    private final int batchSize;
    private final SQLGenerator sqlGenerator;

    public DirectSqlInsertPart(PersistenceManager pm, Configuration conf, DatabaseProduct dbType, int batchSize) {
        this.pm = pm;
        this.dbType = dbType;
        this.batchSize = batchSize;
        this.sqlGenerator = new SQLGenerator(dbType, conf);
    }

    private Long getDataStoreId(Class<?> modelClass) throws MetaException {
        ExecutionContext ec = ((JDOPersistenceManager)this.pm).getExecutionContext();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(modelClass, ec.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return (Long)ec.getStoreManager().getStrategyValue(ec, cmd, -1);
        }
        throw new MetaException("Identity type is not datastore.");
    }

    private void insertInBatch(String tableName, String columns, int columnCount, int rowCount, BatchExecutionContext batchExecutionContext) throws MetaException {
        if (rowCount == 0 || columnCount == 0) {
            return;
        }
        int maxRowsInBatch = this.batchSize == -1 ? rowCount : this.batchSize;
        int maxBatches = rowCount / maxRowsInBatch;
        int last = rowCount % maxRowsInBatch;
        String rowFormat = "(" + StringUtils.repeat(",?", columnCount).substring(1) + ")";
        String query = "";
        if (maxBatches > 0) {
            query = this.sqlGenerator.getBatchInsertQuery(tableName, columns, rowFormat, maxRowsInBatch);
        }
        for (int batch = 0; batch < maxBatches; ++batch) {
            batchExecutionContext.execute(query, maxRowsInBatch);
        }
        if (last != 0) {
            query = this.sqlGenerator.getBatchInsertQuery(tableName, columns, rowFormat, last);
            batchExecutionContext.execute(query, last);
        }
    }

    private void executeQuery(String queryText, Object[] params) throws MetaException {
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        MetastoreDirectSqlUtils.executeWithArray(query, params, queryText);
    }

    private void insertSerdeInBatch(final Map<Long, MSerDeInfo> serdeIdToSerDeInfo) throws MetaException {
        int rowCount = serdeIdToSerDeInfo.size();
        String columns = "(\"SERDE_ID\",\"DESCRIPTION\",\"DESERIALIZER_CLASS\",\"NAME\",\"SERDE_TYPE\",\"SLIB\",\"SERIALIZER_CLASS\")";
        final int columnCount = 7;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MSerDeInfo>> it;
            {
                this.it = serdeIdToSerDeInfo.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, MSerDeInfo> entry = this.it.next();
                    MSerDeInfo serdeInfo = entry.getValue();
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = serdeInfo.getDescription();
                    params[paramIndex++] = serdeInfo.getDeserializerClass();
                    params[paramIndex++] = serdeInfo.getName();
                    params[paramIndex++] = serdeInfo.getSerdeType();
                    params[paramIndex++] = serdeInfo.getSerializationLib();
                    params[paramIndex++] = serdeInfo.getSerializerClass();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SERDES\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertStorageDescriptorInBatch(final Map<Long, MStorageDescriptor> sdIdToStorageDescriptor, final Map<Long, Long> sdIdToSerdeId, final Map<Long, Long> sdIdToCdId) throws MetaException {
        int rowCount = sdIdToStorageDescriptor.size();
        String columns = "(\"SD_ID\",\"CD_ID\",\"INPUT_FORMAT\",\"IS_COMPRESSED\",\"IS_STOREDASSUBDIRECTORIES\",\"LOCATION\",\"NUM_BUCKETS\",\"OUTPUT_FORMAT\",\"SERDE_ID\")";
        final int columnCount = 9;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MStorageDescriptor>> it;
            {
                this.it = sdIdToStorageDescriptor.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, MStorageDescriptor> entry = this.it.next();
                    MStorageDescriptor sd = entry.getValue();
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = sdIdToCdId.get(entry.getKey());
                    params[paramIndex++] = sd.getInputFormat();
                    params[paramIndex++] = DirectSqlInsertPart.this.sqlGenerator.getBoolean(sd.isCompressed());
                    params[paramIndex++] = DirectSqlInsertPart.this.sqlGenerator.getBoolean(sd.isStoredAsSubDirectories());
                    params[paramIndex++] = sd.getLocation();
                    params[paramIndex++] = sd.getNumBuckets();
                    params[paramIndex++] = sd.getOutputFormat();
                    params[paramIndex++] = sdIdToSerdeId.get(entry.getKey());
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SDS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertPartitionInBatch(final Map<Long, MPartition> partIdToPartition, final Map<Long, Long> partIdToSdId) throws MetaException {
        int rowCount = partIdToPartition.size();
        String columns = "(\"PART_ID\",\"CREATE_TIME\",\"LAST_ACCESS_TIME\",\"PART_NAME\",\"SD_ID\",\"TBL_ID\",\"WRITE_ID\")";
        final int columnCount = 7;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MPartition>> it;
            {
                this.it = partIdToPartition.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, MPartition> entry = this.it.next();
                    MPartition partition = entry.getValue();
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = partition.getCreateTime();
                    params[paramIndex++] = partition.getLastAccessTime();
                    params[paramIndex++] = partition.getPartitionName();
                    params[paramIndex++] = partIdToSdId.get(entry.getKey());
                    params[paramIndex++] = partition.getTable().getId();
                    params[paramIndex++] = partition.getWriteId();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"PARTITIONS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSerdeParamInBatch(final Map<Long, MSerDeInfo> serdeIdToSerDeInfo) throws MetaException {
        int rowCount = 0;
        for (MSerDeInfo serDeInfo : serdeIdToSerDeInfo.values()) {
            rowCount += serDeInfo.getParameters() != null ? serDeInfo.getParameters().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"SERDE_ID\",\"PARAM_KEY\",\"PARAM_VALUE\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MSerDeInfo>> serdeIt;
            Map.Entry<Long, MSerDeInfo> serdeEntry;
            Iterator<Map.Entry<String, String>> it;
            {
                this.serdeIt = serdeIdToSerDeInfo.entrySet().iterator();
                this.serdeEntry = this.serdeIt.next();
                this.it = this.serdeEntry.getValue().getParameters() != null ? this.serdeEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        Map.Entry<String, String> entry = this.it.next();
                        params[paramIndex++] = this.serdeEntry.getKey();
                        params[paramIndex++] = entry.getKey();
                        params[paramIndex++] = entry.getValue();
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.serdeEntry = this.serdeIt.next();
                        Iterator<Object> iterator = this.it = this.serdeEntry.getValue().getParameters() != null ? this.serdeEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SERDE_PARAMS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertStorageDescriptorParamInBatch(final Map<Long, MStorageDescriptor> sdIdToStorageDescriptor) throws MetaException {
        int rowCount = 0;
        for (MStorageDescriptor sd : sdIdToStorageDescriptor.values()) {
            rowCount += sd.getParameters() != null ? sd.getParameters().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"SD_ID\",\"PARAM_KEY\",\"PARAM_VALUE\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MStorageDescriptor>> sdIt;
            Map.Entry<Long, MStorageDescriptor> sdEntry;
            Iterator<Map.Entry<String, String>> it;
            {
                this.sdIt = sdIdToStorageDescriptor.entrySet().iterator();
                this.sdEntry = this.sdIt.next();
                this.it = this.sdEntry.getValue().getParameters() != null ? this.sdEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        Map.Entry<String, String> entry = this.it.next();
                        params[paramIndex++] = this.sdEntry.getKey();
                        params[paramIndex++] = entry.getKey();
                        params[paramIndex++] = entry.getValue();
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.sdEntry = this.sdIt.next();
                        Iterator<Object> iterator = this.it = this.sdEntry.getValue().getParameters() != null ? this.sdEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SD_PARAMS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertPartitionParamInBatch(final Map<Long, MPartition> partIdToPartition) throws MetaException {
        int rowCount = 0;
        for (MPartition part : partIdToPartition.values()) {
            rowCount += part.getParameters() != null ? part.getParameters().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"PART_ID\",\"PARAM_KEY\",\"PARAM_VALUE\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MPartition>> partIt;
            Map.Entry<Long, MPartition> partEntry;
            Iterator<Map.Entry<String, String>> it;
            {
                this.partIt = partIdToPartition.entrySet().iterator();
                this.partEntry = this.partIt.next();
                this.it = this.partEntry.getValue().getParameters() != null ? this.partEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        Map.Entry<String, String> entry = this.it.next();
                        params[paramIndex++] = this.partEntry.getKey();
                        params[paramIndex++] = entry.getKey();
                        params[paramIndex++] = entry.getValue();
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.partEntry = this.partIt.next();
                        Iterator<Object> iterator = this.it = this.partEntry.getValue().getParameters() != null ? this.partEntry.getValue().getParameters().entrySet().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"PARTITION_PARAMS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertPartitionKeyValInBatch(final Map<Long, MPartition> partIdToPartition) throws MetaException {
        int rowCount = 0;
        for (MPartition part : partIdToPartition.values()) {
            rowCount += part.getValues().size();
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"PART_ID\",\"PART_KEY_VAL\",\"INTEGER_IDX\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, MPartition>> partIt = partIdToPartition.entrySet().iterator();
            Map.Entry<Long, MPartition> partEntry = this.partIt.next();
            Iterator<String> it = this.partEntry.getValue().getValues().iterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        params[paramIndex++] = this.partEntry.getKey();
                        params[paramIndex++] = this.it.next();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.partEntry = this.partIt.next();
                        this.it = this.partEntry.getValue().getValues().iterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"PARTITION_KEY_VALS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertColumnDescriptorInBatch(final Map<Long, MColumnDescriptor> cdIdToColumnDescriptor) throws MetaException {
        int rowCount = cdIdToColumnDescriptor.size();
        String columns = "(\"CD_ID\")";
        final int columnCount = 1;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Long> it;
            {
                this.it = cdIdToColumnDescriptor.keySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    params[paramIndex++] = this.it.next();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"CDS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertColumnV2InBatch(final Map<Long, MColumnDescriptor> cdIdToColumnDescriptor) throws MetaException {
        int rowCount = 0;
        for (MColumnDescriptor cd : cdIdToColumnDescriptor.values()) {
            rowCount += cd.getCols().size();
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"CD_ID\",\"COMMENT\",\"COLUMN_NAME\",\"TYPE_NAME\",\"INTEGER_IDX\")";
        final int columnCount = 5;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, MColumnDescriptor>> cdIt = cdIdToColumnDescriptor.entrySet().iterator();
            Map.Entry<Long, MColumnDescriptor> cdEntry = this.cdIt.next();
            Iterator<MFieldSchema> it = this.cdEntry.getValue().getCols().iterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        MFieldSchema fieldSchema = this.it.next();
                        params[paramIndex++] = this.cdEntry.getKey();
                        params[paramIndex++] = fieldSchema.getComment();
                        params[paramIndex++] = fieldSchema.getName();
                        params[paramIndex++] = fieldSchema.getType();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.cdEntry = this.cdIt.next();
                        this.it = this.cdEntry.getValue().getCols().iterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"COLUMNS_V2\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertBucketColInBatch(final Map<Long, MStorageDescriptor> sdIdToStorageDescriptor) throws MetaException {
        int rowCount = 0;
        for (MStorageDescriptor sd : sdIdToStorageDescriptor.values()) {
            rowCount += sd.getBucketCols() != null ? sd.getBucketCols().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"SD_ID\",\"BUCKET_COL_NAME\",\"INTEGER_IDX\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, MStorageDescriptor>> sdIt = sdIdToStorageDescriptor.entrySet().iterator();
            Map.Entry<Long, MStorageDescriptor> sdEntry = this.sdIt.next();
            Iterator<String> it = this.sdEntry.getValue().getBucketCols() != null ? this.sdEntry.getValue().getBucketCols().iterator() : Collections.emptyIterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        params[paramIndex++] = this.sdEntry.getKey();
                        params[paramIndex++] = this.it.next();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.sdEntry = this.sdIt.next();
                        Iterator<Object> iterator = this.it = this.sdEntry.getValue().getBucketCols() != null ? this.sdEntry.getValue().getBucketCols().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"BUCKETING_COLS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSortColInBatch(final Map<Long, MStorageDescriptor> sdIdToStorageDescriptor) throws MetaException {
        int rowCount = 0;
        for (MStorageDescriptor sd : sdIdToStorageDescriptor.values()) {
            rowCount += sd.getSortCols() != null ? sd.getSortCols().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"SD_ID\",\"COLUMN_NAME\",\"ORDER\",\"INTEGER_IDX\")";
        final int columnCount = 4;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, MStorageDescriptor>> sdIt = sdIdToStorageDescriptor.entrySet().iterator();
            Map.Entry<Long, MStorageDescriptor> sdEntry = this.sdIt.next();
            Iterator<MOrder> it = this.sdEntry.getValue().getSortCols() != null ? this.sdEntry.getValue().getSortCols().iterator() : Collections.emptyIterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        MOrder order = this.it.next();
                        params[paramIndex++] = this.sdEntry.getKey();
                        params[paramIndex++] = order.getCol();
                        params[paramIndex++] = order.getOrder();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.sdEntry = this.sdIt.next();
                        Iterator<Object> iterator = this.it = this.sdEntry.getValue().getSortCols() != null ? this.sdEntry.getValue().getSortCols().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SORT_COLS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSkewedStringListInBatch(final List<Long> stringListIds) throws MetaException {
        int rowCount = stringListIds.size();
        String columns = "(\"STRING_LIST_ID\")";
        final int columnCount = 1;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Long> it;
            {
                this.it = stringListIds.iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    params[paramIndex++] = this.it.next();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SKEWED_STRING_LIST\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSkewedStringListValInBatch(final Map<Long, List<String>> stringListIdToStringList) throws MetaException {
        int rowCount = 0;
        for (List<String> stringList : stringListIdToStringList.values()) {
            rowCount += stringList.size();
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"STRING_LIST_ID\",\"STRING_LIST_VALUE\",\"INTEGER_IDX\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, List<String>>> stringListIt = stringListIdToStringList.entrySet().iterator();
            Map.Entry<Long, List<String>> stringListEntry = this.stringListIt.next();
            Iterator<String> it = this.stringListEntry.getValue().iterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        params[paramIndex++] = this.stringListEntry.getKey();
                        params[paramIndex++] = this.it.next();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.stringListEntry = this.stringListIt.next();
                        this.it = this.stringListEntry.getValue().iterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SKEWED_STRING_LIST_VALUES\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSkewedColInBatch(final Map<Long, MStorageDescriptor> sdIdToStorageDescriptor) throws MetaException {
        int rowCount = 0;
        for (MStorageDescriptor sd : sdIdToStorageDescriptor.values()) {
            rowCount += sd.getSkewedColNames() != null ? sd.getSkewedColNames().size() : 0;
        }
        if (rowCount == 0) {
            return;
        }
        String columns = "(\"SD_ID\",\"SKEWED_COL_NAME\",\"INTEGER_IDX\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            final Iterator<Map.Entry<Long, MStorageDescriptor>> sdIt = sdIdToStorageDescriptor.entrySet().iterator();
            Map.Entry<Long, MStorageDescriptor> sdEntry = this.sdIt.next();
            Iterator<String> it = this.sdEntry.getValue().getSkewedColNames() != null ? this.sdEntry.getValue().getSkewedColNames().iterator() : Collections.emptyIterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int index = 0;
                int paramIndex = 0;
                while (true) {
                    if (index < batchRowCount && this.it.hasNext()) {
                        params[paramIndex++] = this.sdEntry.getKey();
                        params[paramIndex++] = this.it.next();
                        params[paramIndex++] = this.colIndex++;
                        ++index;
                        continue;
                    }
                    if (index < batchRowCount) {
                        this.colIndex = 0;
                        this.sdEntry = this.sdIt.next();
                        Iterator<Object> iterator = this.it = this.sdEntry.getValue().getSkewedColNames() != null ? this.sdEntry.getValue().getSkewedColNames().iterator() : Collections.emptyIterator();
                    }
                    if (index >= batchRowCount) break;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SKEWED_COL_NAMES\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSkewedValInBatch(final List<Long> stringListIds, final Map<Long, Long> stringListIdToSdId) throws MetaException {
        int rowCount = stringListIds.size();
        String columns = "(\"SD_ID_OID\",\"STRING_LIST_ID_EID\",\"INTEGER_IDX\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            int colIndex = 0;
            long prevSdId = -1L;
            final Iterator<Long> it = stringListIds.iterator();

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Long stringListId = this.it.next();
                    Long sdId = (Long)stringListIdToSdId.get(stringListId);
                    params[paramIndex++] = sdId;
                    params[paramIndex++] = stringListId;
                    if (this.prevSdId != sdId) {
                        this.colIndex = 0;
                    }
                    params[paramIndex++] = this.colIndex++;
                    this.prevSdId = sdId;
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SKEWED_VALUES\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertSkewedLocationInBatch(final Map<Long, String> stringListIdToLocation, final Map<Long, Long> stringListIdToSdId) throws MetaException {
        int rowCount = stringListIdToLocation.size();
        String columns = "(\"SD_ID\",\"STRING_LIST_ID_KID\",\"LOCATION\")";
        final int columnCount = 3;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, String>> it;
            {
                this.it = stringListIdToLocation.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, String> entry = this.it.next();
                    params[paramIndex++] = stringListIdToSdId.get(entry.getKey());
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = entry.getValue();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"SKEWED_COL_VALUE_LOC_MAP\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertPartitionPrivilegeInBatch(final Map<Long, MPartitionPrivilege> partGrantIdToPrivilege, final Map<Long, Long> partGrantIdToPartId) throws MetaException {
        int rowCount = partGrantIdToPrivilege.size();
        String columns = "(\"PART_GRANT_ID\",\"AUTHORIZER\",\"CREATE_TIME\",\"GRANT_OPTION\",\"GRANTOR\",\"GRANTOR_TYPE\",\"PART_ID\",\"PRINCIPAL_NAME\",\"PRINCIPAL_TYPE\",\"PART_PRIV\")";
        final int columnCount = 10;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MPartitionPrivilege>> it;
            {
                this.it = partGrantIdToPrivilege.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, MPartitionPrivilege> entry = this.it.next();
                    MPartitionPrivilege partPrivilege = entry.getValue();
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = partPrivilege.getAuthorizer();
                    params[paramIndex++] = partPrivilege.getCreateTime();
                    params[paramIndex++] = partPrivilege.getGrantOption() ? 1 : 0;
                    params[paramIndex++] = partPrivilege.getGrantor();
                    params[paramIndex++] = partPrivilege.getGrantorType();
                    params[paramIndex++] = partGrantIdToPartId.get(entry.getKey());
                    params[paramIndex++] = partPrivilege.getPrincipalName();
                    params[paramIndex++] = partPrivilege.getPrincipalType();
                    params[paramIndex++] = partPrivilege.getPrivilege();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"PART_PRIVS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    private void insertPartitionColPrivilegeInBatch(final Map<Long, MPartitionColumnPrivilege> partColumnGrantIdToPrivilege, final Map<Long, Long> partColumnGrantIdToPartId) throws MetaException {
        int rowCount = partColumnGrantIdToPrivilege.size();
        String columns = "(\"PART_COLUMN_GRANT_ID\",\"AUTHORIZER\",\"COLUMN_NAME\",\"CREATE_TIME\",\"GRANT_OPTION\",\"GRANTOR\",\"GRANTOR_TYPE\",\"PART_ID\",\"PRINCIPAL_NAME\",\"PRINCIPAL_TYPE\",\"PART_COL_PRIV\")";
        final int columnCount = 11;
        BatchExecutionContext batchExecutionContext = new BatchExecutionContext(){
            final Iterator<Map.Entry<Long, MPartitionColumnPrivilege>> it;
            {
                this.it = partColumnGrantIdToPrivilege.entrySet().iterator();
            }

            @Override
            public void execute(String batchQueryText, int batchRowCount) throws MetaException {
                Object[] params = new Object[batchRowCount * columnCount];
                int paramIndex = 0;
                for (int index = 0; index < batchRowCount; ++index) {
                    Map.Entry<Long, MPartitionColumnPrivilege> entry = this.it.next();
                    MPartitionColumnPrivilege partColumnPrivilege = entry.getValue();
                    params[paramIndex++] = entry.getKey();
                    params[paramIndex++] = partColumnPrivilege.getAuthorizer();
                    params[paramIndex++] = partColumnPrivilege.getColumnName();
                    params[paramIndex++] = partColumnPrivilege.getCreateTime();
                    params[paramIndex++] = partColumnPrivilege.getGrantOption() ? 1 : 0;
                    params[paramIndex++] = partColumnPrivilege.getGrantor();
                    params[paramIndex++] = partColumnPrivilege.getGrantorType();
                    params[paramIndex++] = partColumnGrantIdToPartId.get(entry.getKey());
                    params[paramIndex++] = partColumnPrivilege.getPrincipalName();
                    params[paramIndex++] = partColumnPrivilege.getPrincipalType();
                    params[paramIndex++] = partColumnPrivilege.getPrivilege();
                }
                DirectSqlInsertPart.this.executeQuery(batchQueryText, params);
            }
        };
        this.insertInBatch("\"PART_COL_PRIVS\"", columns, columnCount, rowCount, batchExecutionContext);
    }

    public void addPartitions(List<MPartition> parts, List<List<MPartitionPrivilege>> partPrivilegesList, List<List<MPartitionColumnPrivilege>> partColPrivilegesList) throws MetaException {
        HashMap<Long, MSerDeInfo> serdeIdToSerDeInfo = new HashMap<Long, MSerDeInfo>();
        HashMap<Long, MColumnDescriptor> cdIdToColumnDescriptor = new HashMap<Long, MColumnDescriptor>();
        HashMap<Long, MStorageDescriptor> sdIdToStorageDescriptor = new HashMap<Long, MStorageDescriptor>();
        HashMap<Long, MPartition> partIdToPartition = new HashMap<Long, MPartition>();
        HashMap<Long, MPartitionPrivilege> partGrantIdToPrivilege = new HashMap<Long, MPartitionPrivilege>();
        HashMap<Long, MPartitionColumnPrivilege> partColumnGrantIdToPrivilege = new HashMap<Long, MPartitionColumnPrivilege>();
        HashMap<Long, Long> sdIdToSerdeId = new HashMap<Long, Long>();
        HashMap<Long, Long> sdIdToCdId = new HashMap<Long, Long>();
        HashMap<Long, Long> partIdToSdId = new HashMap<Long, Long>();
        HashMap<Long, List<String>> stringListIdToStringList = new HashMap<Long, List<String>>();
        HashMap<Long, Long> stringListIdToSdId = new HashMap<Long, Long>();
        HashMap<Long, String> stringListIdToLocation = new HashMap<Long, String>();
        HashMap<Long, Long> partGrantIdToPartId = new HashMap<Long, Long>();
        HashMap<Long, Long> partColumnGrantIdToPartId = new HashMap<Long, Long>();
        ArrayList<Long> stringListIds = new ArrayList<Long>();
        int partitionsCount = parts.size();
        for (int index = 0; index < partitionsCount; ++index) {
            Long cdId;
            MPartition part = parts.get(index);
            MStorageDescriptor sd = part.getSd();
            if (part.getValues() == null || sd == null || sd.getSerDeInfo() == null || sd.getCD() == null || sd.getCD().getCols() == null) {
                throw new MetaException("Invalid partition");
            }
            Long serDeId = this.getDataStoreId(MSerDeInfo.class);
            serdeIdToSerDeInfo.put(serDeId, sd.getSerDeInfo());
            DatastoreId storeId = (DatastoreId)this.pm.getObjectId(sd.getCD());
            if (storeId == null) {
                cdId = this.getDataStoreId(MColumnDescriptor.class);
                cdIdToColumnDescriptor.put(cdId, sd.getCD());
            } else {
                cdId = (Long)storeId.getKeyAsObject();
            }
            Long sdId = this.getDataStoreId(MStorageDescriptor.class);
            sdIdToStorageDescriptor.put(sdId, sd);
            sdIdToSerdeId.put(sdId, serDeId);
            sdIdToCdId.put(sdId, cdId);
            Long partId = this.getDataStoreId(MPartition.class);
            partIdToPartition.put(partId, part);
            partIdToSdId.put(partId, sdId);
            HashMap<List<String>, String> stringListToLocation = new HashMap<List<String>, String>();
            if (sd.getSkewedColValueLocationMaps() != null) {
                for (Map.Entry<MStringList, String> entry : sd.getSkewedColValueLocationMaps().entrySet()) {
                    stringListToLocation.put(entry.getKey().getInternalList(), entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(sd.getSkewedColValues())) {
                int skewedValCount = sd.getSkewedColValues().size();
                for (int i = 0; i < skewedValCount; ++i) {
                    Long stringListId = this.getDataStoreId(MStringList.class);
                    stringListIds.add(stringListId);
                    stringListIdToSdId.put(stringListId, sdId);
                    List<String> stringList = sd.getSkewedColValues().get(i).getInternalList();
                    stringListIdToStringList.put(stringListId, stringList);
                    String location = (String)stringListToLocation.get(stringList);
                    if (location == null) continue;
                    stringListIdToLocation.put(stringListId, location);
                }
            }
            List<MPartitionPrivilege> partPrivileges = partPrivilegesList.get(index);
            for (MPartitionPrivilege partPrivilege : partPrivileges) {
                Long partGrantId = this.getDataStoreId(MPartitionPrivilege.class);
                partGrantIdToPrivilege.put(partGrantId, partPrivilege);
                partGrantIdToPartId.put(partGrantId, partId);
            }
            List<MPartitionColumnPrivilege> partColPrivileges = partColPrivilegesList.get(index);
            for (MPartitionColumnPrivilege partColPrivilege : partColPrivileges) {
                Long partColumnGrantId = this.getDataStoreId(MPartitionColumnPrivilege.class);
                partColumnGrantIdToPrivilege.put(partColumnGrantId, partColPrivilege);
                partColumnGrantIdToPartId.put(partColumnGrantId, partId);
            }
        }
        this.insertSerdeInBatch(serdeIdToSerDeInfo);
        this.insertSerdeParamInBatch(serdeIdToSerDeInfo);
        this.insertColumnDescriptorInBatch(cdIdToColumnDescriptor);
        this.insertColumnV2InBatch(cdIdToColumnDescriptor);
        this.insertStorageDescriptorInBatch(sdIdToStorageDescriptor, sdIdToSerdeId, sdIdToCdId);
        this.insertStorageDescriptorParamInBatch(sdIdToStorageDescriptor);
        this.insertBucketColInBatch(sdIdToStorageDescriptor);
        this.insertSortColInBatch(sdIdToStorageDescriptor);
        this.insertSkewedColInBatch(sdIdToStorageDescriptor);
        this.insertSkewedStringListInBatch(stringListIds);
        this.insertSkewedStringListValInBatch(stringListIdToStringList);
        this.insertSkewedValInBatch(stringListIds, stringListIdToSdId);
        this.insertSkewedLocationInBatch(stringListIdToLocation, stringListIdToSdId);
        this.insertPartitionInBatch(partIdToPartition, partIdToSdId);
        this.insertPartitionParamInBatch(partIdToPartition);
        this.insertPartitionKeyValInBatch(partIdToPartition);
        this.insertPartitionPrivilegeInBatch(partGrantIdToPrivilege, partGrantIdToPartId);
        this.insertPartitionColPrivilegeInBatch(partColumnGrantIdToPrivilege, partColumnGrantIdToPartId);
    }

    static interface BatchExecutionContext {
        public void execute(String var1, int var2) throws MetaException;
    }
}

