/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreMetadataTransformer;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreDefaultTransformer
implements IMetaStoreMetadataTransformer {
    public static final Logger LOG = LoggerFactory.getLogger(MetastoreDefaultTransformer.class);
    private IHMSHandler hmsHandler = null;
    private String defaultCatalog = null;
    private boolean isTenantBasedStorage = false;
    private static final String CONNECTORREAD = "CONNECTORREAD".intern();
    private static final String CONNECTORWRITE = "CONNECTORWRITE".intern();
    private static final String EXTWRITE = "EXTWRITE".intern();
    private static final String EXTREAD = "EXTREAD".intern();
    private static final String HIVEBUCKET2 = "HIVEBUCKET2".intern();
    private static final String HIVECACHEINVALIDATE = "HIVECACHEINVALIDATE".intern();
    private static final String HIVEFULLACIDREAD = "HIVEFULLACIDREAD".intern();
    private static final String HIVEFULLACIDWRITE = "HIVEFULLACIDWRITE".intern();
    private static final String HIVEMANAGEDINSERTREAD = "HIVEMANAGEDINSERTREAD".intern();
    private static final String HIVEMANAGEDINSERTWRITE = "HIVEMANAGEDINSERTWRITE".intern();
    private static final String HIVEMANAGESTATS = "HIVEMANAGESTATS".intern();
    private static final String HIVEMQT = "HIVEMQT".intern();
    private static final String HIVEONLYMQTWRITE = "HIVEONLYMQTWRITE".intern();
    private static final String HIVESQL = "HIVESQL".intern();
    private static final String OBJCAPABILITIES = "OBJCAPABILITIES".intern();
    private static final String MANAGERAWMETADATA = "MANAGE_RAW_METADATA".intern();
    private static final String EXTERNALTABLESONLY = "EXTERNAL_TABLES_ONLY".intern();
    private static final List<String> ACIDCOMMONWRITELIST = new ArrayList<String>(Arrays.asList(HIVEMANAGESTATS, HIVECACHEINVALIDATE, CONNECTORWRITE));
    private List<String> acidWriteList = new ArrayList<String>(Arrays.asList(HIVEFULLACIDWRITE));
    private List<String> insertOnlyWriteList = new ArrayList<String>(Arrays.asList(HIVEMANAGEDINSERTWRITE));
    private static List<String> MQTLIST = new ArrayList<String>(Arrays.asList(HIVEFULLACIDREAD, HIVEONLYMQTWRITE, HIVEMANAGESTATS, HIVEMQT, CONNECTORREAD));
    private List<String> acidList = new ArrayList<String>();
    private List<String> insertOnlyList = new ArrayList<String>();

    public MetastoreDefaultTransformer(IHMSHandler handler) throws HiveMetaException {
        this.hmsHandler = handler;
        this.defaultCatalog = MetaStoreUtils.getDefaultCatalog(handler.getConf());
        this.isTenantBasedStorage = this.hmsHandler.getConf().getBoolean(MetastoreConf.ConfVars.ALLOW_TENANT_BASED_STORAGE.getVarname(), false);
        this.acidWriteList.addAll(ACIDCOMMONWRITELIST);
        this.acidList.addAll(this.acidWriteList);
        this.acidList.add(HIVEFULLACIDREAD);
        this.acidList.add(CONNECTORREAD);
        this.insertOnlyWriteList.addAll(ACIDCOMMONWRITELIST);
        this.insertOnlyList.addAll(this.insertOnlyWriteList);
        this.insertOnlyList.add(HIVEMANAGEDINSERTREAD);
        this.insertOnlyList.add(CONNECTORREAD);
    }

    @Override
    public Map<Table, List<String>> transform(List<Table> objects, List<String> processorCapabilities, String processorId) throws MetaException {
        LOG.info("Starting translation for processor " + processorId + " on list " + objects.size());
        HashMap<Table, List<String>> ret = new HashMap<Table, List<String>>();
        block23: for (Table table : objects) {
            ArrayList<String> generated = new ArrayList<String>();
            ArrayList<String> requiredReads = new ArrayList<String>();
            ArrayList<String> requiredWrites = new ArrayList<String>();
            if (!this.defaultCatalog.equalsIgnoreCase(table.getCatName())) {
                ret.put(table, generated);
                continue;
            }
            Map<String, String> params = table.getParameters();
            String tableType = table.getTableType();
            String tCapabilities = params.get(OBJCAPABILITIES);
            int numBuckets = table.isSetSd() ? table.getSd().getNumBuckets() : 0;
            boolean isBucketed = numBuckets > 0;
            LOG.info("Table " + table.getTableName() + ",#bucket=" + numBuckets + ",isBucketed:" + isBucketed + ",tableType=" + tableType + ",tableCapabilities=" + tCapabilities);
            if (tCapabilities == null) {
                LOG.debug("Table has no specific required capabilities");
                switch (tableType) {
                    case "EXTERNAL_TABLE": {
                        Table newTable = new Table(table);
                        generated.add(EXTREAD);
                        generated.add(EXTWRITE);
                        if (numBuckets > 0) {
                            generated.add(HIVEBUCKET2);
                            if (processorCapabilities.contains(HIVEBUCKET2)) {
                                LOG.debug("External bucketed table with HB2 capability:RW");
                                newTable.setAccessType((byte)8);
                            } else {
                                LOG.debug("External bucketed table without HB2 capability:RO");
                                newTable.setAccessType((byte)2);
                                requiredWrites.add(HIVEBUCKET2);
                                StorageDescriptor newSd = new StorageDescriptor(table.getSd());
                                newSd.setNumBuckets(-1);
                                newTable.setSd(newSd);
                                newTable.setRequiredWriteCapabilities(requiredWrites);
                                LOG.info("Bucketed table without HIVEBUCKET2 capability, removed bucketing info from table");
                            }
                        } else if (processorCapabilities.contains(EXTWRITE) && processorCapabilities.contains(EXTREAD)) {
                            LOG.debug("External unbucketed table with EXTREAD/WRITE capability:RW");
                            newTable.setAccessType((byte)8);
                        } else if (processorCapabilities.contains(EXTREAD)) {
                            LOG.debug("External unbucketed table with EXTREAD capability:RO");
                            newTable.setAccessType((byte)2);
                            requiredWrites.add(EXTWRITE);
                            newTable.setRequiredWriteCapabilities(requiredWrites);
                        } else {
                            LOG.debug("External unbucketed table without EXTREAD/WRITE capability:NONE");
                            newTable.setAccessType((byte)1);
                            requiredReads.add(EXTREAD);
                            requiredWrites.add(EXTWRITE);
                            newTable.setRequiredWriteCapabilities(requiredWrites);
                            newTable.setRequiredReadCapabilities(requiredReads);
                        }
                        ret.put(newTable, generated);
                        continue block23;
                    }
                    case "MANAGED_TABLE": {
                        String txnal = params.get("transactional");
                        if (txnal == null || txnal.equalsIgnoreCase("FALSE")) {
                            LOG.debug("Managed non-acid table:RW");
                            table.setAccessType((byte)8);
                            generated.addAll(this.acidWriteList);
                        }
                        if (txnal != null && txnal.equalsIgnoreCase("TRUE")) {
                            String txntype = params.get("transactional_properties");
                            if (txntype != null && txntype.equalsIgnoreCase("insert_only")) {
                                if (processorCapabilities.contains(HIVEMANAGEDINSERTWRITE) || processorCapabilities.contains(CONNECTORWRITE)) {
                                    LOG.debug("Managed acid table with INSERTWRITE or CONNECTORWRITE capability:RW");
                                    table.setAccessType((byte)8);
                                    processorCapabilities.retainAll(this.insertOnlyWriteList);
                                    generated.addAll(processorCapabilities);
                                    LOG.info("Processor has one of the write capabilities on insert-only, granting RW");
                                } else if (processorCapabilities.contains(HIVEMANAGEDINSERTREAD) || processorCapabilities.contains(CONNECTORREAD)) {
                                    LOG.debug("Managed acid table with INSERTREAD or CONNECTORREAD capability:RO");
                                    table.setAccessType((byte)2);
                                    generated.addAll(this.insertOnlyWriteList);
                                    table.setRequiredWriteCapabilities(this.insertOnlyWriteList);
                                    processorCapabilities.retainAll(this.getReads(this.insertOnlyList));
                                    generated.addAll(processorCapabilities);
                                    LOG.info("Processor has one of the read capabilities on insert-only, granting RO");
                                } else {
                                    table.setAccessType((byte)1);
                                    generated.addAll(this.acidList);
                                    generated.addAll(this.insertOnlyList);
                                    table.setRequiredWriteCapabilities(this.insertOnlyWriteList);
                                    table.setRequiredReadCapabilities(Arrays.asList(CONNECTORREAD, HIVEMANAGEDINSERTREAD));
                                    LOG.info("Processor has no read or write capabilities on insert-only, NO access");
                                }
                            } else if (processorCapabilities.contains(HIVEFULLACIDWRITE) || processorCapabilities.contains(CONNECTORWRITE)) {
                                LOG.debug("Full acid table with ACIDWRITE or CONNECTORWRITE capability:RW");
                                table.setAccessType((byte)8);
                                processorCapabilities.retainAll(this.acidWriteList);
                                generated.addAll(processorCapabilities);
                            } else if (processorCapabilities.contains(HIVEFULLACIDREAD) || processorCapabilities.contains(CONNECTORREAD)) {
                                LOG.debug("Full acid table with ACIDREAD or CONNECTORREAD capability:RO");
                                table.setAccessType((byte)2);
                                generated.addAll(this.acidWriteList);
                                table.setRequiredWriteCapabilities(this.acidWriteList);
                                processorCapabilities.retainAll(this.getReads(this.acidList));
                                generated.addAll(processorCapabilities);
                            } else {
                                LOG.debug("Full acid table without ACIDREAD/WRITE or CONNECTORREAD/WRITE capability:NONE");
                                table.setAccessType((byte)1);
                                table.setRequiredWriteCapabilities(this.acidWriteList);
                                table.setRequiredReadCapabilities(Arrays.asList(CONNECTORREAD, HIVEFULLACIDREAD));
                                generated.addAll(this.acidList);
                            }
                        }
                        ret.put(table, generated);
                        continue block23;
                    }
                    case "VIRTUAL_VIEW": {
                        if (processorCapabilities.contains(HIVESQL) || processorCapabilities.contains(CONNECTORREAD)) {
                            table.setAccessType((byte)2);
                        } else {
                            table.setAccessType((byte)1);
                            table.setRequiredReadCapabilities(generated);
                            generated.add(HIVESQL);
                            generated.add(CONNECTORREAD);
                        }
                        ret.put(table, generated);
                        continue block23;
                    }
                    case "MATERIALIZED_VIEW": {
                        if ((processorCapabilities.contains(CONNECTORREAD) || processorCapabilities.contains(HIVEFULLACIDREAD)) && processorCapabilities.contains(HIVEMQT)) {
                            LOG.info("Processor has one of the READ abilities and HIVEMQT, AccessType=RO");
                            table.setAccessType((byte)2);
                            generated.addAll(this.diff(MQTLIST, processorCapabilities));
                        } else {
                            LOG.info("Processor has no READ abilities or HIVEMQT, AccessType=None");
                            table.setAccessType((byte)1);
                            table.setRequiredReadCapabilities(Arrays.asList(CONNECTORREAD, HIVEMQT));
                            generated.addAll(MQTLIST);
                        }
                        ret.put(table, generated);
                        continue block23;
                    }
                }
                table.setAccessType((byte)1);
                ret.put(table, generated);
                continue;
            }
            tCapabilities = tCapabilities.replaceAll("\\s", "").toUpperCase();
            List<String> requiredCapabilities = Arrays.asList(tCapabilities.split(","));
            switch (tableType) {
                case "EXTERNAL_TABLE": {
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        LOG.info("Abilities for match: Table type=" + tableType + ",accesstype is RW");
                        table.setAccessType((byte)8);
                        ret.put(table, requiredCapabilities);
                        continue block23;
                    }
                    Table newTable = new Table(table);
                    boolean removedBucketing = false;
                    if (requiredCapabilities.contains(HIVEBUCKET2) && !processorCapabilities.contains(HIVEBUCKET2)) {
                        StorageDescriptor newSd = new StorageDescriptor(table.getSd());
                        newSd.setNumBuckets(-1);
                        newTable.setSd(newSd);
                        removedBucketing = true;
                        newTable.setAccessType((byte)2);
                        LOG.debug("Adding HIVEBUCKET2 to requiredWrites");
                        requiredWrites.add(HIVEBUCKET2);
                        LOG.info("Removed bucketing information from table");
                    }
                    if (requiredCapabilities.contains(EXTWRITE) && processorCapabilities.contains(EXTWRITE) && !removedBucketing) {
                        LOG.info("EXTWRITE Matches, accessType=8");
                        newTable.setAccessType((byte)8);
                        ret.put(newTable, requiredCapabilities);
                        continue block23;
                    }
                    if (requiredCapabilities.contains(EXTREAD) && processorCapabilities.contains(EXTREAD)) {
                        LOG.info("EXTREAD Matches, accessType=2");
                        newTable.setAccessType((byte)2);
                        requiredWrites.add(EXTWRITE);
                        newTable.setRequiredWriteCapabilities(requiredWrites);
                    } else {
                        LOG.debug("No matches, accessType=1");
                        newTable.setAccessType((byte)1);
                        requiredReads.add(EXTREAD);
                        requiredWrites.addAll(this.getWrites(requiredCapabilities));
                        newTable.setRequiredReadCapabilities(requiredReads);
                        newTable.setRequiredWriteCapabilities(requiredWrites);
                    }
                    LOG.info("setting required to " + requiredCapabilities);
                    ret.put(newTable, requiredCapabilities);
                    continue block23;
                }
                case "MANAGED_TABLE": {
                    if (processorCapabilities.size() == 0) {
                        LOG.info("Client has no capabilities for type " + tableType + ",accesstype is NONE");
                        table.setAccessType((byte)1);
                        table.setRequiredReadCapabilities(this.getReads(requiredCapabilities));
                        table.setRequiredWriteCapabilities(this.getWrites(requiredCapabilities));
                        ret.put(table, requiredCapabilities);
                        continue block23;
                    }
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        LOG.info("Abilities for match: Table type=" + tableType + ",accesstype is RW");
                        table.setAccessType((byte)8);
                        ret.put(table, requiredCapabilities);
                        continue block23;
                    }
                    String txnal = params.get("transactional");
                    if (txnal == null || txnal.equalsIgnoreCase("FALSE")) {
                        LOG.info("Table is non ACID, accesstype is RO");
                        table.setAccessType((byte)2);
                        List<String> missing = this.diff(requiredCapabilities, processorCapabilities);
                        table.setRequiredWriteCapabilities(this.getWrites(missing));
                        ret.put(table, missing);
                        continue block23;
                    }
                    if (txnal != null && txnal.equalsIgnoreCase("TRUE")) {
                        String txntype = params.get("transactional_properties");
                        ArrayList<String> hintList = new ArrayList<String>();
                        if (txntype != null && txntype.equalsIgnoreCase("insert_only")) {
                            LOG.info("Table is INSERTONLY ACID");
                            if (processorCapabilities.containsAll(this.getWrites(requiredCapabilities)) || processorCapabilities.contains(HIVEFULLACIDWRITE)) {
                                LOG.info("Processor has all writes or full acid write, access is RW");
                                table.setAccessType((byte)8);
                                ret.put(table, hintList);
                                continue block23;
                            }
                            if (processorCapabilities.contains(CONNECTORWRITE)) {
                                LOG.debug("Managed acid table with CONNECTORWRITE capability:RW");
                                table.setAccessType((byte)8);
                                hintList.add(CONNECTORWRITE);
                                hintList.addAll(this.getReads(requiredCapabilities));
                                ret.put(table, hintList);
                                continue block23;
                            }
                            if (processorCapabilities.containsAll(this.getReads(requiredCapabilities)) || processorCapabilities.contains(HIVEMANAGEDINSERTREAD)) {
                                LOG.debug("Managed acid table with MANAGEDREAD capability:RO");
                                table.setAccessType((byte)2);
                                table.setRequiredWriteCapabilities(this.diff(this.getWrites(requiredCapabilities), this.getWrites(processorCapabilities)));
                                hintList.add(HIVEMANAGEDINSERTWRITE);
                                hintList.addAll(this.diff(this.getWrites(requiredCapabilities), processorCapabilities));
                                ret.put(table, hintList);
                                continue block23;
                            }
                            if (processorCapabilities.contains(CONNECTORREAD)) {
                                LOG.debug("Managed acid table with CONNECTORREAD capability:RO");
                                table.setAccessType((byte)2);
                                table.setRequiredWriteCapabilities(this.diff(this.getWrites(requiredCapabilities), this.getWrites(processorCapabilities)));
                                hintList.add(CONNECTORREAD);
                                hintList.addAll(this.diff(this.getWrites(requiredCapabilities), processorCapabilities));
                                ret.put(table, hintList);
                                continue block23;
                            }
                            LOG.debug("Managed acid table without any READ capability:NONE");
                            table.setAccessType((byte)1);
                            ret.put(table, requiredCapabilities);
                            table.setRequiredWriteCapabilities(this.diff(this.getWrites(requiredCapabilities), this.getWrites(processorCapabilities)));
                            table.setRequiredReadCapabilities(this.diff(this.getReads(requiredCapabilities), this.getReads(processorCapabilities)));
                            continue block23;
                        }
                        LOG.info("Table is FULLACID");
                        if (processorCapabilities.containsAll(this.getWrites(requiredCapabilities)) || processorCapabilities.contains(HIVEFULLACIDWRITE)) {
                            LOG.info("Processor has all writes or atleast " + HIVEFULLACIDWRITE + ", access is RW");
                            table.setAccessType((byte)8);
                            hintList.add(HIVEFULLACIDWRITE);
                            ret.put(table, hintList);
                            continue block23;
                        }
                        if (processorCapabilities.contains(CONNECTORWRITE)) {
                            LOG.debug("Full acid table with CONNECTORWRITE capability:RW");
                            table.setAccessType((byte)8);
                            hintList.add(CONNECTORWRITE);
                            hintList.addAll(this.getReads(requiredCapabilities));
                            ret.put(table, hintList);
                            continue block23;
                        }
                        if (processorCapabilities.contains(HIVEFULLACIDREAD) || processorCapabilities.contains(CONNECTORREAD)) {
                            LOG.debug("Full acid table with CONNECTORREAD/ACIDREAD capability:RO");
                            table.setAccessType((byte)2);
                            table.setRequiredWriteCapabilities(this.diff(this.getWrites(requiredCapabilities), this.getWrites(processorCapabilities)));
                            hintList.add(CONNECTORREAD);
                            hintList.addAll(this.diff(this.getWrites(requiredCapabilities), processorCapabilities));
                            ret.put(table, hintList);
                            continue block23;
                        }
                        LOG.debug("Full acid table without READ capability:RO");
                        table.setAccessType((byte)1);
                        table.setRequiredWriteCapabilities(this.diff(this.getWrites(requiredCapabilities), this.getWrites(processorCapabilities)));
                        table.setRequiredReadCapabilities(this.diff(this.getReads(requiredCapabilities), this.getReads(processorCapabilities)));
                        ret.put(table, requiredCapabilities);
                        continue block23;
                    }
                    LOG.info("setting required to " + ret.get(table) + ",MANAGED:Access=" + table.getAccessType());
                    continue block23;
                }
                case "VIRTUAL_VIEW": 
                case "MATERIALIZED_VIEW": {
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        table.setAccessType((byte)2);
                        ret.put(table, new ArrayList());
                        continue block23;
                    }
                    table.setAccessType((byte)1);
                    table.setRequiredReadCapabilities(this.diff(this.getReads(requiredCapabilities), this.getReads(processorCapabilities)));
                    ret.put(table, requiredCapabilities);
                    continue block23;
                }
            }
            table.setAccessType((byte)1);
            table.setRequiredReadCapabilities(this.getReads(requiredCapabilities));
            table.setRequiredWriteCapabilities(this.getWrites(requiredCapabilities));
            ret.put(table, requiredCapabilities);
        }
        LOG.info("Transformer return list of " + ret.size());
        return ret;
    }

    @Override
    public List<Partition> transformPartitions(List<Partition> objects, Table table, List<String> processorCapabilities, String processorId) throws MetaException {
        if (processorCapabilities != null && processorCapabilities.contains(MANAGERAWMETADATA) || !this.defaultCatalog.equalsIgnoreCase(table.getCatName())) {
            LOG.debug("Table belongs to non-default catalog, skipping translation");
            return objects;
        }
        LOG.info("Starting translation for partition for processor " + processorId + " on list " + objects.size());
        ArrayList<Partition> ret = new ArrayList<Partition>();
        int partBuckets = 0;
        block16: for (Partition partition : objects) {
            StorageDescriptor newSd;
            Partition newPartition;
            String tableName = partition.getTableName();
            String dbName = partition.getDbName();
            Map<String, String> params = table.getParameters();
            if (params == null) {
                params = new HashMap<String, String>();
            }
            String tableType = table.getTableType();
            String tCapabilities = params.get(OBJCAPABILITIES);
            if (partition.getSd() != null) {
                partBuckets = partition.getSd().getNumBuckets();
                LOG.info("Number of original part buckets=" + partBuckets);
            } else {
                partBuckets = 0;
            }
            if (tCapabilities == null) {
                LOG.debug("Table " + table.getTableName() + " has no specific required capabilities");
                switch (tableType) {
                    case "EXTERNAL_TABLE": {
                        if (partBuckets > 0 && !processorCapabilities.contains(HIVEBUCKET2)) {
                            Partition newPartition2 = new Partition(partition);
                            StorageDescriptor newSd2 = new StorageDescriptor(partition.getSd());
                            newSd2.setNumBuckets(-1);
                            newPartition2.setSd(newSd2);
                            ret.add(newPartition2);
                            break;
                        }
                        ret.add(partition);
                        break;
                    }
                    case "MANAGED_TABLE": {
                        String txnal = params.get("transactional");
                        if ((txnal == null || "FALSE".equalsIgnoreCase(txnal)) && partBuckets > 0 && !processorCapabilities.contains(HIVEBUCKET2)) {
                            newPartition = new Partition(partition);
                            newSd = new StorageDescriptor(partition.getSd());
                            newSd.setNumBuckets(-1);
                            newPartition.setSd(newSd);
                            ret.add(newPartition);
                            break;
                        }
                        ret.add(partition);
                        break;
                    }
                    default: {
                        ret.add(partition);
                        break;
                    }
                }
                continue;
            }
            tCapabilities = tCapabilities.replaceAll("\\s", "").toUpperCase();
            List<String> requiredCapabilities = Arrays.asList(tCapabilities.split(","));
            if (partBuckets <= 0 || processorCapabilities.containsAll(requiredCapabilities)) {
                ret.add(partition);
                continue;
            }
            switch (tableType) {
                case "EXTERNAL_TABLE": {
                    if (requiredCapabilities.contains(HIVEBUCKET2) && !processorCapabilities.contains(HIVEBUCKET2)) {
                        newPartition = new Partition(partition);
                        newSd = new StorageDescriptor(partition.getSd());
                        newSd.setNumBuckets(-1);
                        newPartition.setSd(newSd);
                        LOG.info("Removed bucketing information from partition");
                        ret.add(newPartition);
                        continue block16;
                    }
                }
                case "MANAGED_TABLE": {
                    String txnal = params.get("transactional");
                    if ((txnal == null || txnal.equalsIgnoreCase("FALSE")) && !processorCapabilities.contains(HIVEBUCKET2)) {
                        Partition newPartition3 = new Partition(partition);
                        StorageDescriptor newSd3 = new StorageDescriptor(partition.getSd());
                        newSd3.setNumBuckets(-1);
                        newPartition3.setSd(newSd3);
                        ret.add(newPartition3);
                        continue block16;
                    }
                    ret.add(partition);
                    continue block16;
                }
            }
            ret.add(partition);
        }
        LOG.info("Returning partition set of size " + ret.size());
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Table transformCreateTable(Table table, List<String> processorCapabilities, String processorId) throws MetaException {
        Table newTable;
        block16: {
            String tableType;
            block15: {
                boolean ctas_legacy_config;
                if (!this.defaultCatalog.equalsIgnoreCase(table.getCatName())) {
                    LOG.debug("Table belongs to non-default catalog, skipping");
                    return table;
                }
                newTable = new Table(table);
                LOG.info("Starting translation for CreateTable for processor " + processorId + " with " + processorCapabilities + " on table " + newTable.getTableName());
                Map<String, String> params = table.getParameters();
                if (params == null) {
                    params = new HashMap<String, String>();
                }
                tableType = newTable.getTableType();
                String txnal = null;
                String txn_properties = null;
                boolean isInsertAcid = false;
                String dbName = table.getDbName();
                Database db = null;
                try {
                    db = this.hmsHandler.get_database_core(table.getCatName(), table.getDbName());
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException("Database " + dbName + " for table " + table.getTableName() + " could not be found");
                }
                if (!TableType.MANAGED_TABLE.name().equals(tableType)) break block15;
                LOG.debug("Table is a MANAGED_TABLE");
                txnal = params.get("transactional");
                txn_properties = params.get("transactional_properties");
                isInsertAcid = txn_properties != null && txn_properties.equalsIgnoreCase("insert_only");
                boolean bl = ctas_legacy_config = params.containsKey("create_table_as_external") && params.get("create_table_as_external").equalsIgnoreCase("true");
                if ((txnal == null || txnal.equalsIgnoreCase("FALSE")) && !isInsertAcid || ctas_legacy_config && (txnal == null || txnal.equalsIgnoreCase("FALSE"))) {
                    LOG.info("Converting " + newTable.getTableName() + " to EXTERNAL tableType for " + processorId);
                    newTable.setTableType(TableType.EXTERNAL_TABLE.toString());
                    params.remove("transactional");
                    params.remove("transactional_properties");
                    params.put("EXTERNAL", "TRUE");
                    params.put("external.table.purge", "TRUE");
                    params.put("TRANSLATED_TO_EXTERNAL", "TRUE");
                    newTable.setParameters(params);
                    LOG.info("Modified table params are:" + params.toString());
                    if (this.getLocation(table) == null) {
                        try {
                            Path location = this.getTranslatedToExternalTableDefaultLocation(db, newTable);
                            newTable.getSd().setLocation(location.toString());
                        }
                        catch (Exception e) {
                            throw new MetaException("Exception determining external table location:" + e.getMessage());
                        }
                    }
                    break block16;
                } else {
                    if (db.getParameters().containsKey(EXTERNALTABLESONLY) && db.getParameters().get(EXTERNALTABLESONLY).equalsIgnoreCase("true")) {
                        throw new MetaException("Creation of ACID table is not allowed when the property 'EXTERNAL_TABLES_ONLY'='TRUE' is set on the database.");
                    }
                    if (processorCapabilities == null || processorCapabilities.isEmpty()) {
                        throw new MetaException("Processor has no capabilities, cannot create an ACID table.");
                    }
                    newTable = this.validateTablePaths(table);
                    if (isInsertAcid) {
                        if (processorCapabilities.contains(HIVEMANAGEDINSERTWRITE)) {
                            LOG.debug("Processor has required capabilities to be able to create INSERT-only tables");
                            return newTable;
                        }
                        throw new MetaException("Processor does not have capabilities to create a INSERT ACID table:" + this.diff(this.insertOnlyWriteList, processorCapabilities));
                    }
                    if (processorCapabilities.contains(HIVEFULLACIDWRITE)) {
                        LOG.debug("Processor has required capabilities to be able to create FULLACID tables.");
                        return newTable;
                    }
                    throw new MetaException("Processor does not have capabilities to create a FULL ACID table:" + this.diff(this.acidWriteList, processorCapabilities));
                }
            }
            if (TableType.EXTERNAL_TABLE.name().equals(tableType)) {
                LOG.debug("Table to be created is of type " + tableType);
                newTable = this.validateTablePaths(table);
            }
        }
        LOG.info("Transformer returning table:" + newTable.toString());
        return newTable;
    }

    private Path getTranslatedToExternalTableDefaultLocation(Database db, Table table) throws MetaException {
        String strategyVar = MetastoreConf.getVar(this.hmsHandler.getConf(), MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_LOCATION_MODE);
        TableLocationStrategy strategy = TableLocationStrategy.valueOf(strategyVar);
        int idx = 0;
        Path location = null;
        do {
            location = strategy.getLocation(this.hmsHandler, db, table, idx++);
        } while (strategy != TableLocationStrategy.force && this.hmsHandler.getWh().isDir(location));
        LOG.info("Using location {} for table {}", (Object)location, (Object)table.getTableName());
        return location;
    }

    private Path getLocation(Table table) {
        if (table.isSetSd() && StringUtils.isNotBlank(table.getSd().getLocation())) {
            return new Path(table.getSd().getLocation());
        }
        return null;
    }

    @Override
    public Table transformAlterTable(Table oldTable, Table newTable, List<String> processorCapabilities, String processorId) throws MetaException {
        if (!this.defaultCatalog.equalsIgnoreCase(newTable.getCatName())) {
            LOG.debug("Table belongs to non-default catalog, skipping translation");
            return newTable;
        }
        LOG.info("Starting translation for Alter table for processor " + processorId + " with " + processorCapabilities + " on table " + newTable.getTableName());
        if (this.tableLocationChanged(oldTable, newTable)) {
            this.validateTablePaths(newTable);
        }
        Database oldDb = this.getDbForTable(oldTable);
        boolean isTranslatedToExternalFollowsRenames = MetastoreConf.getBoolVar(this.hmsHandler.getConf(), MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_TRANSLATED_TO_EXTERNAL_FOLLOWS_RENAMES);
        if (isTranslatedToExternalFollowsRenames && this.isTableRename(oldTable, newTable) && this.isTranslatedToExternalTable(oldTable) && this.isTranslatedToExternalTable(newTable)) {
            Database newDb = this.getDbForTable(newTable);
            Path oldPath = TableLocationStrategy.getDefaultPath(this.hmsHandler, oldDb, oldTable.getTableName());
            if (oldTable.getSd().getLocation().equals(oldPath.toString())) {
                Path newPath = this.getTranslatedToExternalTableDefaultLocation(newDb, newTable);
                newTable.getSd().setLocation(newPath.toString());
            }
        }
        LOG.debug("Transformer returning table:" + newTable.toString());
        return newTable;
    }

    private Database getDbForTable(Table oldTable) throws MetaException {
        try {
            return this.hmsHandler.get_database_core(oldTable.getCatName(), oldTable.getDbName());
        }
        catch (NoSuchObjectException e) {
            throw new MetaException("Database " + oldTable.getTableName() + " for table " + oldTable.getTableName() + " could not be found");
        }
    }

    private boolean isTableRename(Table oldTable, Table newTable) {
        return !MetaStoreUtils.getTableNameFor(oldTable).equals(MetaStoreUtils.getTableNameFor(newTable));
    }

    private boolean isTranslatedToExternalTable(Table table) {
        Map<String, String> p = table.getParameters();
        return p != null && MetaStoreUtils.isPropertyTrue(p, "EXTERNAL") && MetaStoreUtils.isPropertyTrue(p, "TRANSLATED_TO_EXTERNAL") && table.getSd() != null && table.getSd().isSetLocation();
    }

    private boolean tableLocationChanged(Table oldTable, Table newTable) throws MetaException {
        if (!newTable.isSetSd() || newTable.getSd().getLocation() == null) {
            return false;
        }
        if (!oldTable.isSetSd() || oldTable.getSd().getLocation() == null) {
            return false;
        }
        return !oldTable.getSd().getLocation().equals(newTable.getSd().getLocation());
    }

    @Override
    public Database transformDatabase(Database db, List<String> processorCapabilities, String processorId) throws MetaException {
        if (processorCapabilities != null && processorCapabilities.contains(MANAGERAWMETADATA) || !this.defaultCatalog.equalsIgnoreCase(db.getCatalogName())) {
            LOG.debug("Database belongs to non-default catalog, skipping translation");
            return db;
        }
        LOG.info("Starting translation for transformDatabase for processor " + processorId + " with " + processorCapabilities + " on database {} locationUri={} managedLocationUri={}", new Object[]{db.getName(), db.getLocationUri(), db.getManagedLocationUri()});
        if (!this.isTenantBasedStorage) {
            Path locationPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(db.getLocationUri()));
            Path whRootPath = Path.getPathWithoutSchemeAndAuthority((Path)this.hmsHandler.getWh().getWhRoot());
            LOG.debug("Comparing DB and warehouse paths warehouse={} db.getLocationUri={}", (Object)whRootPath.toString(), (Object)locationPath.toString());
            if (FileUtils.isSubdirectory(whRootPath.toString(), locationPath.toString()) || locationPath.equals((Object)whRootPath)) {
                if (processorCapabilities != null && (processorCapabilities.contains(HIVEMANAGEDINSERTWRITE) || processorCapabilities.contains(HIVEFULLACIDWRITE))) {
                    LOG.debug("Processor has atleast one of ACID write capabilities, setting current locationUri " + db.getLocationUri() + " as managedLocationUri");
                    db.setManagedLocationUri(new Path(db.getLocationUri()).toString());
                }
                Path extWhLocation = this.hmsHandler.getWh().getDefaultExternalDatabasePath(db.getName());
                LOG.info("Database's location is a managed location, setting to a new default path based on external warehouse path:" + extWhLocation.toString());
                db.setLocationUri(extWhLocation.toString());
            }
        }
        LOG.info("Transformer returning database:" + db.toString());
        return db;
    }

    private List<String> diff(List<String> list1, List<String> list2) {
        ArrayList<String> diffList = new ArrayList<String>();
        if (list2 == null || list2.size() == 0) {
            return list1;
        }
        if (list1 == null || list1.size() == 0) {
            return new ArrayList<String>();
        }
        if (list2.containsAll(list1)) {
            return new ArrayList<String>();
        }
        diffList.addAll(list2);
        LOG.debug("diffList=" + Arrays.toString(diffList.toArray()) + ",master list=" + Arrays.toString(list1.toArray()));
        if (diffList.retainAll(list1)) {
            LOG.debug("diffList=" + Arrays.toString(diffList.toArray()));
            if (diffList.size() == list1.size()) {
                return new ArrayList<String>();
            }
            list1.removeAll(diffList);
            LOG.debug("list1.size():" + list1.size());
            return list1;
        }
        list1.removeAll(diffList);
        LOG.debug("diff returning " + Arrays.toString(diffList.toArray()) + ",full list=" + Arrays.toString(list1.toArray()));
        return list1;
    }

    private List<String> getWrites(List<String> capabilities) {
        ArrayList<String> writes = new ArrayList<String>();
        for (String capability : capabilities) {
            if (!capability.toUpperCase().endsWith("WRITE") && !capability.toUpperCase().endsWith("STATS") && !capability.toUpperCase().endsWith("INVALIDATE")) continue;
            writes.add(capability);
        }
        return writes;
    }

    private List<String> getReads(List<String> capabilities) {
        ArrayList<String> reads = new ArrayList<String>();
        for (String capability : capabilities) {
            if (!capability.toUpperCase().endsWith("READ") && !capability.toUpperCase().endsWith("SQL")) continue;
            reads.add(capability);
        }
        return reads;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Table validateTablePaths(Table table) throws MetaException {
        Database db = null;
        String tableLocation = table.isSetSd() ? table.getSd().getLocation() : null;
        try {
            db = this.hmsHandler.get_database_core(table.getCatName(), table.getDbName());
        }
        catch (NoSuchObjectException e) {
            throw new MetaException("Database " + table.getTableName() + " for table " + table.getTableName() + " could not be found");
        }
        if (TableType.MANAGED_TABLE.name().equals(table.getTableType())) {
            if (db.getManagedLocationUri() != null) {
                if (tableLocation != null) {
                    if (FileUtils.isSubdirectory(db.getManagedLocationUri(), tableLocation)) return table;
                    throw new MetaException("Illegal location for managed table, it has to be within database's managed location");
                }
                Path path = this.hmsHandler.getWh().getDefaultTablePath(db, table.getTableName(), false);
                table.getSd().setLocation(path.toString());
                return table;
            }
            if (tableLocation != null) {
                Path tablePath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tableLocation));
                if (FileUtils.isSubdirectory(this.hmsHandler.getWh().getWhRoot().toString(), tableLocation)) return table;
                throw new MetaException("A managed table's location should be located within managed warehouse root directory or within its database's managedLocationUri. Table " + table.getTableName() + "'s location is not valid:" + tableLocation + ", managed warehouse:" + this.hmsHandler.getWh().getWhRoot());
            }
            Path path = this.hmsHandler.getWh().getDefaultManagedTablePath(db, table.getTableName());
            table.getSd().setLocation(path.toString());
            return table;
        } else {
            Path whRootPath = Path.getPathWithoutSchemeAndAuthority((Path)this.hmsHandler.getWh().getWhRoot());
            Path dbLocation = Path.getPathWithoutSchemeAndAuthority((Path)new Path(db.getLocationUri()));
            LOG.debug("ValidateTablePaths: whRoot={} dbLocation={} tableLocation={} ", new Object[]{whRootPath.toString(), dbLocation.toString(), tableLocation});
            if (tableLocation != null) {
                Path tablePath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tableLocation));
                if (this.isTenantBasedStorage) {
                    if (!FileUtils.isSubdirectory(dbLocation.toString(), tablePath.toString())) {
                        throw new MetaException("An external table's location should not be located outside the location specified on its database, table:" + table.getTableName() + ",location:" + tablePath + ",Database location for external tables:" + dbLocation);
                    }
                    dbLocation = Path.getPathWithoutSchemeAndAuthority((Path)new Path(db.getManagedLocationUri()));
                    if (dbLocation == null || !FileUtils.isSubdirectory(dbLocation.toString(), tablePath.toString())) return table;
                    throw new MetaException("An external table's location should not be located within managed warehouse root directory of its database, table:" + table.getTableName() + ",location:" + tablePath + ",Database's managed warehouse:" + dbLocation);
                }
                if (!this.isExternalWarehouseSet() || !FileUtils.isSubdirectory(whRootPath.toString(), tablePath.toString())) return table;
                throw new MetaException("An external table's location should not be located within managed warehouse root directory, table:" + table.getTableName() + ",location:" + tablePath + ",managed warehouse:" + whRootPath);
            }
            Path tablePath = this.hmsHandler.getWh().getDefaultTablePath(db, table.getTableName(), true);
            table.getSd().setLocation(tablePath.toString());
        }
        return table;
    }

    private boolean isExternalWarehouseSet() {
        return this.hmsHandler.getConf().get(MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL.getVarname()) != null;
    }

    static enum TableLocationStrategy {
        seqprefix{

            @Override
            Path getLocation(IHMSHandler hmsHandler, Database db, Table table, int idx) throws MetaException {
                if (idx == 0) {
                    return TableLocationStrategy.getDefaultPath(hmsHandler, db, table.getTableName());
                }
                return TableLocationStrategy.getDefaultPath(hmsHandler, db, idx + "_" + table.getTableName());
            }
        }
        ,
        seqsuffix{

            @Override
            Path getLocation(IHMSHandler hmsHandler, Database db, Table table, int idx) throws MetaException {
                if (idx == 0) {
                    return TableLocationStrategy.getDefaultPath(hmsHandler, db, table.getTableName());
                }
                return TableLocationStrategy.getDefaultPath(hmsHandler, db, table.getTableName() + "_" + idx);
            }
        }
        ,
        prohibit{

            @Override
            Path getLocation(IHMSHandler hmsHandler, Database db, Table table, int idx) throws MetaException {
                Path p = TableLocationStrategy.getDefaultPath(hmsHandler, db, table.getTableName());
                if (idx == 0) {
                    return p;
                }
                throw new MetaException("Default location is not available for table: " + p);
            }
        }
        ,
        force{

            @Override
            Path getLocation(IHMSHandler hmsHandler, Database db, Table table, int idx) throws MetaException {
                Path p = TableLocationStrategy.getDefaultPath(hmsHandler, db, table.getTableName());
                return p;
            }
        };


        private static final Path getDefaultPath(IHMSHandler hmsHandler, Database db, String tableName) throws MetaException {
            return hmsHandler.getWh().getDefaultTablePath(db, tableName, true);
        }

        abstract Path getLocation(IHMSHandler var1, Database var2, Table var3, int var4) throws MetaException;
    }
}

