/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionFilterMode;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreException;

public class PartitionIterable
implements Iterable<Partition> {
    private final Type currType;
    private Collection<Partition> ptnsProvided = null;
    private IMetaStoreClient msc = null;
    private Table table = null;
    private List<String> partitionNames = null;
    private GetPartitionsRequest request = null;
    private int batch_size;

    @Override
    public Iterator<Partition> iterator() {
        return new Iterator<Partition>(){
            private boolean initialized = false;
            private Iterator<Partition> ptnsIterator = null;
            private Iterator<String> partitionNamesIter = null;
            private Iterator<Partition> batchIter = null;

            private void initialize() {
                if (!this.initialized) {
                    if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                        this.ptnsIterator = PartitionIterable.this.ptnsProvided.iterator();
                    } else {
                        this.partitionNamesIter = PartitionIterable.this.partitionNames.iterator();
                    }
                    this.initialized = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.ptnsIterator.hasNext();
                }
                return this.batchIter != null && this.batchIter.hasNext() || this.partitionNamesIter.hasNext();
            }

            @Override
            public Partition next() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.ptnsIterator.next();
                }
                if (this.batchIter == null || !this.batchIter.hasNext()) {
                    this.getNextBatch();
                }
                return this.batchIter.next();
            }

            private void getNextBatch() {
                ArrayList<String> nameBatch = new ArrayList<String>();
                for (int batch_counter = 0; batch_counter < PartitionIterable.this.batch_size && this.partitionNamesIter.hasNext(); ++batch_counter) {
                    nameBatch.add(this.partitionNamesIter.next());
                }
                try {
                    if (PartitionIterable.this.request != null) {
                        GetPartitionsFilterSpec getPartitionsFilterSpec = new GetPartitionsFilterSpec();
                        getPartitionsFilterSpec.setFilterMode(PartitionFilterMode.BY_NAMES);
                        getPartitionsFilterSpec.setFilters(nameBatch);
                        PartitionIterable.this.request.setFilterSpec(getPartitionsFilterSpec);
                        this.batchIter = MetaStoreUtils.getPartitionsByProjectSpec(PartitionIterable.this.msc, PartitionIterable.this.request).iterator();
                    } else {
                        this.batchIter = PartitionIterable.this.msc.getPartitionsByNames(PartitionIterable.this.table.getCatName(), PartitionIterable.this.table.getDbName(), PartitionIterable.this.table.getTableName(), nameBatch).iterator();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new IllegalStateException("PartitionIterable is a read-only iterable and remove() is unsupported");
            }
        };
    }

    public PartitionIterable(Collection<Partition> ptnsProvided) {
        this.currType = Type.LIST_PROVIDED;
        this.ptnsProvided = ptnsProvided;
    }

    public PartitionIterable(IMetaStoreClient msc, Table table, int batch_size) throws MetastoreException {
        this.currType = Type.LAZY_FETCH_PARTITIONS;
        this.msc = msc;
        this.table = table;
        this.batch_size = batch_size;
        this.partitionNames = this.getPartitionNames(msc, table.getCatName(), table.getDbName(), table.getTableName(), (short)-1);
    }

    public List<String> getPartitionNames(IMetaStoreClient msc, String catName, String dbName, String tblName, short max) throws MetastoreException {
        try {
            return msc.listPartitionNames(catName, dbName, tblName, (int)max);
        }
        catch (Exception e) {
            throw new MetastoreException(e);
        }
    }

    public PartitionIterable withProjectSpec(GetPartitionsRequest request) {
        this.request = request;
        return this;
    }

    static enum Type {
        LIST_PROVIDED,
        LAZY_FETCH_PARTITIONS;

    }
}

