/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class TableFields {
    private static final ImmutableMap<String, String> allSingleValuedFields = new ImmutableMap.Builder<String, String>().put("id", "id").put("tableName", "tableName").put("dbName", "database.name").put("owner", "owner").put("ownerType", "ownerType").put("createTime", "createTime").put("lastAccessTime", "lastAccessTime").put("retention", "retention").put("sd.location", "sd.location").put("sd.inputFormat", "sd.inputFormat").put("sd.outputFormat", "sd.outputFormat").put("sd.compressed", "sd.isCompressed").put("sd.numBuckets", "sd.numBuckets").put("sd.serdeInfo.name", "sd.serDeInfo.name").put("sd.serdeInfo.serializationLib", "sd.serDeInfo.serializationLib").put("sd.serdeInfo.description", "sd.serDeInfo.description").put("sd.serdeInfo.serializerClass", "sd.serDeInfo.serializerClass").put("sd.serdeInfo.deserializerClass", "sd.serDeInfo.deserializerClass").put("sd.serdeInfo.serdeType", "sd.serDeInfo.serdeType").put("sd.storedAsSubDirectories", "isStoredAsSubDirectories").put("viewOriginalText", "viewOriginalText").put("viewExpandedText", "viewExpandedText").put("rewriteEnabled", "rewriteEnabled").put("tableType", "tableType").put("writeId", "writeId").build();
    private static final ImmutableSet<String> allMultiValuedFields = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add("values")).add("sd.cols.name")).add("sd.cols.type")).add("sd.cols.comment")).add("sd.serdeInfo.parameters")).add("sd.bucketCols")).add("sd.sortCols.col")).add("sd.sortCols.order")).add("sd.parameters")).add("sd.skewedInfo.skewedColNames")).add("sd.skewedInfo.skewedColValues")).add("sd.skewedInfo.skewedColValueLocationMaps")).add("partitionKeys.name")).add("partitionKeys.type")).add("partitionKeys.comment")).add("parameters")).build();
    private static final ImmutableSet<String> allFields = ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)allSingleValuedFields.keySet())).addAll(allMultiValuedFields)).build();

    private static void validate(Collection<String> projectionFields) throws MetaException {
        HashSet<String> verify = new HashSet<String>(projectionFields);
        verify.removeAll(allFields);
        if (verify.size() > 0) {
            throw new MetaException("Invalid table fields in the projection spec" + Arrays.toString(verify.toArray(new String[verify.size()])));
        }
    }

    public static List<String> getMFieldNames(List<String> fields) throws MetaException {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        TableFields.validate(fields);
        if (!((AbstractCollection)((Object)allSingleValuedFields.keySet())).containsAll(fields)) {
            return null;
        }
        ArrayList<String> jdoFields = new ArrayList<String>(fields.size());
        for (String field : fields) {
            jdoFields.add(allSingleValuedFields.get(field));
        }
        return jdoFields;
    }
}

