/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPool.class);
    private static ThreadPool self;
    private static ScheduledExecutorService pool;

    public static synchronized ThreadPool initialize(Configuration conf) {
        if (self == null) {
            self = new ThreadPool(conf);
            LOG.debug("ThreadPool initialized");
        }
        return self;
    }

    private ThreadPool(Configuration conf) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Metastore Scheduled Worker %d").build();
        pool = Executors.newScheduledThreadPool(MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.THREAD_POOL_SIZE), threadFactory);
    }

    public static ScheduledExecutorService getPool() {
        if (self == null) {
            throw new RuntimeException("ThreadPool accessed before initialized");
        }
        return pool;
    }

    public static synchronized void shutdown() {
        if (self != null) {
            pool.shutdown();
            self = null;
        }
    }
}

