/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AbortTxnEvent
extends ListenerEvent {
    private final Long txnId;
    private final TxnType txnType;
    private final List<String> dbsUpdated;

    public AbortTxnEvent(Long transactionId, IHMSHandler handler) {
        this(transactionId, null, handler, null);
    }

    public AbortTxnEvent(Long transactionId, TxnType txnType) {
        this(transactionId, txnType, null, null);
    }

    public AbortTxnEvent(Long transactionId, TxnType txnType, IHMSHandler handler, List<String> dbsUpdated) {
        super(true, handler);
        this.txnId = transactionId;
        this.txnType = txnType;
        this.dbsUpdated = new ArrayList<String>();
        if (dbsUpdated != null) {
            this.dbsUpdated.addAll(dbsUpdated);
        }
    }

    public Long getTxnId() {
        return this.txnId;
    }

    public TxnType getTxnType() {
        return this.txnType;
    }

    public List<String> getDbsUpdated() {
        return this.dbsUpdated;
    }
}

