/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(Configuration conf) {
        Collection<String> groupFilter = MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER);
        if (groupFilter.size() == 1 && groupFilter.contains("")) {
            groupFilter = Collections.emptySet();
        }
        if (groupFilter.isEmpty()) {
            return null;
        }
        if (StringUtils.isBlank(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY))) {
            return new GroupMembershipKeyFilter(groupFilter);
        }
        return new UserMembershipKeyFilter(groupFilter);
    }

    @VisibleForTesting
    static final class UserMembershipKeyFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(UserMembershipKeyFilter.class);
        private final Collection<String> groupFilter;

        UserMembershipKeyFilter(Collection<String> groupFilter) {
            this.groupFilter = groupFilter;
        }

        @Override
        public void apply(DirSearch ldap, String user) throws AuthenticationException {
            LOG.info("Authenticating user '{}' using {}", (Object)user, (Object)UserMembershipKeyFilter.class.getSimpleName());
            ArrayList<String> groupDns = new ArrayList<String>();
            for (String groupId : this.groupFilter) {
                try {
                    String groupDn = ldap.findGroupDn(groupId);
                    groupDns.add(groupDn);
                }
                catch (NamingException e) {
                    LOG.warn("Cannot find DN for group", (Throwable)e);
                    LOG.debug("Cannot find DN for group " + groupId, (Throwable)e);
                }
            }
            if (groupDns.isEmpty()) {
                String msg = String.format("No DN(s) has been found for any of group(s): %s", Joiner.on(',').join(this.groupFilter));
                LOG.debug(msg);
                throw new AuthenticationException("No DN(s) has been found for any of specified group(s)");
            }
            for (String groupDn : groupDns) {
                try {
                    if (!ldap.isUserMemberOfGroup(user, groupDn)) continue;
                    LOG.debug("UserMembershipKeyFilter passes: user '{}' is a member of '{}' group", (Object)user, (Object)groupDn);
                    LOG.info("Authentication succeeded based on user membership");
                    return;
                }
                catch (NamingException e) {
                    LOG.warn("Cannot match user and group", (Throwable)e);
                    if (!LOG.isDebugEnabled()) continue;
                    String msg = String.format("Cannot match user '%s' and group '%s'", user, groupDn);
                    LOG.debug(msg, (Throwable)e);
                }
            }
            throw new AuthenticationException(String.format("Authentication failed: User '%s' is not a member of listed groups", user));
        }
    }

    @VisibleForTesting
    static final class GroupMembershipKeyFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(GroupMembershipKeyFilter.class);
        private final Set<String> groupFilter = new HashSet<String>();

        GroupMembershipKeyFilter(Collection<String> groupFilter) {
            this.groupFilter.addAll(groupFilter);
        }

        @Override
        public void apply(DirSearch ldap, String user) throws AuthenticationException {
            LOG.info("Authenticating user '{}' using {}", (Object)user, (Object)GroupMembershipKeyFilter.class.getSimpleName());
            List<String> memberOf = null;
            try {
                String userDn = ldap.findUserDn(user);
                memberOf = ldap.findGroupsForUser(userDn);
                LOG.debug("User {} member of : {}", (Object)userDn, memberOf);
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
            for (String groupDn : memberOf) {
                String shortName = LdapUtils.getShortName(groupDn);
                if (!this.groupFilter.stream().anyMatch(shortName::equalsIgnoreCase)) continue;
                LOG.debug("GroupMembershipKeyFilter passes: user '{}' is a member of '{}' group", (Object)user, (Object)groupDn);
                LOG.info("Authentication succeeded based on group membership");
                return;
            }
            LOG.info("Authentication failed based on user membership");
            throw new AuthenticationException("Authentication failed: User not a member of specified list");
        }
    }
}

