/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.ThreadPool;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;

public class HouseKeepingTasks
implements LeaderElection.LeadershipStateListener {
    private final Configuration configuration;
    private ThreadPool metastoreTaskThreadPool;
    private boolean runOnlyRemoteTasks;
    private List<MetastoreTaskThread> runningTasks;

    public HouseKeepingTasks(Configuration configuration, boolean runOnlyRemoteTasks) {
        this.configuration = new Configuration(Objects.requireNonNull(configuration, "configuration is null"));
        this.runOnlyRemoteTasks = runOnlyRemoteTasks;
    }

    public List<MetastoreTaskThread> getRemoteOnlyTasks() throws Exception {
        ArrayList<MetastoreTaskThread> remoteOnlyTasks = new ArrayList<MetastoreTaskThread>();
        if (!MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_THREADS_ON)) {
            return remoteOnlyTasks;
        }
        Collection<String> taskNames = MetastoreConf.getStringCollection(this.configuration, MetastoreConf.ConfVars.TASK_THREADS_REMOTE_ONLY);
        for (String taskName : taskNames) {
            MetastoreTaskThread task = JavaUtils.newInstance(JavaUtils.getClass(taskName, MetastoreTaskThread.class));
            remoteOnlyTasks.add(task);
        }
        return remoteOnlyTasks;
    }

    public List<MetastoreTaskThread> getAlwaysTasks() throws Exception {
        ArrayList<MetastoreTaskThread> alwaysTasks = new ArrayList<MetastoreTaskThread>();
        Collection<String> taskNames = MetastoreConf.getStringCollection(this.configuration, MetastoreConf.ConfVars.TASK_THREADS_ALWAYS);
        for (String taskName : taskNames) {
            MetastoreTaskThread task = JavaUtils.newInstance(JavaUtils.getClass(taskName, MetastoreTaskThread.class));
            alwaysTasks.add(task);
        }
        return alwaysTasks;
    }

    @Override
    public void takeLeadership(LeaderElection election) throws Exception {
        if (this.metastoreTaskThreadPool != null) {
            throw new IllegalStateException("There should be no running tasks before taking the leadership!");
        }
        this.runningTasks = new ArrayList<MetastoreTaskThread>();
        this.metastoreTaskThreadPool = ThreadPool.initialize(this.configuration);
        if (!this.runOnlyRemoteTasks) {
            ArrayList<MetastoreTaskThread> alwaysTasks = new ArrayList<MetastoreTaskThread>(this.getAlwaysTasks());
            for (MetastoreTaskThread task2 : alwaysTasks) {
                task2.setConf(this.configuration);
                long freq = task2.runFrequency(TimeUnit.MILLISECONDS);
                if (freq <= 0L) continue;
                this.runningTasks.add(task2);
                HouseKeepingTasks houseKeepingTasks = this;
                houseKeepingTasks.metastoreTaskThreadPool.getPool().scheduleAtFixedRate(task2, freq, freq, TimeUnit.MILLISECONDS);
            }
        } else {
            ArrayList<MetastoreTaskThread> remoteOnlyTasks = new ArrayList<MetastoreTaskThread>(this.getRemoteOnlyTasks());
            for (MetastoreTaskThread task3 : remoteOnlyTasks) {
                task3.setConf(this.configuration);
                long freq = task3.runFrequency(TimeUnit.MILLISECONDS);
                this.runningTasks.add(task3);
                HouseKeepingTasks houseKeepingTasks = this;
                houseKeepingTasks.metastoreTaskThreadPool.getPool().scheduleAtFixedRate(task3, freq, freq, TimeUnit.MILLISECONDS);
            }
        }
        this.runningTasks.forEach(task -> HiveMetaStore.LOG.info("Scheduling for " + task.getClass().getCanonicalName() + " service."));
    }

    @Override
    public void lossLeadership(LeaderElection election) throws Exception {
        if (this.metastoreTaskThreadPool != null) {
            HouseKeepingTasks houseKeepingTasks = this;
            houseKeepingTasks.metastoreTaskThreadPool.shutdown();
            this.metastoreTaskThreadPool = null;
        }
        if (this.runningTasks != null && !this.runningTasks.isEmpty()) {
            this.runningTasks.forEach(task -> HiveMetaStore.LOG.info("Stopped the Housekeeping task: {}", (Object)task.getClass().getCanonicalName()));
            this.runningTasks.clear();
        }
    }
}

