/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;

public class StatsUpdaterTask
implements LeaderElection.LeadershipStateListener {
    private final Configuration configuration;
    private Optional<MetaStoreThread> statsUpdater;
    private AtomicBoolean stop;

    public StatsUpdaterTask(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
    }

    private MetaStoreThread instantiateThread(String classname) throws Exception {
        Object o = JavaUtils.newInstance(Class.forName(classname));
        if (MetaStoreThread.class.isAssignableFrom(o.getClass())) {
            return (MetaStoreThread)o;
        }
        String s = classname + " is not an instance of MetaStoreThread.";
        HiveMetaStore.LOG.error(s);
        throw new IOException(s);
    }

    public Optional<MetaStoreThread> getStatsUpdaterThread() throws Exception {
        MetastoreConf.StatsUpdateMode mode = MetastoreConf.StatsUpdateMode.valueOf(MetastoreConf.getVar(this.configuration, MetastoreConf.ConfVars.STATS_AUTO_UPDATE).toUpperCase());
        if (mode == MetastoreConf.StatsUpdateMode.NONE) {
            return Optional.empty();
        }
        MetaStoreThread t = this.instantiateThread("org.apache.hadoop.hive.ql.stats.StatsUpdaterThread");
        return Optional.of(t);
    }

    @Override
    public void takeLeadership(LeaderElection election) throws Exception {
        if (this.statsUpdater != null) {
            throw new IllegalStateException("There should be no running stats updater before taking the leadership!");
        }
        this.statsUpdater = this.getStatsUpdaterThread();
        if (this.statsUpdater.isPresent()) {
            try {
                MetaStoreThread thread = this.statsUpdater.get();
                thread.setConf(this.configuration);
                this.stop = new AtomicBoolean(false);
                thread.init(this.stop);
                HiveMetaStore.LOG.info("Starting metastore thread of type " + thread.getClass().getName());
                thread.start();
            }
            catch (Exception e) {
                HiveMetaStore.LOG.error("Error while starting stats updater", (Throwable)e);
            }
        }
    }

    @Override
    public void lossLeadership(LeaderElection election) throws Exception {
        if (this.statsUpdater != null) {
            this.statsUpdater.ifPresent(statsUpdater -> {
                this.stop.set(true);
                ((Thread)((Object)statsUpdater)).interrupt();
                HiveMetaStore.LOG.info("Stopped the stats updater tasks.");
            });
            this.statsUpdater = null;
            this.stop = null;
        }
    }
}

