/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.MetricsInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidMetricService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidMetricService.class);
    private Configuration conf;
    private TxnStore txnHandler;
    private long lastSuccessfulLoggingTime = 0L;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_CHECK_INTERVAL, unit);
    }

    @Override
    public void run() {
        LOG.debug("Starting AcidMetricService thread");
        try {
            boolean metricsEnabled;
            long startedAt = System.currentTimeMillis();
            boolean bl = metricsEnabled = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METRICS_ENABLED) && MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_THREAD_ON);
            if (!metricsEnabled) {
                return;
            }
            try {
                this.collectMetrics();
            }
            catch (Exception ex) {
                LOG.error("Caught exception in AcidMetricService loop", (Throwable)ex);
            }
            long elapsedTime = System.currentTimeMillis() - startedAt;
            LOG.debug("AcidMetricService thread finished one loop in {} seconds.", (Object)(elapsedTime / 1000L));
        }
        catch (Throwable t) {
            LOG.error("Caught an exception in the main loop of AcidMetricService, exiting ", t);
        }
    }

    private void collectMetrics() throws MetaException {
        ShowCompactResponse currentCompactions = this.txnHandler.showCompact(new ShowCompactRequest());
        AcidMetricService.updateMetricsFromShowCompact(currentCompactions, this.conf);
        this.updateDBMetrics();
    }

    private void updateDBMetrics() throws MetaException {
        MetricsInfo metrics = this.txnHandler.getMetricsInfo();
        Metrics.getOrCreateGauge("compaction_num_txn_to_writeid").set(metrics.getTxnToWriteIdCount());
        this.logDbMetrics(metrics);
        Metrics.getOrCreateGauge("compaction_num_completed_txn_components").set(metrics.getCompletedTxnsCount());
        Metrics.getOrCreateGauge("num_open_repl_transactions").set(metrics.getOpenReplTxnsCount());
        Metrics.getOrCreateGauge("oldest_open_repl_txn_id").set(metrics.getOldestOpenReplTxnId());
        Metrics.getOrCreateGauge("oldest_open_repl_txn_age_in_sec").set(metrics.getOldestOpenReplTxnAge());
        Metrics.getOrCreateGauge("num_open_non_repl_transactions").set(metrics.getOpenNonReplTxnsCount());
        Metrics.getOrCreateGauge("oldest_open_non_repl_txn_id").set(metrics.getOldestOpenNonReplTxnId());
        Metrics.getOrCreateGauge("oldest_open_non_repl_txn_age_in_sec").set(metrics.getOldestOpenNonReplTxnAge());
        Metrics.getOrCreateGauge("num_aborted_transactions").set(metrics.getAbortedTxnsCount());
        Metrics.getOrCreateGauge("oldest_aborted_txn_id").set(metrics.getOldestAbortedTxnId());
        Metrics.getOrCreateGauge("oldest_aborted_txn_age_in_sec").set(metrics.getOldestAbortedTxnAge());
        Metrics.getOrCreateGauge("num_locks").set(metrics.getLocksCount());
        Metrics.getOrCreateGauge("oldest_lock_age_in_sec").set(metrics.getOldestLockAge());
        Metrics.getOrCreateGauge("tables_with_x_aborted_transactions").set(metrics.getTablesWithXAbortedTxnsCount());
        Metrics.getOrCreateGauge("oldest_ready_for_cleaning_age_in_sec").set(metrics.getOldestReadyForCleaningAge());
    }

    private void logDbMetrics(MetricsInfo metrics) {
        long loggingFrequency = MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_ACID_METRICS_LOGGER_FREQUENCY, TimeUnit.MILLISECONDS);
        if (loggingFrequency <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastSuccessfulLoggingTime == 0L || currentTime >= this.lastSuccessfulLoggingTime + loggingFrequency) {
            this.lastSuccessfulLoggingTime = currentTime;
            if (metrics.getTxnToWriteIdCount() >= MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_WARNING) && metrics.getTxnToWriteIdCount() < MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_ERROR)) {
                LOG.warn("An excessive amount of (" + metrics.getTxnToWriteIdCount() + ") Hive ACID metadata found in TXN_TO_WRITEID table, which can cause serious performance degradation.");
            } else if (metrics.getTxnToWriteIdCount() >= MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_TXN_TO_WRITEID_RECORD_THRESHOLD_ERROR)) {
                LOG.error("An excessive amount of (" + metrics.getTxnToWriteIdCount() + ") Hive ACID metadata found in TXN_TO_WRITEID table, which can cause serious performance degradation.");
            }
            if (metrics.getCompletedTxnsCount() >= MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_WARNING) && metrics.getCompletedTxnsCount() < MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_ERROR)) {
                LOG.warn("An excessive amount of (" + metrics.getCompletedTxnsCount() + ") Hive ACID metadata found in COMPLETED_TXN_COMPONENTS table, which can cause serious performance degradation.");
            } else if (metrics.getCompletedTxnsCount() >= MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_COMPLETED_TXN_COMPONENTS_RECORD_THRESHOLD_ERROR)) {
                LOG.error("An excessive amount of (" + metrics.getCompletedTxnsCount() + ") Hive ACID metadata found in COMPLETED_TXN_COMPONENTS table, which can cause serious performance degradation.");
            }
            if ((long)metrics.getOldestOpenReplTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_WARNING, TimeUnit.SECONDS) && (long)metrics.getOldestOpenReplTxnAge() < MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.warn("A replication transaction with ID " + metrics.getOldestOpenReplTxnId() + " has been open for " + metrics.getOldestOpenReplTxnAge() + " seconds. Before you abort a transaction that was created by replication, and which has been open a long time, make sure that the hive.repl.txn.timeout threshold has expired.");
            } else if ((long)metrics.getOldestOpenReplTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_REPLICATION_OPENTXN_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.error("A replication transaction with ID " + metrics.getOldestOpenReplTxnId() + " has been open for " + metrics.getOldestOpenReplTxnAge() + " seconds. Before you abort a transaction that was created by replication, and which has been open a long time, make sure that the hive.repl.txn.timeout threshold has expired.");
            }
            if ((long)metrics.getOldestOpenNonReplTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_WARNING, TimeUnit.SECONDS) && (long)metrics.getOldestOpenNonReplTxnAge() < MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.warn("A non-replication transaction with ID " + metrics.getOldestOpenNonReplTxnId() + " has been open for " + metrics.getOldestOpenNonReplTxnAge() + " seconds.");
            } else if ((long)metrics.getOldestOpenNonReplTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_OPENTXN_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.error("A non-replication transaction with ID " + metrics.getOldestOpenNonReplTxnId() + " has been open for " + metrics.getOldestOpenNonReplTxnAge() + " seconds.");
            }
            if ((long)metrics.getOldestAbortedTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_WARNING, TimeUnit.SECONDS) && (long)metrics.getOldestAbortedTxnAge() < MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.warn("Found an aborted transaction with an ID " + metrics.getOldestAbortedTxnId() + " and age of " + metrics.getOldestAbortedTxnAge() + " seconds.");
            } else if ((long)metrics.getOldestAbortedTxnAge() >= MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_ABORTEDTXN_TIME_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.warn("Found an aborted transaction with an ID " + metrics.getOldestAbortedTxnId() + " and age of " + metrics.getOldestAbortedTxnAge() + " seconds.");
            }
            if (metrics.getTablesWithXAbortedTxnsCount() > MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_TABLES_WITH_ABORTEDTXN_THRESHOLD)) {
                LOG.error("Found " + metrics.getTablesWithXAbortedTxnsCount() + " tables/partitions with more than " + MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD) + " aborts. Name of the tables/partitions are: " + metrics.getTablesWithXAbortedTxns());
            }
            if ((long)metrics.getOldestReadyForCleaningAge() > MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_UNCLEANED_COMPACTION_TIME_THRESHOLD, TimeUnit.SECONDS)) {
                LOG.warn("Found entry in compaction queue in ready for cleaning state with age of " + metrics.getOldestReadyForCleaningAge() + " seconds.");
            }
        }
    }

    @VisibleForTesting
    public static void updateMetricsFromShowCompact(ShowCompactResponse showCompactResponse, Configuration conf) {
        String key;
        HashMap<String, ShowCompactResponseElement> lastElements = new HashMap<String, ShowCompactResponseElement>();
        long oldestEnqueueTime = Long.MAX_VALUE;
        for (ShowCompactResponseElement element : showCompactResponse.getCompacts()) {
            key = element.getDbname() + "/" + element.getTablename() + (element.getPartitionname() != null ? "/" + element.getPartitionname() : "");
            lastElements.compute(key, (k, old) -> old == null ? element : (element.getId() > old.getId() ? element : old));
            if (!"initiated".equals(element.getState()) || oldestEnqueueTime <= element.getEnqueueTime()) continue;
            oldestEnqueueTime = element.getEnqueueTime();
        }
        Map<String, Long> counts = lastElements.values().stream().collect(Collectors.groupingBy(ShowCompactResponseElement::getState, Collectors.counting()));
        for (int i = 0; i < TxnStore.COMPACTION_STATES.length; ++i) {
            key = "compaction_num_" + AcidMetricService.replaceWhitespace(TxnStore.COMPACTION_STATES[i]);
            Long count = counts.get(TxnStore.COMPACTION_STATES[i]);
            if (count != null) {
                Metrics.getOrCreateGauge(key).set(count.intValue());
                continue;
            }
            Metrics.getOrCreateGauge(key).set(0);
        }
        Long numFailedComp = counts.get("failed");
        Long numNotInitiatedComp = counts.get("did not initiate");
        Long numSucceededComp = counts.get("succeeded");
        if (numFailedComp != null && numNotInitiatedComp != null && numSucceededComp != null && (double)((numFailedComp + numNotInitiatedComp) / (numFailedComp + numNotInitiatedComp + numSucceededComp)) > MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.COMPACTOR_FAILED_COMPACTION_RATIO_THRESHOLD)) {
            LOG.warn("Many compactions are failing. Check root cause of failed/not initiated compactions.");
        }
        if (oldestEnqueueTime == Long.MAX_VALUE) {
            Metrics.getOrCreateGauge("compaction_oldest_enqueue_age_in_sec").set(0);
        } else {
            int oldestEnqueueAge = (int)((System.currentTimeMillis() - oldestEnqueueTime) / 1000L);
            Metrics.getOrCreateGauge("compaction_oldest_enqueue_age_in_sec").set(oldestEnqueueAge);
            if ((long)oldestEnqueueAge >= MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_INITIATED_COMPACTION_TIME_THRESHOLD_WARNING, TimeUnit.SECONDS) && (long)oldestEnqueueAge < MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_INITIATED_COMPACTION_TIME_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.warn("Found compaction entry in compaction queue with an age of " + oldestEnqueueAge + " seconds. Consider increasing the number of worker threads.");
            } else if ((long)oldestEnqueueAge >= MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.COMPACTOR_OLDEST_INITIATED_COMPACTION_TIME_THRESHOLD_ERROR, TimeUnit.SECONDS)) {
                LOG.error("Found compaction entry in compaction queue with an age of " + oldestEnqueueAge + " seconds. Consider increasing the number of worker threads");
            }
        }
        long initiatorsCount = lastElements.values().stream().filter(e -> !"manual".equals(MetaStoreUtils.getThreadIdFromId(e.getInitiatorId()))).map(e -> MetaStoreUtils.getHostFromId(e.getInitiatorId())).distinct().filter(e -> !" --- ".equals(e)).count();
        Metrics.getOrCreateGauge("compaction_num_initiators").set((int)initiatorsCount);
        long workersCount = lastElements.values().stream().map(e -> MetaStoreUtils.getHostFromId(e.getWorkerid())).distinct().filter(e -> !" --- ".equals(e)).count();
        Metrics.getOrCreateGauge("compaction_num_workers").set((int)workersCount);
        long initiatorVersionsCount = lastElements.values().stream().map(ShowCompactResponseElement::getInitiatorVersion).distinct().filter(Objects::nonNull).count();
        Metrics.getOrCreateGauge("compaction_num_initiator_versions").set((int)initiatorVersionsCount);
        long workerVersionsCount = lastElements.values().stream().map(ShowCompactResponseElement::getWorkerVersion).distinct().filter(Objects::nonNull).count();
        Metrics.getOrCreateGauge("compaction_num_worker_versions").set((int)workerVersionsCount);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    public static String replaceWhitespace(String input) {
        if (input == null) {
            return input;
        }
        return input.replaceAll("\\s+", "_");
    }
}

