/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.apache.hadoop.hive.metastore.tools.metatool.MetadataTableSummary;

public class MetaToolTaskMetadataSummary
extends MetaToolTask {
    @Override
    void execute() {
        try {
            String formatOption;
            String[] inputParams = this.getCl().getMetadataSummaryParams();
            ObjectStore objectStore = this.getObjectStore();
            List<MetadataTableSummary> tableSummariesList = objectStore.getMetadataSummary(null, null, null);
            if (tableSummariesList == null || tableSummariesList.size() == 0) {
                System.out.println("Return set of tables is empty or null");
                return;
            }
            String filename = null;
            if (inputParams.length == 2) {
                filename = inputParams[1].toLowerCase().trim();
            }
            switch (formatOption = inputParams[0].toLowerCase().trim()) {
                case "-json": {
                    this.exportInJson(tableSummariesList, filename);
                    break;
                }
                case "-console": {
                    this.printToConsole(tableSummariesList);
                    break;
                }
                case "-csv": {
                    this.exportInCsv(tableSummariesList, filename);
                    break;
                }
                default: {
                    System.out.println("Invalid option to -metadataSummary");
                    return;
                }
            }
        }
        catch (SQLException e) {
            System.out.println("Generating HMS Summary failed: \n" + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void exportInJson(List<MetadataTableSummary> tableSummaryList, String filename) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonOutput = gson.toJson(tableSummaryList);
        this.writeJsonInFile(jsonOutput, filename);
    }

    public void printToConsole(List<MetadataTableSummary> tableSummariesList) {
        System.out.println("----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----   LEGEND -----    ----    ----    ----    ---    -----     ----    ----    ----    -----");
        System.out.print("\u001b[0;1m#COLS\u001b[0m ");
        System.out.print("--> # of columns in the table ");
        System.out.print("\u001b[0;1m#PARTS\u001b[0m ");
        System.out.print("--> # of Partitions ");
        System.out.print("\u001b[0;1m#ROWS\u001b[0m ");
        System.out.print("--> # of rows in table ");
        System.out.print("\u001b[0;1m#FILES\u001b[0m ");
        System.out.print("--> No of files in table ");
        System.out.print("\u001b[0;1mSIZE\u001b[0m ");
        System.out.print("--> Size of table in bytes ");
        System.out.print("\u001b[0;1m#PCOLS\u001b[0m ");
        System.out.print("--> # of partition columns ");
        System.out.print("\u001b[0;1m#ARR\u001b[0m ");
        System.out.print("--> # of array columns ");
        System.out.print("\u001b[0;1m#STRT\u001b[0m ");
        System.out.print("--> # of struct columns ");
        System.out.print("\u001b[0;1m#MAP\u001b[0m ");
        System.out.print("--> # of map columns ");
        System.out.println("");
        System.out.println("-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        System.out.println("                                                                                                    Metadata Summary                                                                                                        ");
        System.out.println("-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        System.out.print("\u001b[0;1m");
        System.out.printf("%10s %20s %30s %5s %5s %15s %15s %10s %10s %10s %10s %10s %5s %5s %5s", "CATALOG", "DATABASE", "TABLE NAME", "#COLS", "#PARTS", "TYPE", "FORMAT", "COMPRESSION", "#ROWS", "#FILES", "SIZE(b)", "#PCOLS", "#ARR", "#STRT", "#MAP");
        System.out.print("\u001b[0m");
        System.out.println();
        System.out.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        for (MetadataTableSummary summary : tableSummariesList) {
            System.out.format("%10s %20s %30s %5d %5d %15s %15s %10s %10s %10s %10s %10s %5d %5d %5d", summary.getCtlgName(), summary.getDbName(), summary.getTblName(), summary.getColCount(), summary.getPartitionCount(), summary.getTableType(), summary.getFileFormat(), summary.getCompressionType(), summary.getSizeNumRows(), summary.getSizeNumFiles(), summary.getTotalSize(), summary.getPartitionColumnCount(), summary.getArrayColumnCount(), summary.getStructColumnCount(), summary.getMapColumnCount());
            System.out.println();
        }
        System.out.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
    }

    public void exportInCsv(List<MetadataTableSummary> metadataTableSummaryList, String filename) throws IOException {
        if (filename == null || filename.trim().isEmpty()) {
            filename = "./MetastoreSummary.csv";
        }
        PrintWriter pw = null;
        File csvOutputFile = null;
        try {
            csvOutputFile = new File(filename);
            pw = new PrintWriter(csvOutputFile);
            pw.println("Catalog Name, Database Name, Table Name, Column Count, Partition Count, Table Type, File Format, Compression Type, Number of Rows, Number of Files, Size in Bytes, Partition Column Count, Array Column Count, Struct Column Count, Map Column Count");
            metadataTableSummaryList.stream().map(MetadataTableSummary::toCSV).forEach(pw::println);
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            throw e;
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    private void writeJsonInFile(String jsonOutput, String filename) throws IOException {
        File jsonOutputFile;
        if (filename == null || filename.trim().isEmpty()) {
            filename = "./MetastoreSummary.json";
        }
        try {
            jsonOutputFile = new File(filename);
            if (jsonOutputFile.exists()) {
                File oldFile = new File(jsonOutputFile.getAbsolutePath() + "_old");
                System.out.println("Output file already exists, renaming to " + oldFile);
                jsonOutputFile.renameTo(oldFile);
            }
            if (jsonOutputFile.createNewFile()) {
                System.out.println("File created: " + jsonOutputFile.getName());
            } else {
                System.out.println("File already exists.");
            }
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            throw e;
        }
        try {
            PrintWriter pw = new PrintWriter(jsonOutputFile);
            pw.println(jsonOutput);
            pw.flush();
            System.out.println("Summary written to " + jsonOutputFile);
        }
        catch (IOException ex) {
            System.out.println("Failed to write output file:" + ex.getMessage());
            throw ex;
        }
    }
}

