/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.TxnState;

public enum TxnStatus {
    OPEN('o', TxnState.OPEN),
    ABORTED('a', TxnState.ABORTED),
    COMMITTED('c', TxnState.COMMITTED),
    UNKNOWN('u', null);

    private final char sqlConst;
    private final TxnState txnState;
    private static final Map<String, TxnStatus> LOOKUP;

    private TxnStatus(char sqlConst, TxnState txnState) {
        this.sqlConst = sqlConst;
        this.txnState = txnState;
    }

    public String toString() {
        return "'" + this.getSqlConst() + "'";
    }

    public String getSqlConst() {
        return Character.toString(this.sqlConst);
    }

    public TxnState toTxnState() {
        return Optional.of(this.txnState).orElseThrow(IllegalArgumentException::new);
    }

    public static TxnStatus fromString(String sqlConst) {
        return Optional.of(LOOKUP.get(sqlConst)).orElseThrow(IllegalArgumentException::new);
    }

    static {
        LOOKUP = Arrays.stream(TxnStatus.values()).collect(Collectors.toMap(TxnStatus::getSqlConst, Function.identity()));
    }
}

