/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.LockType;

public class LockTypeUtil {
    private static final char UNKNOWN_LOCK_TYPE_ENCODING = 'z';
    private static final BiMap<LockType, Character> PERSISTENCE_ENCODINGS = EnumHashBiMap.create(LockType.class);

    public static char getEncoding(LockType lockType) {
        return PERSISTENCE_ENCODINGS.getOrDefault(lockType, Character.valueOf('z')).charValue();
    }

    public static String getEncodingAsStr(LockType lockType) {
        return Character.toString(LockTypeUtil.getEncoding(lockType));
    }

    private static String getEncodingAsQuotedStr(LockType lockType) {
        return "'" + LockTypeUtil.getEncodingAsStr(lockType) + "'";
    }

    public static Optional<LockType> getLockTypeFromEncoding(char encoding) {
        return Optional.ofNullable(PERSISTENCE_ENCODINGS.inverse().get(Character.valueOf(encoding)));
    }

    public static String exclusive() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.EXCLUSIVE);
    }

    public static String exclWrite() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.EXCL_WRITE);
    }

    public static String sharedWrite() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.SHARED_WRITE);
    }

    public static String sharedRead() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.SHARED_READ);
    }

    static {
        PERSISTENCE_ENCODINGS.put(LockType.SHARED_READ, Character.valueOf('r'));
        PERSISTENCE_ENCODINGS.put(LockType.SHARED_WRITE, Character.valueOf('w'));
        PERSISTENCE_ENCODINGS.put(LockType.EXCL_WRITE, Character.valueOf('x'));
        PERSISTENCE_ENCODINGS.put(LockType.EXCLUSIVE, Character.valueOf('e'));
    }
}

