/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Compiler;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.Executor;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.HookRunner;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.ValidTxnManager;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lock.CompileLock;
import org.apache.hadoop.hive.ql.lock.CompileLockFactory;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements IDriver {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private static final String SNAPSHOT_WAS_OUTDATED_WHEN_LOCKS_WERE_ACQUIRED = "snapshot was outdated when locks were acquired";
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private Runnable shutdownRunner = null;
    private int maxRows = 100;
    private ByteStream.Output bos = new ByteStream.Output();
    private final DriverContext driverContext;
    private final DriverState driverState = new DriverState();
    private final List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private final ValidTxnManager validTxnManager;
    private Context context;
    private TaskQueue taskQueue;

    @Override
    public Schema getSchema() {
        return this.driverContext.getSchema();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public PlanMapper getPlanMapper() {
        return this.context.getPlanMapper();
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @VisibleForTesting
    public Driver(HiveConf conf) {
        this(new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build(), null);
    }

    public Driver(HiveConf conf, Context ctx, LineageState lineageState) {
        this(QueryState.getNewQueryState(conf, lineageState), null, null);
        this.context = ctx;
    }

    public Driver(HiveConf conf, String userName, LineageState lineageState) {
        this(QueryState.getNewQueryState(conf, lineageState), userName, null);
    }

    public Driver(QueryState queryState, String userName) {
        this(queryState, userName, null, null);
    }

    public Driver(QueryState queryState, String userName, QueryInfo queryInfo) {
        this(queryState, userName, queryInfo, null);
    }

    public Driver(QueryState queryState, String userName, QueryInfo queryInfo, HiveTxnManager txnManager, ValidWriteIdList compactionWriteIds, long compactorTxnId) {
        this(queryState, userName, queryInfo, txnManager);
        this.driverContext.setCompactionWriteIds(compactionWriteIds);
        this.driverContext.setCompactorTxnId(compactorTxnId);
    }

    public Driver(QueryState queryState, String userName, QueryInfo queryInfo, HiveTxnManager txnManager) {
        this.driverContext = new DriverContext(queryState, queryInfo, userName, new HookRunner(queryState.getConf(), CONSOLE), txnManager);
        this.validTxnManager = new ValidTxnManager(this, this.driverContext);
    }

    public int compile(String command, boolean resetTaskIds) {
        try {
            this.compile(command, resetTaskIds, false);
            return 0;
        }
        catch (CommandProcessorException cpr) {
            return cpr.getErrorCode();
        }
    }

    @VisibleForTesting
    public void compile(String command, boolean resetTaskIds, boolean deferClose) throws CommandProcessorException {
        this.preparForCompile(resetTaskIds);
        Compiler compiler = new Compiler(this.context, this.driverContext, this.driverState);
        QueryPlan plan = compiler.compile(command, deferClose);
        this.driverContext.setPlan(plan);
        this.compileFinished(deferClose);
    }

    private void compileFinished(boolean deferClose) {
        if (DriverState.getDriverState().isAborted() && !deferClose) {
            this.closeInProcess(true);
        }
    }

    private void preparForCompile(boolean resetTaskIds) throws CommandProcessorException {
        this.createTransactionManager();
        DriverState.setDriverState(this.driverState);
        this.prepareContext();
        this.setQueryId();
        if (resetTaskIds) {
            TaskFactory.resetId();
        }
    }

    private void createTransactionManager() throws CommandProcessorException {
        try {
            HiveTxnManager queryTxnManager;
            HiveTxnManager hiveTxnManager = queryTxnManager = this.driverContext.getInitTxnManager() != null ? this.driverContext.getInitTxnManager() : SessionState.get().initTxnMgr(this.driverContext.getConf());
            if (queryTxnManager instanceof Configurable) {
                ((Configurable)queryTxnManager).setConf((Configuration)this.driverContext.getConf());
            }
            this.driverContext.setTxnManager(queryTxnManager);
            this.driverContext.getQueryState().setTxnManager(queryTxnManager);
            ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
            this.shutdownRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        Driver.this.releaseLocksAndCommitOrRollback(false, Driver.this.driverContext.getTxnManager());
                    }
                    catch (LockException e) {
                        LOG.warn("Exception when releasing locks in ShutdownHook for Driver: " + e.getMessage());
                    }
                }
            };
            ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
        }
        catch (LockException e) {
            ErrorMsg error = ErrorMsg.getErrorMsg(e.getMessage());
            String errorMessage = "FAILED: " + e.getClass().getSimpleName() + " [Error " + error.getErrorCode() + "]:";
            CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            throw DriverUtils.createProcessorException(this.driverContext, error.getErrorCode(), errorMessage, error.getSQLState(), e);
        }
    }

    private void prepareContext() throws CommandProcessorException {
        if (this.context != null && this.context.getExplainAnalyze() != ExplainConfiguration.AnalyzeState.RUNNING) {
            if (!this.driverContext.isRetrial()) {
                this.closeInProcess(false);
            } else {
                this.context = new Context(this.context);
                this.releaseResources();
            }
        }
        try {
            if (this.context == null) {
                this.context = new Context(this.driverContext.getConf());
            }
        }
        catch (IOException e) {
            throw new CommandProcessorException(e);
        }
        this.context.setHiveTxnManager(this.driverContext.getTxnManager());
        this.context.setStatsSource(this.driverContext.getStatsSource());
        this.context.setHDFSCleanup(true);
    }

    private void setQueryId() {
        String queryId = Strings.isNullOrEmpty(this.driverContext.getQueryState().getQueryId()) ? QueryPlan.makeQueryId() : this.driverContext.getQueryState().getQueryId();
        this.driverContext.getQueryDisplay().setQueryId(queryId);
        this.setTriggerContext(queryId);
    }

    private void setTriggerContext(String queryId) {
        long queryStartTime = this.driverContext.getQueryInfo() != null ? this.driverContext.getQueryInfo().getBeginTime() : this.driverContext.getQueryDisplay().getQueryStartTime();
        WmContext wmContext = new WmContext(queryStartTime, queryId);
        this.context.setWmContext(wmContext);
    }

    @Override
    public HiveConf getConf() {
        return this.driverContext.getConf();
    }

    @Override
    public QueryPlan getPlan() {
        return this.driverContext.getPlan();
    }

    @Override
    public FetchTask getFetchTask() {
        return this.driverContext.getFetchTask();
    }

    private void setWriteIdForAcidFileSinks() throws SemanticException, LockException {
        if (!this.driverContext.getPlan().getAcidSinks().isEmpty()) {
            ArrayList<FileSinkDesc> acidSinks = new ArrayList<FileSinkDesc>(this.driverContext.getPlan().getAcidSinks());
            acidSinks.sort(Comparator.comparing(FileSinkDesc::getDirName));
            int maxStmtId = -1;
            boolean isDirectInsertOn = false;
            for (FileSinkDesc acidSink : acidSinks) {
                if (!acidSink.isDirectInsert()) continue;
                isDirectInsertOn = true;
                break;
            }
            if (isDirectInsertOn) {
                acidSinks.sort((fsd1, fsd2) -> fsd1.getMoveTaskId().compareTo(fsd2.getMoveTaskId()));
            }
            for (FileSinkDesc desc : acidSinks) {
                TableDesc tableInfo = desc.getTableInfo();
                TableName tn = HiveTableName.ofNullable(tableInfo.getTableName());
                long writeId = this.driverContext.getTxnManager().getTableWriteId(tn.getDb(), tn.getTable());
                desc.setTableWriteId(writeId);
                desc.setStatementId(this.driverContext.getTxnManager().getStmtIdAndIncrement());
                maxStmtId = Math.max(desc.getStatementId(), maxStmtId);
                String unionAllSubdir = "/HIVE_UNION_SUBDIR_";
                if (!desc.getInsertOverwrite() || !desc.getDirName().toString().contains(unionAllSubdir) || !desc.isFullAcidTable()) continue;
                throw new UnsupportedOperationException("QueryId=" + this.driverContext.getPlan().getQueryId() + " is not supported due to OVERWRITE and UNION ALL.  Please use truncate + insert");
            }
            if (HiveConf.getBoolVar(this.driverContext.getConf(), HiveConf.ConfVars.HIVE_EXTEND_BUCKET_ID_RANGE)) {
                for (FileSinkDesc each : acidSinks) {
                    each.setMaxStmtId(maxStmtId);
                }
            }
        }
    }

    private void acquireLocks() throws CommandProcessorException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        if (!this.driverContext.getTxnManager().isTxnOpen() && this.driverContext.getTxnManager().supportsAcid()) {
            return;
        }
        try {
            DDLDesc.DDLDescWithWriteId acidDdlDesc;
            boolean hasAcidDdl;
            String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
            this.setWriteIdForAcidFileSinks();
            if (this.driverContext.getPlan().getAcidAnalyzeTable() != null) {
                Table t = this.driverContext.getPlan().getAcidAnalyzeTable().getTable();
                this.driverContext.getTxnManager().getTableWriteId(t.getDbName(), t.getTableName());
            }
            boolean bl = hasAcidDdl = (acidDdlDesc = this.driverContext.getPlan().getAcidDdlDesc()) != null && acidDdlDesc.mayNeedWriteId();
            if (hasAcidDdl) {
                String fqTableName = acidDdlDesc.getFullTableName();
                TableName tn = HiveTableName.ofNullableWithNoDefault(fqTableName);
                long writeId = this.driverContext.getTxnManager().getTableWriteId(tn.getDb(), tn.getTable());
                acidDdlDesc.setWriteId(writeId);
            }
            this.driverContext.getTxnManager().acquireLocks(this.driverContext.getPlan(), this.context, userFromUGI, this.driverState);
            if (this.driverContext.getTxnManager().recordSnapshot(this.driverContext.getPlan()) && !this.driverContext.isValidTxnListsGenerated()) {
                throw new IllegalStateException("Need to record valid WriteID list but there is no valid TxnID list (" + JavaUtils.txnIdToString(this.driverContext.getTxnManager().getCurrentTxnId()) + ", queryId:" + this.driverContext.getPlan().getQueryId() + ")");
            }
            if (this.driverContext.getPlan().hasAcidResourcesInQuery() || hasAcidDdl) {
                this.validTxnManager.recordValidWriteIds();
            }
        }
        catch (Exception e) {
            String errorMessage;
            if (this.driverState.isDestroyed() || this.driverState.isAborted() || this.driverState.isClosed()) {
                errorMessage = String.format("Ignore lock acquisition related exception in terminal state (%s): %s", this.driverState.toString(), e.getMessage());
                CONSOLE.printInfo(errorMessage);
            } else {
                errorMessage = String.format("FAILED: Error in acquiring locks: %s", e.getMessage());
                CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            }
            throw DriverUtils.createProcessorException(this.driverContext, 10, errorMessage, ErrorMsg.findSQLState(e.getMessage()), e);
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    public void releaseLocksAndCommitOrRollback(boolean commit) throws LockException {
        this.releaseLocksAndCommitOrRollback(commit, this.driverContext.getTxnManager());
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
        this.shutdownRunner = null;
    }

    @VisibleForTesting
    public void releaseLocksAndCommitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        HiveTxnManager txnMgr = txnManager == null ? this.driverContext.getTxnManager() : txnManager;
        this.driverContext.getConf().unset("hive.txn.valid.txns");
        this.driverContext.getConf().unset("hive.txn.tables.valid.writeids");
        if (!DriverUtils.checkConcurrency(this.driverContext)) {
            return;
        }
        if (txnMgr.isTxnOpen()) {
            if (commit) {
                if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                    txnMgr.rollbackTxn();
                } else {
                    txnMgr.commitTxn();
                }
            } else {
                txnMgr.rollbackTxn();
            }
        } else {
            if (this.context != null && this.context.getHiveLocks() != null) {
                this.hiveLocks.addAll(this.context.getHiveLocks());
            }
            txnMgr.releaseLocks(this.hiveLocks);
        }
        this.hiveLocks.clear();
        if (this.context != null) {
            this.context.setHiveLocks(null);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    public void releaseResources() {
        this.releasePlan();
        this.releaseTaskQueue();
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        return this.run(command, false);
    }

    @Override
    public CommandProcessorResponse run() throws CommandProcessorException {
        return this.run(null, true);
    }

    public CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandProcessorException {
        try {
            this.runInternal(command, alreadyCompiled);
            return new CommandProcessorResponse(this.getSchema(), null);
        }
        catch (CommandProcessorException cpe) {
            SessionState ss = SessionState.get();
            if (ss == null) {
                throw cpe;
            }
            MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
            if (!(mdf instanceof JsonMetaDataFormatter)) {
                throw cpe;
            }
            try {
                if (cpe.getException() == null) {
                    mdf.error(ss.out, cpe.getErrorMessage(), cpe.getResponseCode(), cpe.getSqlState());
                    throw cpe;
                }
                ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpe.getResponseCode());
                if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                    mdf.error(ss.out, cpe.getErrorMessage(), cpe.getResponseCode(), cpe.getSqlState(), null);
                    throw cpe;
                }
                if (cpe.getException() instanceof HiveException) {
                    HiveException rc = (HiveException)cpe.getException();
                    mdf.error(ss.out, cpe.getErrorMessage(), rc.getCanonicalErrorMsg().getErrorCode(), cpe.getSqlState(), rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? StringUtils.stringifyException((Throwable)rc) : null);
                } else {
                    ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(cpe.getException().getMessage());
                    mdf.error(ss.out, cpe.getErrorMessage(), canonicalMsg.getErrorCode(), cpe.getSqlState(), StringUtils.stringifyException((Throwable)cpe.getException()));
                }
            }
            catch (HiveException ex) {
                CONSOLE.printError("Unable to JSON-encode the error", StringUtils.stringifyException((Throwable)ex));
            }
            throw cpe;
        }
    }

    @Override
    public CommandProcessorResponse compileAndRespond(String command) throws CommandProcessorException {
        return this.compileAndRespond(command, false);
    }

    public CommandProcessorResponse compileAndRespond(String command, boolean cleanupTxnList) throws CommandProcessorException {
        try {
            this.compileInternal(command, false);
            CommandProcessorResponse commandProcessorResponse = new CommandProcessorResponse(this.getSchema(), null);
            return commandProcessorResponse;
        }
        catch (CommandProcessorException cpe) {
            throw cpe;
        }
        finally {
            if (cleanupTxnList) {
                this.driverContext.getConf().unset("hive.txn.valid.txns");
            }
        }
    }

    public void lockAndRespond() throws CommandProcessorException {
        if (this.driverContext.getPlan() == null) {
            throw new IllegalStateException("No previously compiled query for driver - queryId=" + this.driverContext.getQueryState().getQueryId());
        }
        if (this.requiresLock()) {
            try {
                this.acquireLocks();
            }
            catch (CommandProcessorException cpe) {
                this.rollback(cpe);
                throw cpe;
            }
        }
    }

    private void compileInternal(String command, boolean deferClose) throws CommandProcessorException {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            metrics.incrementCounter("waiting_compile_ops", 1L);
        }
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "waitCompile");
        try (CompileLock compileLock = CompileLockFactory.newInstance(this.driverContext.getConf(), command);){
            boolean success = compileLock.tryAcquire();
            perfLogger.PerfLogEnd(CLASS_NAME, "waitCompile");
            if (metrics != null) {
                metrics.decrementCounter("waiting_compile_ops", 1L);
            }
            if (!success) {
                String errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                throw DriverUtils.createProcessorException(this.driverContext, ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode(), errorMessage, null, null);
            }
            try {
                this.compile(command, true, deferClose);
            }
            catch (CommandProcessorException cpe) {
                try {
                    this.releaseLocksAndCommitOrRollback(false);
                }
                catch (LockException e) {
                    LOG.warn("Exception in releasing locks. " + StringUtils.stringifyException((Throwable)e));
                }
                throw cpe;
            }
        }
        this.driverContext.getQueryDisplay().setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.driverContext.getQueryDisplay().setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInternal(String command, boolean alreadyCompiled) throws CommandProcessorException {
        DriverState.setDriverState(this.driverState);
        this.driverState.lock();
        try {
            if (alreadyCompiled) {
                if (!this.driverState.isCompiled()) {
                    String errorMessage = "FAILED: Precompiled query has been cancelled or closed.";
                    CONSOLE.printError(errorMessage);
                    throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, null, null);
                }
                this.driverState.executing();
            } else {
                this.driverState.compiling();
            }
        }
        finally {
            this.driverState.unlock();
        }
        boolean isFinishedWithError = true;
        try {
            PerfLogger perfLogger;
            HiveDriverRunHookContextImpl hookContext;
            block38: {
                hookContext = new HiveDriverRunHookContextImpl(this.driverContext.getConf(), alreadyCompiled ? this.context.getCmd() : command);
                try {
                    this.driverContext.getHookRunner().runPreDriverHooks(hookContext);
                }
                catch (Exception e) {
                    String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                    CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                    throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, ErrorMsg.findSQLState(e.getMessage()), e);
                }
                perfLogger = null;
                if (!alreadyCompiled) {
                    this.compileInternal(command, true);
                    perfLogger = SessionState.getPerfLogger();
                } else {
                    perfLogger = SessionState.getPerfLogger();
                    this.driverContext.getPlan().setQueryStartTime(perfLogger.getStartTime("Driver.run"));
                }
                this.context.setHiveTxnManager(this.driverContext.getTxnManager());
                DriverUtils.checkInterrupted(this.driverState, this.driverContext, "at acquiring the lock.", null, null);
                this.lockAndRespond();
                int retryShapshotCnt = 0;
                int maxRetrySnapshotCnt = HiveConf.getIntVar(this.driverContext.getConf(), HiveConf.ConfVars.HIVE_TXN_MAX_RETRYSNAPSHOT_COUNT);
                try {
                    do {
                        this.driverContext.setOutdatedTxn(false);
                        if (this.validTxnManager.isValidTxnListState()) continue;
                        LOG.info("Re-compiling after acquiring locks, attempt #" + retryShapshotCnt);
                        if (this.driverContext.isOutdatedTxn()) {
                            LOG.info("Snapshot is outdated, re-initiating transaction ...");
                            this.driverContext.getTxnManager().rollbackTxn();
                            String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
                            this.driverContext.getTxnManager().openTxn(this.context, userFromUGI, this.driverContext.getTxnType());
                            this.lockAndRespond();
                        } else {
                            this.driverContext.getTxnManager().clearCaches();
                        }
                        this.driverContext.setRetrial(true);
                        this.driverContext.getConf().set("hive.txn.valid.txns", this.driverContext.getTxnManager().getValidTxns().toString());
                        if (this.driverContext.getPlan().hasAcidResourcesInQuery()) {
                            this.compileInternal(this.context.getCmd(), true);
                            this.validTxnManager.recordValidWriteIds();
                            this.setWriteIdForAcidFileSinks();
                        }
                        this.driverContext.getPlan().setQueryStartTime(this.driverContext.getQueryDisplay().getQueryStartTime());
                    } while (this.driverContext.isOutdatedTxn() && ++retryShapshotCnt <= maxRetrySnapshotCnt);
                    if (retryShapshotCnt > maxRetrySnapshotCnt) {
                        HiveException e = new HiveException("Operation could not be executed, snapshot was outdated when locks were acquired.");
                        throw this.handleHiveException(e, 14);
                    }
                    if (retryShapshotCnt != 0) {
                        perfLogger = SessionState.getPerfLogger(true);
                        this.context.setHiveTxnManager(this.driverContext.getTxnManager());
                    }
                }
                catch (LockException | SemanticException e) {
                    throw this.handleHiveException(e, 13);
                }
                try {
                    this.taskQueue = new TaskQueue(this.context);
                    Executor executor = new Executor(this.context, this.driverContext, this.driverState, this.taskQueue);
                    executor.execute();
                }
                catch (CommandProcessorException cpe) {
                    this.rollback(cpe);
                    throw cpe;
                }
                try {
                    if (this.driverContext.getTxnManager().isImplicitTransactionOpen(this.context) || this.driverContext.getPlan().getOperation() == HiveOperation.COMMIT) {
                        this.releaseLocksAndCommitOrRollback(true);
                        break block38;
                    }
                    if (this.driverContext.getPlan().getOperation() == HiveOperation.ROLLBACK) {
                        this.releaseLocksAndCommitOrRollback(false);
                        break block38;
                    }
                    if (!this.driverContext.getTxnManager().isTxnOpen() && this.driverContext.getQueryState().getHiveOperation() == HiveOperation.REPLLOAD) {
                        this.releaseLocksAndCommitOrRollback(false);
                    }
                }
                catch (LockException e) {
                    throw this.handleHiveException(e, 12);
                }
            }
            perfLogger.PerfLogEnd(CLASS_NAME, "Driver.run");
            this.driverContext.getQueryDisplay().setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
            this.driverContext.getQueryDisplay().setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
            try {
                this.driverContext.getHookRunner().runPostDriverHooks(hookContext);
            }
            catch (Exception e) {
                String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, ErrorMsg.findSQLState(e.getMessage()), e);
            }
            isFinishedWithError = false;
        }
        finally {
            if (this.driverState.isAborted()) {
                this.closeInProcess(true);
            } else {
                this.releaseResources();
            }
            this.driverState.lock();
            try {
                this.driverState.executionFinished(isFinishedWithError);
            }
            finally {
                this.driverState.unlock();
            }
        }
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
    }

    private void rollback(CommandProcessorException cpe) throws CommandProcessorException {
        try {
            this.releaseLocksAndCommitOrRollback(false);
        }
        catch (LockException e) {
            LOG.error("rollback() FAILED: " + cpe);
            this.handleHiveException(e, 12, "Additional info in hive.log at \"rollback() FAILED\"");
        }
    }

    private CommandProcessorException handleHiveException(HiveException e, int ret) throws CommandProcessorException {
        return this.handleHiveException(e, ret, null);
    }

    private CommandProcessorException handleHiveException(HiveException e, int ret, String rootMsg) throws CommandProcessorException {
        String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
        if (rootMsg != null) {
            errorMessage = errorMessage + "\n" + rootMsg;
        }
        String sqlState = e.getCanonicalErrorMsg() != null ? e.getCanonicalErrorMsg().getSQLState() : ErrorMsg.findSQLState(e.getMessage());
        CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
        throw DriverUtils.createProcessorException(this.driverContext, ret, errorMessage, sqlState, e);
    }

    private boolean requiresLock() {
        if (!DriverUtils.checkConcurrency(this.driverContext)) {
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        if (this.isExplicitLockOperation()) {
            return false;
        }
        if (this.context.isExplainSkipExecution()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.driverContext.getConf(), HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        if (this.driverContext.getConf().get("hive.query.exclusive.lock") != null) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> tasks = new LinkedList<Task<? extends Serializable>>();
        tasks.addAll(this.driverContext.getPlan().getRootTasks());
        while (tasks.peek() != null) {
            Task tsk = (Task)tasks.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                tasks.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            tasks.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private boolean isExplicitLockOperation() {
        HiveOperation currentOpt = this.driverContext.getPlan().getOperation();
        if (currentOpt != null) {
            switch (currentOpt) {
                case LOCKDB: 
                case UNLOCKDB: 
                case LOCKTABLE: 
                case UNLOCKTABLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isFetchingTable() {
        return this.driverContext.getFetchTask() != null;
    }

    @Override
    public boolean getResults(List res) throws IOException {
        if (this.driverState.isDestroyed() || this.driverState.isClosed()) {
            throw new IOException("FAILED: query has been cancelled, closed, or destroyed.");
        }
        if (this.isFetchingTable()) {
            if (((FetchWork)this.driverContext.getFetchTask().getWork()).isUsingThriftJDBCBinarySerDe()) {
                this.maxRows = 1;
            }
            this.driverContext.getFetchTask().setMaxRows(this.maxRows);
            return this.driverContext.getFetchTask().fetch(res);
        }
        if (this.driverContext.getResStream() == null) {
            this.driverContext.setResStream(this.context.getStream());
        }
        if (this.driverContext.getResStream() == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.driverContext.getResStream() == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.driverContext.getResStream(), this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                CONSOLE.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.driverContext.setResStream(this.context.getStream());
        }
        return true;
    }

    @Override
    public void resetFetch() throws IOException {
        if (this.driverState.isDestroyed() || this.driverState.isClosed()) {
            throw new IOException("FAILED: driver has been cancelled, closed or destroyed.");
        }
        if (this.isFetchingTable()) {
            try {
                this.driverContext.getFetchTask().clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.driverContext.getFetchTask().initialize(this.driverContext.getQueryState(), null, null, this.context);
        } else {
            this.context.resetStream();
            this.driverContext.setResStream(null);
        }
    }

    private void releaseTaskQueue() {
        this.driverState.lock();
        try {
            if (this.taskQueue != null) {
                this.taskQueue.shutdown();
                this.taskQueue = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while shutting down the task runner", (Throwable)e);
        }
        finally {
            this.driverState.unlock();
        }
    }

    private void releasePlan() {
        try {
            if (this.driverContext.getPlan() != null) {
                FetchTask fetchTask = this.driverContext.getPlan().getFetchTask();
                if (fetchTask != null) {
                    fetchTask.setTaskQueue(null);
                    fetchTask.setQueryPlan(null);
                }
                this.driverContext.setFetchTask(fetchTask);
            }
            this.driverContext.setPlan(null);
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the Fetch task", (Throwable)e);
        }
    }

    private void releaseContext() {
        try {
            if (this.context != null) {
                this.context.clear();
                if (this.context.getHiveLocks() != null) {
                    this.hiveLocks.addAll(this.context.getHiveLocks());
                    this.context.setHiveLocks(null);
                }
                this.context = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the context ", (Throwable)e);
        }
    }

    private void releaseResStream() {
        try {
            if (this.driverContext.getResStream() != null) {
                ((FSDataInputStream)this.driverContext.getResStream()).close();
                this.driverContext.setResStream(null);
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while closing the resStream ", (Throwable)e);
        }
    }

    private void releaseFetchTask() {
        try {
            if (this.driverContext.getFetchTask() != null) {
                this.driverContext.getFetchTask().clearFetch();
                this.driverContext.setFetchTask(null);
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while clearing the FetchTask ", (Throwable)e);
        }
    }

    private boolean hasBadCacheAttempt() {
        return this.driverContext.getCacheUsage() != null && this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.driverContext.getCacheUsage().getCacheEntry() != null;
    }

    private void releaseCachedResult() {
        if (this.driverContext.getUsedCacheEntry() != null) {
            this.driverContext.getUsedCacheEntry().releaseReader();
            this.driverContext.setUsedCacheEntry(null);
        } else if (this.hasBadCacheAttempt()) {
            try {
                QueryResultsCache.getInstance().removeEntry(this.driverContext.getCacheUsage().getCacheEntry());
            }
            catch (Exception err) {
                LOG.error("Error removing failed cache entry " + this.driverContext.getCacheUsage().getCacheEntry(), (Throwable)err);
            }
        }
        this.driverContext.setCacheUsage(null);
    }

    private int closeInProcess(boolean destroyed) {
        this.releaseTaskQueue();
        this.releasePlan();
        this.releaseCachedResult();
        this.releaseFetchTask();
        this.releaseResStream();
        this.releaseContext();
        if (destroyed) {
            if (!this.hiveLocks.isEmpty()) {
                try {
                    this.releaseLocksAndCommitOrRollback(false);
                }
                catch (LockException e) {
                    LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
                }
            }
            ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
        }
        return 0;
    }

    @Override
    public void close() {
        this.driverState.lock();
        try {
            this.releaseTaskQueue();
            if (this.driverState.isCompiling() || this.driverState.isExecuting()) {
                this.driverState.abort();
            }
            this.releasePlan();
            this.releaseCachedResult();
            this.releaseFetchTask();
            this.releaseResStream();
            this.releaseContext();
            this.driverState.closed();
        }
        finally {
            this.driverState.unlock();
            DriverState.removeDriverState();
        }
        this.destroy();
    }

    @Override
    public void destroy() {
        boolean isTxnOpen;
        this.driverState.lock();
        try {
            if (this.driverState.isDestroyed()) {
                return;
            }
            this.driverState.descroyed();
        }
        finally {
            this.driverState.unlock();
        }
        boolean bl = isTxnOpen = this.driverContext != null && this.driverContext.getTxnManager() != null && this.driverContext.getTxnManager().isTxnOpen() && org.apache.commons.lang3.StringUtils.equals(this.driverContext.getQueryState().getQueryId(), this.driverContext.getTxnManager().getQueryid());
        if (!this.hiveLocks.isEmpty() || isTxnOpen) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
            }
        }
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
    }

    @Override
    public QueryDisplay getQueryDisplay() {
        return this.driverContext.getQueryDisplay();
    }

    @Override
    public void setOperationId(String operationId) {
        this.driverContext.setOperationId(operationId);
    }

    @Override
    public QueryState getQueryState() {
        return this.driverContext.getQueryState();
    }

    public HookRunner getHookRunner() {
        return this.driverContext.getHookRunner();
    }

    public void setStatsSource(StatsSource runtimeStatsSource) {
        this.driverContext.setStatsSource(runtimeStatsSource);
    }

    public StatsSource getStatsSource() {
        return this.driverContext.getStatsSource();
    }

    @Override
    public boolean hasResultSet() {
        for (Task<? extends Serializable> task : this.driverContext.getPlan().getRootTasks()) {
            if (task.getClass() != ExplainTask.class) continue;
            return true;
        }
        return this.driverContext.getPlan().getFetchTask() != null && this.driverContext.getPlan().getResultSchema() != null && this.driverContext.getPlan().getResultSchema().isSetFieldSchemas();
    }
}

