/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DDLUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.exec.DDLTask");

    private DDLUtils() {
        throw new UnsupportedOperationException("DDLUtils should not be instantiated");
    }

    public static DataOutputStream getOutputStream(Path outputFile, DDLOperationContext context) throws HiveException {
        try {
            FileSystem fs = outputFile.getFileSystem((Configuration)context.getConf());
            return fs.create(outputFile);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static boolean addIfAbsentByName(WriteEntity newWriteEntity, Set<WriteEntity> outputs) {
        for (WriteEntity writeEntity : outputs) {
            if (!writeEntity.getName().equalsIgnoreCase(newWriteEntity.getName())) continue;
            LOG.debug("Ignoring request to add {} because {} is present", (Object)newWriteEntity.toStringDetail(), (Object)writeEntity.toStringDetail());
            return false;
        }
        outputs.add(newWriteEntity);
        return true;
    }

    public static boolean addIfAbsentByName(WriteEntity newWriteEntity, DDLOperationContext context) {
        return DDLUtils.addIfAbsentByName(newWriteEntity, context.getWork().getOutputs());
    }

    public static void validateSerDe(String serdeName, DDLOperationContext context) throws HiveException {
        DDLUtils.validateSerDe(serdeName, context.getConf());
    }

    public static void validateSerDe(String serdeName, HiveConf conf) throws HiveException {
        try {
            Deserializer d = ReflectionUtil.newInstance(conf.getClassByName(serdeName).asSubclass(Deserializer.class), conf);
            if (d != null) {
                LOG.debug("Found class for {}", (Object)serdeName);
            }
        }
        catch (Exception e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    public static boolean allowOperationInReplicationScope(Hive db, String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) throws HiveException {
        Map<String, String> dbParams;
        if (null == replicationSpec || !replicationSpec.isInReplicationScope()) {
            return true;
        }
        Table existingTable = db.getTable(tableName, false);
        if (existingTable != null && replicationSpec.allowEventReplacementInto(dbParams = db.getDatabase(existingTable.getDbName()).getParameters())) {
            if (partSpec != null) {
                Partition existingPtn = db.getPartition(existingTable, partSpec, false);
                return existingPtn != null && replicationSpec.allowEventReplacementInto(dbParams);
            }
            return true;
        }
        return false;
    }

    public static String propertiesToString(Map<String, String> props, Set<String> exclude) {
        if (props.isEmpty()) {
            return "";
        }
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(props);
        ArrayList<String> realProps = new ArrayList<String>();
        for (Map.Entry e : sortedProperties.entrySet()) {
            if (e.getValue() == null || exclude != null && exclude.contains(e.getKey())) continue;
            realProps.add("  '" + (String)e.getKey() + "'='" + HiveStringUtils.escapeHiveCommand((String)e.getValue()) + "'");
        }
        return StringUtils.join(realProps, ", \n");
    }

    public static void writeToFile(String data, String file, DDLOperationContext context) throws IOException {
        if (StringUtils.isEmpty(data)) {
            return;
        }
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)context.getConf());
        try (FSDataOutputStream out = fs.create(resFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");){
            writer.write(data);
            writer.write(10);
            writer.flush();
        }
    }

    public static void appendNonNull(StringBuilder builder, Object value) {
        DDLUtils.appendNonNull(builder, value, false);
    }

    public static void appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
    }

    public static void addServiceOutput(HiveConf conf, Set<WriteEntity> outputs) throws SemanticException {
        String hs2Hostname = DDLUtils.getHS2Host(conf);
        if (hs2Hostname != null) {
            outputs.add(new WriteEntity(hs2Hostname, Entity.Type.SERVICE_NAME));
        }
    }

    private static String getHS2Host(HiveConf conf) throws SemanticException {
        if (SessionState.get().isHiveServerQuery()) {
            return SessionState.get().getHiveServer2Host();
        }
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE)) {
            return "dummyHostnameForTest";
        }
        throw new SemanticException("Kill query is only supported in HiveServer2 (not hive cli)");
    }

    public static String getFQName(ASTNode node) {
        if (node.getChildCount() == 0) {
            return node.getText();
        }
        if (node.getChildCount() == 2) {
            return DDLUtils.getFQName((ASTNode)node.getChild(0)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(1));
        }
        if (node.getChildCount() == 3) {
            return DDLUtils.getFQName((ASTNode)node.getChild(0)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(1)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(2));
        }
        return null;
    }

    public static void addDbAndTableToOutputs(Database database, TableName tableName, TableType type, boolean isTemporary, Map<String, String> properties, Set<WriteEntity> outputs) {
        outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_SHARED));
        Table table = new Table(tableName.getDb(), tableName.getTable());
        table.setParameters(properties);
        table.setTableType(type);
        table.setTemporary(isTemporary);
        outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

