/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.alter.location;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.alter.AbstractAlterDatabaseOperation;
import org.apache.hadoop.hive.ql.ddl.database.alter.location.AlterDatabaseSetLocationDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterDatabaseSetLocationOperation
extends AbstractAlterDatabaseOperation<AlterDatabaseSetLocationDesc> {
    public AlterDatabaseSetLocationOperation(DDLOperationContext context, AlterDatabaseSetLocationDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Database database, Map<String, String> params) throws HiveException {
        try {
            String newLocation = Utilities.getQualifiedPath(this.context.getConf(), new Path(((AlterDatabaseSetLocationDesc)this.desc).getLocation()));
            if (newLocation.equalsIgnoreCase(database.getManagedLocationUri())) {
                throw new HiveException("Managed and external locations for database cannot be the same");
            }
            URI locationURI = new URI(newLocation);
            if (!locationURI.isAbsolute() || StringUtils.isBlank(locationURI.getScheme())) {
                throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, newLocation);
            }
            if (newLocation.equals(database.getLocationUri())) {
                LOG.info("AlterDatabase skipped. No change in location.");
            } else {
                database.setLocationUri(newLocation);
            }
            return;
        }
        catch (URISyntaxException e) {
            throw new HiveException(e);
        }
    }
}

