/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.desc;

import java.io.DataOutputStream;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.database.desc.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DescDatabaseOperation
extends DDLOperation<DescDatabaseDesc> {
    public DescDatabaseOperation(DDLOperationContext context, DescDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((DescDatabaseDesc)this.desc).getResFile()), this.context);){
            Database database = this.context.getDb().getDatabase(((DescDatabaseDesc)this.desc).getDatabaseName());
            if (database == null) {
                throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, ((DescDatabaseDesc)this.desc).getDatabaseName());
            }
            TreeMap<String, String> params = null;
            if (((DescDatabaseDesc)this.desc).isExt()) {
                params = new TreeMap<String, String>(database.getParameters());
            }
            String location = database.getLocationUri();
            if (HiveConf.getBoolVar(this.context.getConf(), HiveConf.ConfVars.HIVE_IN_TEST)) {
                location = "location/in/test";
            }
            this.context.getFormatter().showDatabaseDescription(outStream, database.getName(), database.getDescription(), location, database.getManagedLocationUri(), database.getOwnerName(), database.getOwnerType(), params);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }
}

