/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.function.show.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde.serdeConstants;

public class ShowFunctionsOperation
extends DDLOperation<ShowFunctionsDesc> {
    public ShowFunctionsOperation(DDLOperationContext context, ShowFunctionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Set<String> funcs = this.fetchFunctions();
        return this.printFunctions(funcs);
    }

    private Set<String> fetchFunctions() {
        Set<String> funcs = null;
        if (((ShowFunctionsDesc)this.desc).getPattern() != null) {
            funcs = FunctionRegistry.getFunctionNamesByLikePattern(((ShowFunctionsDesc)this.desc).getPattern());
            LOG.info("Found {} function(s) using pattern {} matching the SHOW FUNCTIONS statement.", (Object)funcs.size(), (Object)((ShowFunctionsDesc)this.desc).getPattern());
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        return funcs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int printFunctions(Set<String> funcs) throws HiveException {
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowFunctionsDesc)this.desc).getResFile()), this.context);){
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            sortedFuncs.removeAll(serdeConstants.PrimitiveTypes);
            for (String func : sortedFuncs) {
                outStream.writeBytes(func);
                outStream.write(10);
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

