/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.metadata;

import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.misc.metadata.CacheMetadataDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AnalyzeCommandUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={829})
public class CacheMetadataAnalyzer
extends AbstractFunctionAnalyzer {
    public CacheMetadataAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        CacheMetadataDesc desc;
        Table table = AnalyzeCommandUtils.getTable(root, this);
        if (AnalyzeCommandUtils.isPartitionLevelStats(root)) {
            Map<String, String> partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(table, root, this.conf);
            Partition part = PartitionUtils.getPartition(this.db, table, partSpec, true);
            desc = new CacheMetadataDesc(table.getDbName(), table.getTableName(), part.getName());
            this.inputs.add(new ReadEntity(part));
        } else {
            desc = new CacheMetadataDesc(table.getDbName(), table.getTableName(), table.isPartitioned());
            this.inputs.add(new ReadEntity(table));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

