/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.show.principals;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.show.principals.ShowPrincipalsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;

public class ShowPrincipalsOperation
extends DDLOperation<ShowPrincipalsDesc> {
    public ShowPrincipalsOperation(DDLOperationContext context, ShowPrincipalsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        boolean testMode = this.context.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
        List<HiveRoleGrant> roleGrants = authorizer.getPrincipalGrantInfoForRole(((ShowPrincipalsDesc)this.desc).getName());
        DDLUtils.writeToFile(this.writeHiveRoleGrantInfo(roleGrants, testMode), ((ShowPrincipalsDesc)this.desc).getResFile(), this.context);
        return 0;
    }

    private String writeHiveRoleGrantInfo(List<HiveRoleGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (HiveRoleGrant roleGrant : roleGrants) {
            DDLUtils.appendNonNull(builder, roleGrant.getPrincipalName(), true);
            DDLUtils.appendNonNull(builder, roleGrant.getPrincipalType());
            DDLUtils.appendNonNull(builder, roleGrant.isGrantOption());
            DDLUtils.appendNonNull(builder, roleGrant.getGrantor());
            DDLUtils.appendNonNull(builder, roleGrant.getGrantorType());
            DDLUtils.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
        }
        return builder.toString();
    }
}

