/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.kill;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.process.kill.KillQueriesDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class KillQueriesOperation
extends DDLOperation<KillQueriesDesc> {
    public KillQueriesOperation(DDLOperationContext context, KillQueriesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        SessionState sessionState = SessionState.get();
        for (String queryId : ((KillQueriesDesc)this.desc).getQueryIds()) {
            boolean isExternal = HiveConf.getBoolVar(this.context.getDb().getConf(), HiveConf.ConfVars.HIVE_SERVER2_TEZ_USE_EXTERNAL_SESSIONS);
            sessionState.getKillQuery().killQuery(queryId, "User invoked KILL QUERY", this.context.getDb().getConf(), !isExternal);
        }
        LOG.info("kill query called ({})", ((KillQueriesDesc)this.desc).getQueryIds());
        return 0;
    }
}

