/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.show.compactions;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.process.show.compactions.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ShowCompactionsOperation
extends DDLOperation<ShowCompactionsDesc> {
    public ShowCompactionsOperation(DDLOperationContext context, ShowCompactionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        ShowCompactResponse rsp = this.context.getDb().showCompactions();
        try (DataOutputStream os = DDLUtils.getOutputStream(new Path(((ShowCompactionsDesc)this.desc).getResFile()), this.context);){
            this.writeHeader(os);
            if (rsp.getCompacts() != null) {
                for (ShowCompactResponseElement e : rsp.getCompacts()) {
                    this.writeRow(os, e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("show compactions: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        os.writeBytes("CompactionId");
        os.write(9);
        os.writeBytes("Database");
        os.write(9);
        os.writeBytes("Table");
        os.write(9);
        os.writeBytes("Partition");
        os.write(9);
        os.writeBytes("Type");
        os.write(9);
        os.writeBytes("State");
        os.write(9);
        os.writeBytes("Worker host");
        os.write(9);
        os.writeBytes("Worker");
        os.write(9);
        os.writeBytes("Enqueue Time");
        os.write(9);
        os.writeBytes("Start Time");
        os.write(9);
        os.writeBytes("Duration(ms)");
        os.write(9);
        os.writeBytes("HadoopJobId");
        os.write(9);
        os.writeBytes("Error message");
        os.write(9);
        os.writeBytes("Initiator host");
        os.write(9);
        os.writeBytes("Initiator");
        os.write(10);
    }

    private void writeRow(DataOutputStream os, ShowCompactResponseElement e) throws IOException {
        os.writeBytes(Long.toString(e.getId()));
        os.write(9);
        os.writeBytes(e.getDbname());
        os.write(9);
        os.writeBytes(e.getTablename());
        os.write(9);
        String part = e.getPartitionname();
        os.writeBytes(part == null ? " --- " : part);
        os.write(9);
        os.writeBytes(e.getType().toString());
        os.write(9);
        os.writeBytes(e.getState());
        os.write(9);
        os.writeBytes(MetaStoreUtils.getHostFromId(e.getWorkerid()));
        os.write(9);
        os.writeBytes(MetaStoreUtils.getThreadIdFromId(e.getWorkerid()));
        os.write(9);
        os.writeBytes(e.isSetEnqueueTime() ? Long.toString(e.getEnqueueTime()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetStart() ? Long.toString(e.getStart()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetEndTime() ? Long.toString(e.getEndTime() - e.getStart()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetHadoopJobId() ? e.getHadoopJobId() : " --- ");
        os.write(9);
        String error = e.getErrorMessage();
        os.writeBytes(error == null ? " --- " : error);
        os.write(9);
        os.writeBytes(MetaStoreUtils.getHostFromId(e.getInitiatorId()));
        os.write(9);
        os.writeBytes(MetaStoreUtils.getThreadIdFromId(e.getInitiatorId()));
        os.write(10);
    }
}

