/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.change;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.column.change.AlterTableChangeColumnDesc;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={789})
public class AlterTableChangeColumnAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableChangeColumnAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String oldColumnName = command.getChild(0).getText();
        String newColumnName = command.getChild(1).getText();
        String newType = AlterTableChangeColumnAnalyzer.getTypeStringFromAST((ASTNode)command.getChild(2));
        Table table = this.getTable(tableName);
        SkewedInfo skewInfo = table.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColumnName)) {
            throw new SemanticException(oldColumnName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        ASTNode constraintChild = null;
        block7: for (int i = 3; i < command.getChildCount(); ++i) {
            ASTNode child = (ASTNode)command.getChild(i);
            switch (child.getToken().getType()) {
                case 396: {
                    newComment = AlterTableChangeColumnAnalyzer.unescapeSQLString(child.getText());
                    continue block7;
                }
                case 775: {
                    flagCol = AlterTableChangeColumnAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block7;
                }
                case 141: {
                    first = true;
                    continue block7;
                }
                case 830: {
                    isCascade = true;
                    continue block7;
                }
                case 1044: {
                    continue block7;
                }
                default: {
                    constraintChild = child;
                }
            }
        }
        Constraints constraints = this.getConstraints(tableName, command, newColumnName, table, constraintChild);
        AlterTableChangeColumnDesc desc = new AlterTableChangeColumnDesc(tableName, partitionSpec, isCascade, constraints, AlterTableChangeColumnAnalyzer.unescapeIdentifier(oldColumnName), AlterTableChangeColumnAnalyzer.unescapeIdentifier(newColumnName), newType, newComment, first, flagCol);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private Constraints getConstraints(TableName tableName, ASTNode command, String newColumnName, Table table, ASTNode constraintChild) throws SemanticException {
        ArrayList<SQLPrimaryKey> primaryKeys = null;
        ArrayList<SQLForeignKey> foreignKeys = null;
        ArrayList<SQLUniqueConstraint> uniqueConstraints = null;
        ArrayList<SQLNotNullConstraint> notNullConstraints = null;
        ArrayList<SQLDefaultConstraint> defaultConstraints = null;
        ArrayList<SQLCheckConstraint> checkConstraints = null;
        if (constraintChild != null) {
            switch (constraintChild.getToken().getType()) {
                case 833: {
                    checkConstraints = new ArrayList<SQLCheckConstraint>();
                    ConstraintsUtils.processCheckConstraints(tableName, constraintChild, ImmutableList.of(newColumnName), checkConstraints, (ASTNode)command.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 868: {
                    defaultConstraints = new ArrayList<SQLDefaultConstraint>();
                    ConstraintsUtils.processDefaultConstraints(tableName, constraintChild, ImmutableList.of(newColumnName), defaultConstraints, (ASTNode)command.getChild(2), this.ctx.getTokenRewriteStream());
                    break;
                }
                case 968: {
                    notNullConstraints = new ArrayList<SQLNotNullConstraint>();
                    ConstraintsUtils.processNotNullConstraints(tableName, constraintChild, ImmutableList.of(newColumnName), notNullConstraints);
                    break;
                }
                case 1160: {
                    uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
                    ConstraintsUtils.processUniqueConstraints(tableName, constraintChild, ImmutableList.of(newColumnName), uniqueConstraints);
                    break;
                }
                case 1006: {
                    primaryKeys = new ArrayList<SQLPrimaryKey>();
                    ConstraintsUtils.processPrimaryKeys(tableName, constraintChild, ImmutableList.of(newColumnName), primaryKeys);
                    break;
                }
                case 908: {
                    foreignKeys = new ArrayList<SQLForeignKey>();
                    ConstraintsUtils.processForeignKeys(tableName, constraintChild, foreignKeys);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(constraintChild.getToken().getText()));
                }
            }
        }
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            ConstraintsUtils.validateCheckConstraint(table.getCols(), checkConstraints, this.ctx.getConf());
        }
        if (table.getTableType() == TableType.EXTERNAL_TABLE && ConstraintsUtils.hasEnabledOrValidatedConstraints(notNullConstraints, defaultConstraints, checkConstraints)) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraints are disallowed with External tables. Only RELY is allowed."));
        }
        return new Constraints(primaryKeys, foreignKeys, notNullConstraints, uniqueConstraints, defaultConstraints, checkConstraints);
    }
}

