/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.change;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.column.change.AlterTableChangeColumnDesc;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;

public class AlterTableChangeColumnOperation
extends AbstractAlterTableOperation<AlterTableChangeColumnDesc> {
    public AlterTableChangeColumnOperation(DDLOperationContext context, AlterTableChangeColumnDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        boolean isOrcSchemaEvolution;
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String serializationLib = sd.getSerdeInfo().getSerializationLib();
        AvroSerdeUtils.handleAlterTableForAvro(this.context.getConf(), serializationLib, table.getTTable().getParameters());
        boolean bl = isOrcSchemaEvolution = sd.getInputFormat().equals(OrcInputFormat.class.getName()) && AlterTableUtils.isSchemaEvolutionEnabled(table, this.context.getConf());
        if (isOrcSchemaEvolution && (((AlterTableChangeColumnDesc)this.desc).isFirst() || StringUtils.isNotBlank(((AlterTableChangeColumnDesc)this.desc).getAfterColumn()))) {
            throw new HiveException(ErrorMsg.CANNOT_REORDER_COLUMNS, ((AlterTableChangeColumnDesc)this.desc).getDbTableName());
        }
        FieldSchema column = null;
        boolean found = false;
        int position = ((AlterTableChangeColumnDesc)this.desc).isFirst() ? 0 : -1;
        int i = 1;
        List<FieldSchema> oldColumns = partition == null ? table.getColsForMetastore() : partition.getColsForMetastore();
        ArrayList<FieldSchema> newColumns = new ArrayList<FieldSchema>();
        for (FieldSchema oldColumn : oldColumns) {
            String oldColumnName = oldColumn.getName();
            if (oldColumnName.equalsIgnoreCase(((AlterTableChangeColumnDesc)this.desc).getOldColumnName())) {
                oldColumn.setName(((AlterTableChangeColumnDesc)this.desc).getNewColumnName());
                if (StringUtils.isNotBlank(((AlterTableChangeColumnDesc)this.desc).getNewColumnType())) {
                    oldColumn.setType(((AlterTableChangeColumnDesc)this.desc).getNewColumnType());
                }
                if (((AlterTableChangeColumnDesc)this.desc).getNewColumnComment() != null) {
                    oldColumn.setComment(((AlterTableChangeColumnDesc)this.desc).getNewColumnComment());
                }
                found = true;
                if (((AlterTableChangeColumnDesc)this.desc).isFirst() || StringUtils.isNotBlank(((AlterTableChangeColumnDesc)this.desc).getAfterColumn())) {
                    column = oldColumn;
                    continue;
                }
            } else if (oldColumnName.equalsIgnoreCase(((AlterTableChangeColumnDesc)this.desc).getNewColumnName())) {
                throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, ((AlterTableChangeColumnDesc)this.desc).getNewColumnName());
            }
            if (oldColumnName.equalsIgnoreCase(((AlterTableChangeColumnDesc)this.desc).getAfterColumn())) {
                position = i;
            }
            ++i;
            newColumns.add(oldColumn);
        }
        if (!found) {
            throw new HiveException(ErrorMsg.INVALID_COLUMN, ((AlterTableChangeColumnDesc)this.desc).getOldColumnName());
        }
        if (StringUtils.isNotBlank(((AlterTableChangeColumnDesc)this.desc).getAfterColumn()) && position < 0) {
            throw new HiveException(ErrorMsg.INVALID_COLUMN, ((AlterTableChangeColumnDesc)this.desc).getAfterColumn());
        }
        if (position >= 0) {
            newColumns.add(position, column);
        }
        sd.setCols(newColumns);
    }
}

