/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint.add;

import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableWithConstraintsDesc;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintDesc;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterTableAddConstraintOperation
extends DDLOperation<AlterTableAddConstraintDesc> {
    public AlterTableAddConstraintOperation(DDLOperationContext context, AlterTableAddConstraintDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        if (!DDLUtils.allowOperationInReplicationScope(this.context.getDb(), ((AlterTableAddConstraintDesc)this.desc).getDbTableName(), null, ((AlterTableAddConstraintDesc)this.desc).getReplicationSpec())) {
            LOG.debug("DDLTask: Alter Table is skipped as table {} is newer than update", (Object)((AlterTableAddConstraintDesc)this.desc).getDbTableName());
            return 0;
        }
        AlterTableAddConstraintOperation.addConstraints((AbstractAlterTableWithConstraintsDesc)this.desc, this.context.getDb());
        return 0;
    }

    public static void addConstraints(AbstractAlterTableWithConstraintsDesc desc, Hive db) throws HiveException {
        try {
            Constraints constraints = desc.getConstraints();
            if (CollectionUtils.isNotEmpty(constraints.getPrimaryKeys())) {
                db.addPrimaryKey(constraints.getPrimaryKeys());
            }
            if (CollectionUtils.isNotEmpty(constraints.getForeignKeys())) {
                try {
                    db.addForeignKey(constraints.getForeignKeys());
                }
                catch (HiveException e) {
                    if (e.getCause() instanceof InvalidObjectException && desc.getReplicationSpec() != null && desc.getReplicationSpec().isInReplicationScope()) {
                        LOG.debug("InvalidObjectException: ", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (CollectionUtils.isNotEmpty(constraints.getUniqueConstraints())) {
                db.addUniqueConstraint(constraints.getUniqueConstraints());
            }
            if (CollectionUtils.isNotEmpty(constraints.getNotNullConstraints())) {
                db.addNotNullConstraint(constraints.getNotNullConstraints());
            }
            if (CollectionUtils.isNotEmpty(constraints.getDefaultConstraints())) {
                db.addDefaultConstraint(constraints.getDefaultConstraints());
            }
            if (CollectionUtils.isNotEmpty(constraints.getCheckConstraints())) {
                db.addCheckConstraint(constraints.getCheckConstraints());
            }
        }
        catch (NoSuchObjectException e) {
            throw new HiveException(e);
        }
    }
}

