/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint.drop;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.constraint.drop.AlterTableDropConstraintDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={778})
public class AlterTableDropConstraintAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableDropConstraintAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String constraintName = AlterTableDropConstraintAnalyzer.unescapeIdentifier(command.getChild(0).getText());
        AlterTableDropConstraintDesc desc = new AlterTableDropConstraintDesc(tableName, null, constraintName);
        Table tbl = this.getTable(tableName);
        WriteEntity.WriteType writeType = null;
        if (AcidUtils.isTransactionalTable(tbl)) {
            this.setAcidDdlDesc(desc);
            writeType = WriteEntity.WriteType.DDL_EXCLUSIVE;
        } else {
            writeType = WriteEntity.determineAlterTableWriteType(AlterTableType.DROP_CONSTRAINT);
        }
        this.inputs.add(new ReadEntity(tbl));
        WriteEntity alterTableOutput = new WriteEntity(tbl, writeType);
        this.outputs.add(alterTableOutput);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

