/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.like;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateTableLikeDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final boolean isExternal;
    private final boolean isTemporary;
    private final String defaultInputFormat;
    private final String defaultOutputFormat;
    private final String location;
    private final String defaultSerName;
    private final Map<String, String> defaultSerdeProps;
    private final Map<String, String> tblProps;
    private final boolean ifNotExists;
    private final String likeTableName;
    private final boolean isUserStorageFormat;

    public CreateTableLikeDesc(String tableName, boolean isExternal, boolean isTemporary, String defaultInputFormat, String defaultOutputFormat, String location, String defaultSerName, Map<String, String> defaultSerdeProps, Map<String, String> tblProps, boolean ifNotExists, String likeTableName, boolean isUserStorageFormat) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.isTemporary = isTemporary;
        this.defaultInputFormat = defaultInputFormat;
        this.defaultOutputFormat = defaultOutputFormat;
        this.defaultSerName = defaultSerName;
        this.defaultSerdeProps = defaultSerdeProps;
        this.location = location;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
        this.likeTableName = likeTableName;
        this.isUserStorageFormat = isUserStorageFormat;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="default input format")
    public String getDefaultInputFormat() {
        return this.defaultInputFormat;
    }

    @Explain(displayName="default output format")
    public String getDefaultOutputFormat() {
        return this.defaultOutputFormat;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    @Explain(displayName="isExternal", displayOnlyOnTrue=true)
    public boolean isExternal() {
        return this.isExternal;
    }

    @Explain(displayName="default serde name")
    public String getDefaultSerName() {
        return this.defaultSerName;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getDefaultSerdeProps() {
        return this.defaultSerdeProps;
    }

    @Explain(displayName="like")
    public String getLikeTableName() {
        return this.likeTableName;
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblPropsExplain() {
        HashMap<String, String> copy = new HashMap<String, String>(this.tblProps);
        copy.remove("created_with_ctas");
        copy.remove("created_with_ctlt");
        return copy;
    }

    @Explain(displayName="isTemporary", displayOnlyOnTrue=true)
    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isUserStorageFormat() {
        return this.isUserStorageFormat;
    }
}

