/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.exec.DDLPlanUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowCreateTableOperation
extends DDLOperation<ShowCreateTableDesc> {
    public ShowCreateTableOperation(DDLOperationContext context, ShowCreateTableDesc desc) {
        super(context, desc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowCreateTableDesc)this.desc).getResFile()), this.context);){
            String command;
            Table table = this.context.getDb().getTable(((ShowCreateTableDesc)this.desc).getDatabaseName(), ((ShowCreateTableDesc)this.desc).getTableName());
            DDLPlanUtils ddlObj = new DDLPlanUtils();
            if (table.isView()) {
                command = ddlObj.getCreateViewCommand(table, ((ShowCreateTableDesc)this.desc).isRelative());
            } else {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add(ddlObj.getCreateTableCommand(table, ((ShowCreateTableDesc)this.desc).isRelative()));
                String primaryKeyStmt = ddlObj.getAlterTableStmtPrimaryKeyConstraint(table.getPrimaryKeyInfo());
                if (primaryKeyStmt != null) {
                    commands.add(primaryKeyStmt);
                }
                commands.addAll(ddlObj.populateConstraints(table, new HashSet<String>(Collections.singletonList(table.getTableName()))));
                command = String.join((CharSequence)"\n", commands);
            }
            outStream.write(command.getBytes(StandardCharsets.UTF_8));
            int n = 0;
            return n;
        }
        catch (IOException e) {
            LOG.info("Show create table failed", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

