/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.drop;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={884})
public class DropTableAnalyzer
extends BaseSemanticAnalyzer {
    public DropTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean ifExists;
        boolean throwException;
        String tableName = DropTableAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table table = this.getTable(tableName, throwException = !(ifExists = root.getFirstChildWithType(924) != null) && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT));
        if (table != null) {
            this.inputs.add(new ReadEntity(table));
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
        }
        boolean purge = root.getFirstChildWithType(253) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(root);
        DropTableDesc desc = new DropTableDesc(tableName, ifExists, purge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

