/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.desc;

import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class DescTableOperation
extends DDLOperation<DescTableDesc> {
    public DescTableOperation(DDLOperationContext context, DescTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        Table table = this.getTable();
        Partition part = this.getPartition(table);
        String dbTableName = ((DescTableDesc)this.desc).getDbTableName();
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((DescTableDesc)this.desc).getResFile()), this.context);){
            LOG.debug("DDLTask: got data for {}", (Object)dbTableName);
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
            Deserializer deserializer = this.getDeserializer(table);
            if (((DescTableDesc)this.desc).getColumnPath() == null) {
                this.getColumnsNoColumnPath(table, part, cols);
            } else if (((DescTableDesc)this.desc).isFormatted()) {
                this.getColumnDataColPathSpecified(table, part, cols, colStats, deserializer);
            } else {
                cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer));
            }
            DescTableOperation.fixDecimalColumnTypeName(cols);
            this.setConstraintsAndStorageHandlerInfo(table);
            this.handleMaterializedView(table);
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            this.context.getFormatter().describeTable(outStream, ((DescTableDesc)this.desc).getColumnPath(), dbTableName, table, part, cols, ((DescTableDesc)this.desc).isFormatted(), ((DescTableDesc)this.desc).isExtended(), isOutputPadded, colStats);
            LOG.debug("DDLTask: written data for {}", (Object)dbTableName);
        }
        catch (SQLException e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, dbTableName);
        }
        return 0;
    }

    private Table getTable() throws HiveException {
        Table table = this.context.getDb().getTable(((DescTableDesc)this.desc).getTableName().getDb(), ((DescTableDesc)this.desc).getTableName().getTable(), false);
        if (table == null) {
            throw new HiveException(ErrorMsg.INVALID_TABLE, ((DescTableDesc)this.desc).getDbTableName());
        }
        return table;
    }

    private Partition getPartition(Table table) throws HiveException {
        Partition part = null;
        if (((DescTableDesc)this.desc).getPartitionSpec() != null && (part = this.context.getDb().getPartition(table, ((DescTableDesc)this.desc).getPartitionSpec(), false)) == null) {
            throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(((DescTableDesc)this.desc).getPartitionSpec().keySet(), ','), ((DescTableDesc)this.desc).getDbTableName());
        }
        return part;
    }

    private Deserializer getDeserializer(Table table) throws SQLException {
        String errorMsgs;
        Deserializer deserializer = table.getDeserializer(true);
        if (deserializer instanceof AbstractSerDe && StringUtils.isNotEmpty(errorMsgs = ((AbstractSerDe)deserializer).getConfigurationErrors())) {
            throw new SQLException(errorMsgs);
        }
        return deserializer;
    }

    private void getColumnsNoColumnPath(Table table, Partition partition, List<FieldSchema> cols) throws HiveException {
        cols.addAll(partition == null || table.getTableType() == TableType.VIRTUAL_VIEW ? table.getCols() : partition.getCols());
        if (!((DescTableDesc)this.desc).isFormatted()) {
            cols.addAll(table.getPartCols());
        }
        if (((DescTableDesc)this.desc).isExtended() || ((DescTableDesc)this.desc).isFormatted()) {
            boolean disablePartitionStats = HiveConf.getBoolVar(this.context.getConf(), HiveConf.ConfVars.HIVE_DESCRIBE_PARTITIONED_TABLE_IGNORE_STATS);
            if (table.isPartitioned() && partition == null && !disablePartitionStats) {
                Map<Object, Object> tblProps = table.getParameters() == null ? new HashMap() : table.getParameters();
                HashMap<String, Long> valueMap = new HashMap<String, Long>();
                HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>();
                for (String stat : StatsSetupConst.SUPPORTED_STATS) {
                    valueMap.put(stat, 0L);
                    stateMap.put(stat, true);
                }
                PartitionIterable partitions = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar(this.context.getConf(), MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
                int numParts = 0;
                for (Partition p : partitions) {
                    Map<String, String> partitionProps = p.getParameters();
                    Boolean state = StatsSetupConst.areBasicStatsUptoDate(partitionProps);
                    for (String stat : StatsSetupConst.SUPPORTED_STATS) {
                        stateMap.put(stat, (Boolean)stateMap.get(stat) != false && state != false);
                        if (partitionProps == null || partitionProps.get(stat) == null) continue;
                        valueMap.put(stat, (Long)valueMap.get(stat) + Long.parseLong(partitionProps.get(stat)));
                    }
                    ++numParts;
                }
                tblProps.put("numPartitions", Integer.toString(numParts));
                for (String stat : StatsSetupConst.SUPPORTED_STATS) {
                    StatsSetupConst.setBasicStatsState(tblProps, Boolean.toString((Boolean)stateMap.get(stat)));
                    tblProps.put(stat, ((Long)valueMap.get(stat)).toString());
                }
                table.setParameters(tblProps);
            }
        }
    }

    private void getColumnDataColPathSpecified(Table table, Partition part, List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, Deserializer deserializer) throws SemanticException, HiveException, MetaException {
        String colName = ((DescTableDesc)this.desc).getColumnPath().split("\\.")[2];
        ArrayList<String> colNames = Lists.newArrayList(colName.toLowerCase());
        String[] dbTab = Utilities.getDbTableName(((DescTableDesc)this.desc).getDbTableName());
        if (null == part) {
            if (table.isPartitioned()) {
                HashMap<String, String> tableProps;
                Map<Object, Object> map = tableProps = table.getParameters() == null ? new HashMap() : table.getParameters();
                if (table.isPartitionKey((String)colNames.get(0))) {
                    this.getColumnDataForPartitionKeyColumn(table, cols, colStats, colNames, tableProps);
                } else {
                    this.getColumnsForNotPartitionKeyColumn(cols, colStats, deserializer, colNames, dbTab, tableProps);
                }
                table.setParameters(tableProps);
            } else {
                cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer));
                colStats.addAll(this.context.getDb().getTableColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), colNames, false));
            }
        } else {
            ArrayList<String> partitions = new ArrayList<String>();
            partitions.add(part.getName());
            cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer));
            List<ColumnStatisticsObj> partitionColStat = this.context.getDb().getPartitionColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), partitions, colNames, false).get(part.getName());
            if (partitionColStat != null) {
                colStats.addAll(partitionColStat);
            }
        }
    }

    private void getColumnDataForPartitionKeyColumn(Table table, List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, List<String> colNames, Map<String, String> tableProps) throws HiveException, MetaException {
        FieldSchema partCol = table.getPartColByName(colNames.get(0));
        cols.add(partCol);
        PartitionIterable parts = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar(this.context.getConf(), MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
        ColumnInfo ci = new ColumnInfo(partCol.getName(), TypeInfoUtils.getTypeInfoFromTypeString(partCol.getType()), null, false);
        ColStatistics cs = StatsUtils.getColStatsForPartCol(ci, parts, this.context.getConf());
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColStatistics.Range r = cs.getRange();
        StatObjectConverter.fillColumnStatisticsData(partCol.getType(), data, r == null ? (Number)null : (Number)r.minValue, r == null ? (Number)null : (Number)r.maxValue, r == null ? (Number)null : (Number)r.minValue, r == null ? (Number)null : (Number)r.maxValue, r == null ? null : r.minValue.toString(), r == null ? null : r.maxValue.toString(), cs.getNumNulls(), cs.getCountDistint(), null, cs.getAvgColLen(), cs.getAvgColLen(), cs.getNumTrues(), cs.getNumFalses());
        ColumnStatisticsObj cso = new ColumnStatisticsObj(partCol.getName(), partCol.getType(), data);
        colStats.add(cso);
        StatsSetupConst.setColumnStatsState(tableProps, colNames);
    }

    private void getColumnsForNotPartitionKeyColumn(List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, Deserializer deserializer, List<String> colNames, String[] dbTab, Map<String, String> tableProps) throws HiveException {
        cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer));
        List<String> parts = this.context.getDb().getPartitionNames(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), (short)-1);
        AggrStats aggrStats = this.context.getDb().getAggrColStatsFor(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), colNames, parts, false);
        colStats.addAll(aggrStats.getColStats());
        if ((long)parts.size() == aggrStats.getPartsFound()) {
            StatsSetupConst.setColumnStatsState(tableProps, colNames);
        } else {
            StatsSetupConst.removeColumnStatsState(tableProps, colNames);
        }
    }

    private static void fixDecimalColumnTypeName(List<FieldSchema> cols) {
        for (FieldSchema col : cols) {
            if (!"decimal".equals(col.getType())) continue;
            col.setType(DecimalTypeInfo.getQualifiedName(10, 0));
        }
    }

    private void setConstraintsAndStorageHandlerInfo(Table table) throws HiveException {
        if (((DescTableDesc)this.desc).isExtended() || ((DescTableDesc)this.desc).isFormatted()) {
            table.setPrimaryKeyInfo(this.context.getDb().getPrimaryKeys(table.getDbName(), table.getTableName()));
            table.setForeignKeyInfo(this.context.getDb().getForeignKeys(table.getDbName(), table.getTableName()));
            table.setUniqueKeyInfo(this.context.getDb().getUniqueConstraints(table.getDbName(), table.getTableName()));
            table.setNotNullConstraint(this.context.getDb().getNotNullConstraints(table.getDbName(), table.getTableName()));
            table.setDefaultConstraint(this.context.getDb().getDefaultConstraints(table.getDbName(), table.getTableName()));
            table.setCheckConstraint(this.context.getDb().getCheckConstraints(table.getDbName(), table.getTableName()));
            table.setStorageHandlerInfo(this.context.getDb().getStorageHandlerInfo(table));
        }
    }

    private void handleMaterializedView(Table table) throws HiveException {
        String validTxnsList;
        if (table.isMaterializedView() && (validTxnsList = this.context.getDb().getConf().get("hive.txn.valid.txns")) != null) {
            ArrayList<String> tablesUsed = new ArrayList<String>(table.getCreationMetadata().getTablesUsed());
            ValidTxnWriteIdList currentTxnWriteIds = SessionState.get().getTxnMgr().getValidWriteIds(tablesUsed, validTxnsList);
            long defaultTimeWindow = HiveConf.getTimeVar(this.context.getDb().getConf(), HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
            table.setOutdatedForRewriting(Hive.isOutdatedMaterializedView(table, currentTxnWriteIds, defaultTimeWindow, tablesUsed, false));
        }
    }
}

