/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.io.IOUtils;

public class ShowTableStatusOperation
extends DDLOperation<ShowTableStatusDesc> {
    public ShowTableStatusOperation(DDLOperationContext context, ShowTableStatusDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        Map<String, String> part = ((ShowTableStatusDesc)this.desc).getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = this.context.getDb().getTable(((ShowTableStatusDesc)this.desc).getDbName(), ((ShowTableStatusDesc)this.desc).getPattern());
            par = this.context.getDb().getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + ((ShowTableStatusDesc)this.desc).getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.debug("pattern: {}", (Object)((ShowTableStatusDesc)this.desc).getPattern());
            List<String> tblStr = this.context.getDb().getTablesForDb(((ShowTableStatusDesc)this.desc).getDbName(), ((ShowTableStatusDesc)this.desc).getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = this.context.getDb().getTable(((ShowTableStatusDesc)this.desc).getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info("Found {} table(s) matching the SHOW TABLE EXTENDED statement.", (Object)tblStr.size());
        }
        DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowTableStatusDesc)this.desc).getResFile()), this.context);
        try {
            this.context.getFormatter().showTableStatus(outStream, this.context.getDb(), this.context.getConf(), tbls, part, par);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show table status");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

