/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.lock.UnlockTableDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1163})
public class UnlockTableAnalyzer
extends BaseSemanticAnalyzer {
    public UnlockTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String tableName = UnlockTableAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        List<Map<String, String>> partitionSpecs = this.getPartitionSpecs(this.getTable(tableName), root);
        assert (partitionSpecs.size() <= 1);
        Map<String, String> partitionSpec = null;
        if (partitionSpecs.size() > 0) {
            partitionSpec = partitionSpecs.get(0);
        }
        UnlockTableDesc desc = new UnlockTableDesc(tableName, partitionSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.ctx.setNeedLockMgr(true);
    }
}

