/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.properties;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

@DDLSemanticAnalyzerFactory.DDLType(types={787})
public abstract class AbstractAlterTablePropertiesAnalyzer
extends AbstractAlterTableAnalyzer {
    public AbstractAlterTablePropertiesAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Map<String, String> properties = AbstractAlterTablePropertiesAnalyzer.getProps((ASTNode)command.getChild(0).getChild(0));
        boolean updateStats = this.validate(tableName, properties);
        EnvironmentContext environmentContext = null;
        if (updateStats) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("STATS_GENERATED", "USER");
        }
        boolean isToTxn = AcidUtils.isTablePropertyTransactional(properties) || properties.containsKey("transactional_properties");
        boolean isExplicitStatsUpdate = updateStats && AcidUtils.isTransactionalTable(this.getTable(tableName, true));
        AbstractAlterTableDesc desc = this.createDesc(command, tableName, partitionSpec, properties, isToTxn, isExplicitStatsUpdate, environmentContext);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), isToTxn);
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        if (isToTxn) {
            ddlWork.setNeedLock(true);
        }
        if (isToTxn || isExplicitStatsUpdate) {
            this.setAcidDdlDesc(desc);
        }
        this.rootTasks.add(TaskFactory.get(ddlWork));
    }

    private boolean validate(TableName tableName, Map<String, String> properties) throws SemanticException {
        boolean changeStats = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().equals("numRows") || entry.getKey().equals("rawDataSize")) {
                try {
                    Long.parseLong(entry.getValue());
                    changeStats = true;
                    continue;
                }
                catch (Exception e) {
                    throw new SemanticException("AlterTable " + entry.getKey() + " failed with value " + entry.getValue());
                }
            }
            if (entry.getKey().equals("external") && entry.getValue().equals("true")) {
                if (!this.hasConstraintsEnabled(tableName.getTable())) continue;
                throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg(String.format("Table: %s has constraints enabled. Please remove those constraints to change this property.", tableName.getNotEmptyDbTable())));
            }
            if (!this.queryState.getCommandType().equals(HiveOperation.ALTERTABLE_UPDATETABLESTATS.getOperationName()) && !this.queryState.getCommandType().equals(HiveOperation.ALTERTABLE_UPDATEPARTSTATS.getOperationName())) continue;
            throw new SemanticException(String.format("AlterTable UpdateStats %s failed because the only valid keys are %s and %s", entry.getKey(), "numRows", "rawDataSize"));
        }
        return changeStats;
    }

    private boolean hasConstraintsEnabled(String tableName) throws SemanticException {
        NotNullConstraint notNullConstriant = null;
        DefaultConstraint defaultConstraint = null;
        try {
            notNullConstriant = Hive.get().getEnabledNotNullConstraints(this.db.getDatabaseCurrent().getName(), tableName);
            defaultConstraint = Hive.get().getEnabledDefaultConstraints(this.db.getDatabaseCurrent().getName(), tableName);
        }
        catch (Exception e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new RuntimeException(e);
        }
        return notNullConstriant != null && !notNullConstriant.getNotNullConstraints().isEmpty() || defaultConstraint != null && !defaultConstraint.getDefaultConstraints().isEmpty();
    }

    protected abstract AbstractAlterTableDesc createDesc(ASTNode var1, TableName var2, Map<String, String> var3, Map<String, String> var4, boolean var5, boolean var6, EnvironmentContext var7) throws SemanticException;

    protected abstract boolean isView();
}

