/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

abstract class AbstractAddPartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    AbstractAddPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.ADDPARTITION, this.expectView());
        boolean ifNotExists = command.getChild(0).getType() == 925;
        this.outputs.add(new WriteEntity(table, ifNotExists && AcidUtils.isTransactionalTable(table) ? WriteEntity.WriteType.DDL_EXCLUSIVE : WriteEntity.WriteType.DDL_SHARED));
        AlterTableAddPartitionDesc desc = new AlterTableAddPartitionDesc(table.getDbName(), table.getTableName(), ifNotExists);
        this.createPartitions(desc, command, table, ifNotExists);
        if (desc.getPartitionCount() == 0) {
            return;
        }
        Task<DDLWork> ddlTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(ddlTask);
        this.postProcess(tableName, table, desc, ddlTask);
    }

    protected abstract boolean expectView();

    private void createPartitions(AlterTableAddPartitionDesc desc, ASTNode command, Table table, boolean ifNotExists) throws SemanticException {
        int num;
        String currentLocation = null;
        Map<String, String> currentPart = null;
        int n = num = ifNotExists ? 1 : 0;
        while (num < command.getChildCount()) {
            ASTNode child = (ASTNode)command.getChild(num);
            switch (child.getToken().getType()) {
                case 1002: {
                    if (currentPart != null) {
                        this.createPartitionDesc(desc, table, currentLocation, currentPart);
                        currentLocation = null;
                    }
                    currentPart = AbstractAddPartitionAnalyzer.getValidatedPartSpec(table, child, this.conf, true);
                    PartitionUtils.validatePartitions(this.conf, currentPart);
                    break;
                }
                case 1001: {
                    if (!this.allowLocation()) {
                        throw new SemanticException("LOCATION clause illegal for view partition");
                    }
                    currentLocation = AbstractAddPartitionAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    this.inputs.add(this.toReadEntity(currentLocation));
                    break;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
            ++num;
        }
        if (currentPart != null) {
            this.createPartitionDesc(desc, table, currentLocation, currentPart);
        }
    }

    private void createPartitionDesc(AlterTableAddPartitionDesc desc, Table table, String location, Map<String, String> partitionSpec) {
        HashMap<String, String> params = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER) && location == null) {
            params = new HashMap<String, String>();
            StatsSetupConst.setStatsStateForCreateTable(params, MetaStoreUtils.getColumnNames(table.getCols()), "true");
        }
        desc.addPartition(partitionSpec, location, params);
    }

    protected abstract boolean allowLocation();

    protected abstract void postProcess(TableName var1, Table var2, AlterTableAddPartitionDesc var3, Task<DDLWork> var4) throws SemanticException;
}

