/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.drop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

@Explain(displayName="Drop Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableDropPartitionDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TableName tableName;
    private final ArrayList<PartitionDesc> partSpecs;
    private final boolean ifPurge;
    private final ReplicationSpec replicationSpec;
    private Long writeId;

    public AlterTableDropPartitionDesc(TableName tableName, Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs, boolean ifPurge, ReplicationSpec replicationSpec) {
        this.tableName = tableName;
        this.partSpecs = new ArrayList(partSpecs.size());
        for (Map.Entry<Integer, List<ExprNodeGenericFuncDesc>> partSpec : partSpecs.entrySet()) {
            int prefixLength = partSpec.getKey();
            for (ExprNodeGenericFuncDesc expr : partSpec.getValue()) {
                this.partSpecs.add(new PartitionDesc(expr, prefixLength));
            }
        }
        this.ifPurge = ifPurge;
        this.replicationSpec = replicationSpec == null ? new ReplicationSpec() : replicationSpec;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    public ArrayList<PartitionDesc> getPartSpecs() {
        return this.partSpecs;
    }

    public boolean getIfPurge() {
        return this.ifPurge;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public String getFullTableName() {
        return this.getTableName();
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }

    public static class PartitionDesc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ExprNodeGenericFuncDesc partSpec;
        private final int prefixLength;

        public PartitionDesc(ExprNodeGenericFuncDesc partSpec, int prefixLength) {
            this.partSpec = partSpec;
            this.prefixLength = prefixLength;
        }

        public ExprNodeGenericFuncDesc getPartSpec() {
            return this.partSpec;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }
    }
}

