/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1074})
public class ShowPartitionAnalyzer
extends BaseSemanticAnalyzer {
    public ShowPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableName = ShowPartitionAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = partSpecs.size() > 0 ? partSpecs.get(0) : null;
        Table table = this.getTable(HiveTableName.of(tableName));
        this.inputs.add(new ReadEntity(table));
        ShowPartitionsDesc desc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("partition#string"));
    }
}

