/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.archive;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.storage.archive.AlterTableArchiveDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.archive.AlterTableArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class AlterTableArchiveOperation
extends DDLOperation<AlterTableArchiveDesc> {
    public AlterTableArchiveOperation(DDLOperationContext context, AlterTableArchiveDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.context.getDb().getTable(((AlterTableArchiveDesc)this.desc).getTableName());
        if (table.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        Map<String, String> partitionSpec = ((AlterTableArchiveDesc)this.desc).getPartitionSpec();
        ArchiveUtils.PartSpecInfo partitionSpecInfo = ArchiveUtils.PartSpecInfo.create(table, partitionSpec);
        List<Partition> partitions = this.context.getDb().getPartitions(table, partitionSpec);
        Path originalDir = this.getOriginalDir(table, partitionSpecInfo, partitions);
        Path intermediateArchivedDir = AlterTableArchiveUtils.getInterMediateDir(originalDir, this.context.getConf(), HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        Path intermediateOriginalDir = AlterTableArchiveUtils.getInterMediateDir(originalDir, this.context.getConf(), HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        this.context.getConsole().printInfo("intermediate.archived is " + intermediateArchivedDir.toString());
        this.context.getConsole().printInfo("intermediate.original is " + intermediateOriginalDir.toString());
        this.checkIfAlreadyArchived(partitionSpecInfo, partitions);
        boolean recovery = this.isRecovery(intermediateArchivedDir, intermediateOriginalDir);
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.context.getConf());
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!recovery) {
            Path tmpPath = this.createArchiveInTmpDir(table, partitionSpecInfo, originalDir);
            this.moveTmpDirToIntermediateDir(intermediateArchivedDir, fs, tmpPath);
        } else if (HdfsUtils.pathExists(intermediateArchivedDir, this.context.getConf())) {
            this.context.getConsole().printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        this.moveOriginalDirToIntermediateDir(originalDir, intermediateOriginalDir, fs);
        this.moveIntermediateArchivedDirToOriginalParent(originalDir, intermediateArchivedDir, fs);
        this.writeArchivationToMetastore(partitionSpecInfo, partitions, originalDir);
        this.deleteIntermediateOriginalDir(table, intermediateOriginalDir);
        if (recovery) {
            this.context.getConsole().printInfo("Recovery after ARCHIVE succeeded");
        }
        return 0;
    }

    private Path getOriginalDir(Table table, ArchiveUtils.PartSpecInfo partitionSpecInfo, List<Partition> partitions) throws HiveException {
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partitionSpecInfo.values.size() != table.getPartCols().size()) {
            for (Partition partition : partitions) {
                if (!AlterTableArchiveUtils.partitionInCustomLocation(table, partition)) continue;
                throw new HiveException(String.format("ARCHIVE cannot run for partition groups with custom locations like %s", partition.getLocation()));
            }
            return partitionSpecInfo.createPath(table);
        }
        Partition p = partitions.get(0);
        if (ArchiveUtils.isArchived(p)) {
            return new Path(AlterTableArchiveUtils.getOriginalLocation(p));
        }
        return p.getDataLocation();
    }

    private void checkIfAlreadyArchived(ArchiveUtils.PartSpecInfo partitionSpecInfo, List<Partition> partitions) throws HiveException {
        for (Partition partition : partitions) {
            if (!ArchiveUtils.isArchived(partition)) continue;
            if (ArchiveUtils.getArchivingLevel(partition) != partitionSpecInfo.values.size()) {
                String name = ArchiveUtils.getPartialName(partition, ArchiveUtils.getArchivingLevel(partition));
                throw new HiveException(String.format("Conflict with existing archive %s", name));
            }
            throw new HiveException("Partition(s) already archived");
        }
    }

    private boolean isRecovery(Path intermediateArchivedDir, Path intermediateOriginalDir) throws HiveException {
        if (HdfsUtils.pathExists(intermediateArchivedDir, this.context.getConf()) || HdfsUtils.pathExists(intermediateOriginalDir, this.context.getConf())) {
            this.context.getConsole().printInfo("Starting recovery after failed ARCHIVE");
            return true;
        }
        return false;
    }

    private Path createArchiveInTmpDir(Table table, ArchiveUtils.PartSpecInfo partitionSpecInfo, Path originalDir) throws HiveException {
        Path tmpPath = new Path(this.context.getContext().getExternalTmpPath(originalDir), "partlevel");
        this.context.getConsole().printInfo("Creating data.har for " + originalDir.toString() + " in " + tmpPath);
        this.context.getConsole().printInfo("Please wait... (this may take a while)");
        try {
            int maxJobNameLength = this.context.getConf().getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
            String jobName = String.format("Archiving %s@%s", table.getTableName(), partitionSpecInfo.getName());
            jobName = Utilities.abbreviate(jobName, maxJobNameLength - 6);
            this.context.getConf().set("mapreduce.job.name", jobName);
            HadoopArchives har = new HadoopArchives((Configuration)this.context.getConf());
            ImmutableList<String> args = ImmutableList.of("-archiveName", "data.har", "-p", originalDir.toString(), tmpPath.toString());
            int ret = ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return tmpPath;
    }

    private void moveTmpDirToIntermediateDir(Path intermediateArchivedDir, FileSystem fs, Path tmpPath) throws HiveException {
        try {
            this.context.getConsole().printInfo("Moving " + tmpPath + " to " + intermediateArchivedDir);
            if (HdfsUtils.pathExists(intermediateArchivedDir, this.context.getConf())) {
                throw new HiveException("The intermediate archive directory already exists.");
            }
            fs.rename(tmpPath, intermediateArchivedDir);
        }
        catch (IOException e) {
            throw new HiveException("Error while moving tmp directory");
        }
    }

    private void moveOriginalDirToIntermediateDir(Path originalDir, Path intermediateOriginalDir, FileSystem fs) throws HiveException {
        if (!HdfsUtils.pathExists(intermediateOriginalDir, this.context.getConf())) {
            this.context.getConsole().printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.context.getConsole().printInfo(intermediateOriginalDir + " already exists. Assuming it contains the original files in the partition");
        }
    }

    private void moveIntermediateArchivedDirToOriginalParent(Path originalDir, Path intermediateArchivedDir, FileSystem fs) throws HiveException {
        if (!HdfsUtils.pathExists(originalDir, this.context.getConf())) {
            this.context.getConsole().printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.context.getConsole().printInfo(originalDir + " already exists. Assuming it contains the archived version of the partition");
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void writeArchivationToMetastore(ArchiveUtils.PartSpecInfo partitionSpecInfo, List<Partition> partitions, Path originalDir) throws HiveException {
        try {
            URI archiveUri = new Path(originalDir, "data.har").toUri();
            URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
            ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.context.getConf(), archiveUri, originalUri);
            for (Partition partition : partitions) {
                URI originalPartitionUri = ArchiveUtils.addSlash(partition.getDataLocation().toUri());
                URI harPartitionDir = harHelper.getHarUri(originalPartitionUri);
                StringBuilder authority = new StringBuilder();
                if (harPartitionDir.getUserInfo() != null) {
                    authority.append(harPartitionDir.getUserInfo()).append("@");
                }
                authority.append(harPartitionDir.getHost());
                if (harPartitionDir.getPort() != -1) {
                    authority.append(":").append(harPartitionDir.getPort());
                }
                Path harPath = new Path(harPartitionDir.getScheme(), authority.toString(), harPartitionDir.getPath());
                this.setArchived(partition, harPath, partitionSpecInfo.values.size());
                this.context.getDb().alterPartition(((AlterTableArchiveDesc)this.desc).getTableName(), partition, null, true);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
    }

    private void setArchived(Partition p, Path harPath, int level) {
        assert (!ArchiveUtils.isArchived(p));
        AlterTableArchiveUtils.setIsArchived(p, true, level);
        AlterTableArchiveUtils.setOriginalLocation(p, p.getLocation());
        p.setLocation(harPath.toString());
    }

    private void deleteIntermediateOriginalDir(Table table, Path intermediateOriginalDir) throws HiveException {
        if (HdfsUtils.pathExists(intermediateOriginalDir, this.context.getConf())) {
            AlterTableArchiveUtils.deleteDir(intermediateOriginalDir, this.context.getDb().getDatabase(table.getDbName()), this.context.getConf());
        }
    }
}

