/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Set Skewed Location", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableSetSkewedLocationDesc
extends AbstractAlterTableDesc {
    private static final long serialVersionUID = 1L;
    private final Map<List<String>, String> skewedLocations;

    public AlterTableSetSkewedLocationDesc(TableName tableName, Map<String, String> partitionSpec, Map<List<String>, String> skewedLocations) throws SemanticException {
        super(AlterTableType.SET_SKEWED_LOCATION, tableName, partitionSpec, null, false, false, null);
        this.skewedLocations = skewedLocations;
    }

    public Map<List<String>, String> getSkewedLocations() {
        return this.skewedLocations;
    }

    @Explain(displayName="skewed locations", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getSkewedLocationsExplain() {
        return this.skewedLocations.entrySet().stream().map(e -> "(" + e.getKey() + ": " + (String)e.getValue() + ")").collect(Collectors.toList());
    }

    @Override
    public boolean mayNeedWriteId() {
        return false;
    }
}

