/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Skewed By", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableSkewedByDesc
extends AbstractAlterTableDesc {
    private static final long serialVersionUID = 1L;
    private final List<String> skewedColumnNames;
    private final List<List<String>> skewedColumnValues;
    private final boolean isStoredAsDirectories;

    public AlterTableSkewedByDesc(TableName tableName, List<String> skewedColumnNames, List<List<String>> skewedColumnValues, boolean isStoredAsDirectories) throws SemanticException {
        super(AlterTableType.SKEWED_BY, tableName, null, null, false, false, null);
        this.skewedColumnNames = skewedColumnNames;
        this.skewedColumnValues = skewedColumnValues;
        this.isStoredAsDirectories = isStoredAsDirectories;
    }

    @Explain(displayName="skewedColumnNames", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getSkewedColumnNames() {
        return this.skewedColumnNames;
    }

    public List<List<String>> getSkewedColumnValues() {
        return this.skewedColumnValues;
    }

    @Explain(displayName="skewedColumnValues", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getSkewedColumnValuesForExplain() {
        return this.skewedColumnValues.stream().map(l -> l.toString()).collect(Collectors.toList());
    }

    @Explain(displayName="isStoredAsDirectories", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isStoredAsDirectories() {
        return this.isStoredAsDirectories;
    }

    @Override
    public boolean mayNeedWriteId() {
        return false;
    }
}

