/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create View", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateViewDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CreateViewDesc.class);
    private String viewName;
    private List<FieldSchema> schema;
    private String comment;
    private Map<String, String> tblProps;
    private List<String> partColNames;
    private boolean ifNotExists;
    private boolean orReplace;
    private String originalText;
    private String expandedText;
    private boolean rewriteEnabled;
    private List<FieldSchema> partCols;
    private boolean isAlterViewAs;
    private boolean isMaterialized;
    private String inputFormat;
    private String outputFormat;
    private String location;
    private String serde;
    private String storageHandler;
    private Map<String, String> serdeProps;
    private Set<String> tablesUsed;
    private List<String> sortColNames;
    private List<FieldSchema> sortCols;
    private List<String> distributeColNames;
    private List<FieldSchema> distributeCols;
    private ReplicationSpec replicationSpec = null;
    private Long initialMmWriteId;
    private transient FileSinkDesc writer;
    private String ownerName = null;

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, List<String> sortColNames, List<String> distributeColNames, boolean ifNotExists, boolean orReplace, boolean rewriteEnabled, boolean isAlterViewAs, String inputFormat, String outputFormat, String location, String serde, String storageHandler, Map<String, String> serdeProps) {
        this.viewName = viewName;
        this.schema = schema;
        this.comment = comment;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.sortColNames = sortColNames;
        this.distributeColNames = distributeColNames;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
        this.isMaterialized = true;
        this.rewriteEnabled = rewriteEnabled;
        this.isAlterViewAs = isAlterViewAs;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.location = location;
        this.serde = serde;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, boolean ifNotExists, boolean orReplace, boolean isAlterViewAs, String inputFormat, String outputFormat, String serde) {
        this.viewName = viewName;
        this.schema = schema;
        this.comment = comment;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
        this.isAlterViewAs = isAlterViewAs;
        this.isMaterialized = false;
        this.rewriteEnabled = false;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serde = serde;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Explain(displayName="original text", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewOriginalText() {
        return this.originalText;
    }

    public void setViewOriginalText(String originalText) {
        this.originalText = originalText;
    }

    @Explain(displayName="expanded text")
    public String getViewExpandedText() {
        return this.expandedText;
    }

    public void setViewExpandedText(String expandedText) {
        this.expandedText = expandedText;
    }

    @Explain(displayName="rewrite enabled", displayOnlyOnTrue=true)
    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
    }

    @Explain(displayName="columns")
    public List<String> getSchemaString() {
        return Utilities.getFieldSchemaString(this.schema);
    }

    public List<FieldSchema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<FieldSchema> schema) {
        this.schema = schema;
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.partCols);
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    public List<String> getPartColNames() {
        return this.partColNames;
    }

    public void setPartColNames(List<String> partColNames) {
        this.partColNames = partColNames;
    }

    public boolean isOrganized() {
        return this.sortColNames != null && !this.sortColNames.isEmpty() || this.distributeColNames != null && !this.distributeColNames.isEmpty();
    }

    @Explain(displayName="sort columns")
    public List<String> getSortColsString() {
        return Utilities.getFieldSchemaString(this.sortCols);
    }

    public List<FieldSchema> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(List<FieldSchema> sortCols) {
        this.sortCols = sortCols;
    }

    public List<String> getSortColNames() {
        return this.sortColNames;
    }

    public void setSortColNames(List<String> sortColNames) {
        this.sortColNames = sortColNames;
    }

    @Explain(displayName="distribute columns")
    public List<String> getDistributeColsString() {
        return Utilities.getFieldSchemaString(this.distributeCols);
    }

    public List<FieldSchema> getDistributeCols() {
        return this.distributeCols;
    }

    public void setDistributeCols(List<FieldSchema> distributeCols) {
        this.distributeCols = distributeCols;
    }

    public List<String> getDistributeColNames() {
        return this.distributeColNames;
    }

    public void setDistributeColNames(List<String> distributeColNames) {
        this.distributeColNames = distributeColNames;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public Set<String> getTablesUsed() {
        return this.tablesUsed;
    }

    public void setTablesUsed(Set<String> tablesUsed) {
        this.tablesUsed = tablesUsed;
    }

    @Explain(displayName="replace", displayOnlyOnTrue=true)
    public boolean isReplace() {
        return this.orReplace;
    }

    public void setReplace(boolean replace) {
        this.orReplace = replace;
    }

    @Explain(displayName="is alter view as select", displayOnlyOnTrue=true)
    public boolean getIsAlterViewAs() {
        return this.isAlterViewAs;
    }

    public void setIsAlterViewAs(boolean isAlterViewAs) {
        this.isAlterViewAs = isAlterViewAs;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSerde() {
        return this.serde;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String[] names = Utilities.getDbTableName(this.getViewName());
        String databaseName = names[0];
        String tableName = names[1];
        Table tbl = new Table(databaseName, tableName);
        tbl.setViewOriginalText(this.getViewOriginalText());
        tbl.setViewExpandedText(this.getViewExpandedText());
        if (this.isMaterialized()) {
            tbl.setRewriteEnabled(this.isRewriteEnabled());
            tbl.setTableType(TableType.MATERIALIZED_VIEW);
        } else {
            tbl.setTableType(TableType.VIRTUAL_VIEW);
        }
        tbl.setSerializationLib(null);
        tbl.clearSerDeInfo();
        tbl.setFields(this.getSchema());
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.tblProps != null) {
            tbl.getParameters().putAll(this.tblProps);
        }
        if (!CollectionUtils.isEmpty(this.partCols)) {
            tbl.setPartCols(this.partCols);
        }
        if (!CollectionUtils.isEmpty(this.sortColNames)) {
            tbl.setProperty("materializedview.sort.columns", Utilities.encodeColumnNames(this.sortColNames));
        }
        if (!CollectionUtils.isEmpty(this.distributeColNames)) {
            tbl.setProperty("materializedview.distribute.columns", Utilities.encodeColumnNames(this.distributeColNames));
        }
        if (this.getInputFormat() != null) {
            tbl.setInputFormatClass(this.getInputFormat());
        }
        if (this.getOutputFormat() != null) {
            tbl.setOutputFormatClass(this.getOutputFormat());
        }
        if (this.isMaterialized()) {
            String serDeClassName;
            if (this.getLocation() != null) {
                tbl.setDataLocation(new Path(this.getLocation()));
            }
            if (this.getStorageHandler() != null) {
                tbl.setProperty("storage_handler", this.getStorageHandler());
            }
            HiveStorageHandler storageHandler = tbl.getStorageHandler();
            if (this.getSerde() == null) {
                if (storageHandler == null) {
                    serDeClassName = PlanUtils.getDefaultSerDe().getName();
                    LOG.info("Default to {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
                } else {
                    serDeClassName = storageHandler.getSerDeClass().getName();
                    LOG.info("Use StorageHandler-supplied {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
                }
            } else {
                serDeClassName = this.getSerde();
                DDLUtils.validateSerDe(serDeClassName, conf);
            }
            tbl.setSerializationLib(serDeClassName);
            tbl.setInputFormatClass(this.getInputFormat());
            tbl.setOutputFormatClass(this.getOutputFormat());
            if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
                tbl.getSd().setInputFormat(tbl.getInputFormatClass().getName());
            }
            if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
                tbl.getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
            }
        }
        if (this.ownerName != null) {
            tbl.setOwner(this.ownerName);
        }
        StatsSetupConst.setStatsStateForCreateTable(tbl.getTTable().getParameters(), null, "false");
        return tbl;
    }

    public void setInitialMmWriteId(Long mmWriteId) {
        this.initialMmWriteId = mmWriteId;
    }

    public Long getInitialMmWriteId() {
        return this.initialMmWriteId;
    }

    public FileSinkDesc getAndUnsetWriter() {
        FileSinkDesc fsd = this.writer;
        this.writer = null;
        return fsd;
    }

    public void setWriter(FileSinkDesc writer) {
        this.writer = writer;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }
}

